/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.database;

import com.intellij.database.DatabaseMessages;
import com.intellij.database.dataSource.DataSourceTemplate;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.SqliteDialect;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.BasicDbPsiManager;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.GlobalUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.command.undo.UnexpectedUndoException;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import icons.AndroidIcons;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.android.database.AndroidDataSource;
import org.jetbrains.android.database.AndroidDataSourcePropertiesDialog;
import org.jetbrains.android.database.AndroidDataSourceStorage;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidDbManager
extends BasicDbPsiManager<AndroidDataSource> {
    public static final String NOTIFICATION_GROUP_ID = "Android Data Source Manager";
    static final DataSourceTemplate DEFAULT_TEMPLATE = new AndroidDataSourceTemplate();

    public AndroidDbManager(@NotNull DbPsiFacade dbFacade) {
        if (dbFacade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dbFacade", "org/jetbrains/android/database/AndroidDbManager", "<init>"));
        }
        super(dbFacade, AndroidDataSourceStorage.getInstance(dbFacade.getProject()).getDataSources());
    }

    @Nullable
    public DatabaseDialectEx getDatabaseDialect(@NotNull DbDataSource element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/android/database/AndroidDbManager", "getDatabaseDialect"));
        }
        return SqliteDialect.INSTANCE;
    }

    public void setDataSourceName(@NotNull DbDataSource element, String name) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/android/database/AndroidDbManager", "setDataSourceName"));
        }
        if (!(element.getDelegate() instanceof AndroidDataSource)) {
            throw new UnsupportedOperationException();
        }
        AndroidDataSource dataSource = (AndroidDataSource)((Object)element.getDelegate());
        dataSource.setName(name);
        this.myDbFacade.clearCaches(element);
    }

    @NotNull
    public ModificationTracker getModificationTracker(@NotNull DbElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/android/database/AndroidDbManager", "getModificationTracker"));
        }
        AndroidDataSource androidDataSource = (AndroidDataSource)((Object)element.getDataSource().getDelegate());
        if (androidDataSource == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/database/AndroidDbManager", "getModificationTracker"));
        }
        return androidDataSource;
    }

    public void removeDataSource(DbDataSource element) {
        if (!(element.getDelegate() instanceof AndroidDataSource)) {
            throw new UnsupportedOperationException();
        }
        AndroidDataSource dataSource = (AndroidDataSource)((Object)element.getDelegate());
        this.processAddOrRemove(dataSource, false);
    }

    @NotNull
    public Configurable createDataSourceEditor(DbDataSource template) {
        if (!(template.getDelegate() instanceof AndroidDataSource)) {
            throw new UnsupportedOperationException();
        }
        AndroidDataSource dataSource = (AndroidDataSource)((Object)template.getDelegate());
        AndroidDataSourcePropertiesDialog androidDataSourcePropertiesDialog = new AndroidDataSourcePropertiesDialog(this, template.getProject(), dataSource);
        if (androidDataSourcePropertiesDialog == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/database/AndroidDbManager", "createDataSourceEditor"));
        }
        return androidDataSourcePropertiesDialog;
    }

    @NotNull
    public List<DataSourceTemplate> getDataSourceTemplates() {
        if (ProjectFacetManager.getInstance((Project)this.myDbFacade.getProject()).hasFacets(AndroidFacet.ID)) {
            List<DataSourceTemplate> list = Collections.singletonList(DEFAULT_TEMPLATE);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/database/AndroidDbManager", "getDataSourceTemplates"));
            }
            return list;
        }
        List<DataSourceTemplate> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/database/AndroidDbManager", "getDataSourceTemplates"));
        }
        return list;
    }

    @Nullable
    public DataSourceTemplate getDataSourceTemplate(DbDataSource element) {
        return DEFAULT_TEMPLATE;
    }

    public void processAddOrRemove(final AndroidDataSource dataSource, final boolean add) {
        final Project project = this.myDbFacade.getProject();
        GlobalUndoableAction action = new GlobalUndoableAction(){

            public void undo() throws UnexpectedUndoException {
                if (add) {
                    AndroidDbManager.this.removeDataSourceInner(project, dataSource);
                } else {
                    AndroidDbManager.this.addDataSourceInner(project, dataSource);
                }
            }

            public void redo() throws UnexpectedUndoException {
                if (add) {
                    AndroidDbManager.this.addDataSourceInner(project, dataSource);
                } else {
                    AndroidDbManager.this.removeDataSourceInner(project, dataSource);
                }
            }
        };
        String commandName = add ? DatabaseMessages.message((String)"command.name.add.data.source", (Object[])new Object[0]) : DatabaseMessages.message((String)"command.name.remove.data.source", (Object[])new Object[0]);
        new WriteCommandAction(project, commandName, new PsiFile[0], (UndoableAction)action, project){
            final /* synthetic */ UndoableAction val$action;
            final /* synthetic */ Project val$project;
            {
                this.val$action = undoableAction;
                this.val$project = project;
                super(arg0, arg1, arg2);
            }

            protected void run(@NotNull Result result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/android/database/AndroidDbManager$2", "run"));
                }
                this.val$action.redo();
                UndoManager.getInstance((Project)this.val$project).undoableActionPerformed(this.val$action);
            }

            protected UndoConfirmationPolicy getUndoConfirmationPolicy() {
                return UndoConfirmationPolicy.REQUEST_CONFIRMATION;
            }
        }.execute();
    }

    private void removeDataSourceInner(Project project, AndroidDataSource dataSource) {
        AndroidDataSourceStorage storage = AndroidDataSourceStorage.getInstance(project);
        storage.removeDataSource(dataSource);
        this.getElementsMap().remove((Object)dataSource);
        this.clearCaches(null);
    }

    private void addDataSourceInner(Project project, AndroidDataSource dataSource) {
        AndroidDataSourceStorage storage = AndroidDataSourceStorage.getInstance(project);
        storage.addDataSource(dataSource);
        this.getElementsMap().put(dataSource, this.createDataSourceElement(dataSource));
        this.clearCaches(null);
    }

    private void clearCaches(@Nullable DatabaseSystem info) {
        this.myDbFacade.clearCaches(info != null ? this.myDbFacade.findDataSource(info.getUniqueId()) : null);
    }

    public boolean canCreateDataSourceByFiles(Collection<VirtualFile> files) {
        return false;
    }

    @NotNull
    public Collection<DbDataSource> createDataSourceByFiles(Collection<VirtualFile> files) {
        List<DbDataSource> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/database/AndroidDbManager", "createDataSourceByFiles"));
        }
        return list;
    }

    public void fireDataSourceUpdated(DbDataSource element) {
    }

    public void addDataSource(@NotNull AndroidDataSource dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "org/jetbrains/android/database/AndroidDbManager", "addDataSource"));
        }
        this.processAddOrRemove(dataSource, true);
    }

    private static class AndroidDataSourceTemplate
    implements DataSourceTemplate {
        private AndroidDataSourceTemplate() {
        }

        @NotNull
        public String getName() {
            if ("Android SQLite" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/database/AndroidDbManager$AndroidDataSourceTemplate", "getName"));
            }
            return "Android SQLite";
        }

        @NotNull
        public String getFullName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/database/AndroidDbManager$AndroidDataSourceTemplate", "getFullName"));
            }
            return string;
        }

        @NotNull
        public List<DataSourceTemplate> getSubConfigurations() {
            List<DataSourceTemplate> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/database/AndroidDbManager$AndroidDataSourceTemplate", "getSubConfigurations"));
            }
            return list;
        }

        @NotNull
        public DatabaseSystem createDataSource(@NotNull Project project, @Nullable DatabaseSystem copyFrom, @Nullable String newName) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/database/AndroidDbManager$AndroidDataSourceTemplate", "createDataSource"));
            }
            AndroidDataSource result = copyFrom instanceof AndroidDataSource ? ((AndroidDataSource)copyFrom).copy() : new AndroidDataSource();
            result.setName(StringUtil.notNullize((String)newName, (String)this.getName()));
            result.resolveDriver();
            AndroidDataSource androidDataSource = result;
            if (androidDataSource == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/database/AndroidDbManager$AndroidDataSourceTemplate", "createDataSource"));
            }
            return androidDataSource;
        }

        public Icon getIcon(@Iconable.IconFlags int flags) {
            return AndroidIcons.Android;
        }
    }
}

