/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration.intentions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.AllowedApiFilterExtension;
import com.intellij.psi.impl.PsiDiamondTypeUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.typeMigration.TypeConversionDescriptor;
import com.intellij.refactoring.typeMigration.TypeMigrationLabeler;
import com.intellij.refactoring.typeMigration.TypeMigrationReplacementUtil;
import com.intellij.refactoring.typeMigration.TypeMigrationRules;
import com.intellij.refactoring.typeMigration.rules.ThreadLocalConversionRule;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class ConvertFieldToThreadLocalIntention
extends PsiElementBaseIntentionAction
implements LowPriorityAction {
    private static final Logger LOG = Logger.getInstance((String)("#" + ConvertFieldToThreadLocalIntention.class.getName()));

    @NotNull
    public String getText() {
        if ("Convert to ThreadLocal" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/typeMigration/intentions/ConvertFieldToThreadLocalIntention", "getText"));
        }
        return "Convert to ThreadLocal";
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/typeMigration/intentions/ConvertFieldToThreadLocalIntention", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/typeMigration/intentions/ConvertFieldToThreadLocalIntention", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/typeMigration/intentions/ConvertFieldToThreadLocalIntention", "isAvailable"));
        }
        if (!(element instanceof PsiIdentifier)) {
            return false;
        }
        PsiField psiField = (PsiField)PsiTreeUtil.getParentOfType((PsiElement)element, PsiField.class);
        if (psiField == null) {
            return false;
        }
        if (psiField.getLanguage() != JavaLanguage.INSTANCE) {
            return false;
        }
        if (psiField.getTypeElement() == null) {
            return false;
        }
        PsiType fieldType = psiField.getType();
        PsiClass fieldTypeClass = PsiUtil.resolveClassInType((PsiType)fieldType);
        if (fieldType instanceof PsiPrimitiveType && !PsiType.VOID.equals((Object)fieldType) || fieldType instanceof PsiArrayType) {
            return true;
        }
        return fieldTypeClass != null && !Comparing.strEqual((String)fieldTypeClass.getQualifiedName(), (String)ThreadLocal.class.getName()) && AllowedApiFilterExtension.isClassAllowed((String)ThreadLocal.class.getName(), (PsiElement)element);
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/typeMigration/intentions/ConvertFieldToThreadLocalIntention", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/typeMigration/intentions/ConvertFieldToThreadLocalIntention", "invoke"));
        }
        PsiField psiField = (PsiField)PsiTreeUtil.getParentOfType((PsiElement)element, PsiField.class);
        LOG.assertTrue(psiField != null);
        Query refs = ReferencesSearch.search((PsiElement)psiField);
        HashSet<PsiElement> elements = new HashSet<PsiElement>();
        elements.add(element);
        for (PsiReference reference : refs) {
            elements.add(reference.getElement());
        }
        if (!FileModificationService.getInstance().preparePsiElementsForWrite(elements)) {
            return;
        }
        psiField.normalizeDeclaration();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        PsiType fromType = psiField.getType();
        PsiClass threadLocalClass = psiFacade.findClass(ThreadLocal.class.getName(), GlobalSearchScope.allScope((Project)project));
        if (threadLocalClass == null) {
            return;
        }
        HashMap substitutor = ContainerUtil.newHashMap();
        PsiTypeParameter[] typeParameters = threadLocalClass.getTypeParameters();
        if (typeParameters.length == 1) {
            PsiType type = fromType;
            if (fromType instanceof PsiPrimitiveType) {
                type = ((PsiPrimitiveType)fromType).getBoxedType(element);
            }
            substitutor.put(typeParameters[0], type);
        }
        PsiClassType toType = factory.createType(threadLocalClass, factory.createSubstitutor((Map)substitutor));
        try {
            TypeMigrationRules rules = new TypeMigrationRules(fromType);
            rules.setMigrationRootType((PsiType)toType);
            rules.setBoundScope((SearchScope)GlobalSearchScope.fileScope((PsiFile)element.getContainingFile()));
            TypeMigrationLabeler labeler = new TypeMigrationLabeler(rules);
            labeler.getMigratedUsages(false, new PsiElement[]{psiField});
            for (PsiReference reference : refs) {
                TypeConversionDescriptor conversion;
                PsiElement psiElement = reference.getElement();
                if (!(psiElement instanceof PsiExpression)) continue;
                PsiElement parent = psiElement.getParent();
                if (parent instanceof PsiExpression && !(parent instanceof PsiReferenceExpression) && !(parent instanceof PsiPolyadicExpression)) {
                    psiElement = parent;
                }
                if ((conversion = ThreadLocalConversionRule.findDirectConversion(psiElement, (PsiType)toType, fromType, labeler)) == null) continue;
                TypeMigrationReplacementUtil.replaceExpression((PsiExpression)((PsiExpression)psiElement), (Project)project, (Object)((Object)conversion));
            }
            PsiExpression initializer = psiField.getInitializer();
            if (initializer == null) {
                PsiType type = psiField.getType();
                String initializerText = null;
                if (PsiType.BOOLEAN.equals((Object)type)) {
                    initializerText = "false";
                } else if (type instanceof PsiPrimitiveType) {
                    initializerText = "0";
                }
                if (initializerText != null) {
                    psiField.setInitializer(factory.createExpressionFromText(initializerText, (PsiElement)psiField));
                    initializer = psiField.getInitializer();
                }
            }
            if (initializer != null) {
                if (initializer instanceof PsiArrayInitializerExpression) {
                    PsiExpression normalizedExpr = RefactoringUtil.createNewExpressionFromArrayInitializer((PsiArrayInitializerExpression)((PsiArrayInitializerExpression)initializer), (PsiType)psiField.getType());
                    initializer = (PsiExpression)initializer.replace((PsiElement)normalizedExpr);
                }
                TypeConversionDescriptor conversion = ThreadLocalConversionRule.wrapWithNewExpression((PsiType)toType, fromType, initializer);
                TypeMigrationReplacementUtil.replaceExpression((PsiExpression)initializer, (Project)project, (Object)((Object)conversion));
                CodeStyleManager.getInstance((Project)project).reformat((PsiElement)psiField);
            } else if (!((PsiModifierList)ObjectUtils.assertNotNull((Object)psiField.getModifierList())).hasModifierProperty("final")) {
                String text = "new " + PsiDiamondTypeUtil.getCollapsedType((PsiType)toType, (PsiElement)psiField) + "()";
                PsiExpression newInitializer = factory.createExpressionFromText(text, (PsiElement)psiField);
                psiField.setInitializer(newInitializer);
            }
            ((PsiTypeElement)ObjectUtils.assertNotNull((Object)psiField.getTypeElement())).replace((PsiElement)factory.createTypeElement((PsiType)toType));
            PsiModifierList modifierList = (PsiModifierList)ObjectUtils.assertNotNull((Object)psiField.getModifierList());
            modifierList.setModifierProperty("final", true);
            modifierList.setModifierProperty("volatile", false);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    public boolean startInWriteAction() {
        return true;
    }
}

