/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.jboss.arquillian.configuration.persistent;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.plugins.jboss.arquillian.configuration.ArquillianContainersAppManager;
import com.intellij.plugins.jboss.arquillian.configuration.model.ArquillianContainersModel;
import com.intellij.plugins.jboss.arquillian.configuration.persistent.ArquillianContainerState;
import com.intellij.plugins.jboss.arquillian.configuration.persistent.ArquillianContainersState;
import com.intellij.util.containers.JBIterable;
import org.jetbrains.annotations.NotNull;

@State(name="ArquillianContainersManager", storages={@Storage(file="$PROJECT_FILE$"), @Storage(scheme=StorageScheme.DIRECTORY_BASED, file="$PROJECT_CONFIG_DIR$/arquillianContainers.xml")})
public class ArquillianContainersManager
implements PersistentStateComponent<ArquillianContainersState> {
    @NotNull
    private final Project project;
    @NotNull
    private final ArquillianContainersAppManager appManager;
    private ArquillianContainersState state;

    public ArquillianContainersManager(@NotNull ArquillianContainersAppManager appManager, @NotNull Project project) {
        if (appManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "appManager", "com/intellij/plugins/jboss/arquillian/configuration/persistent/ArquillianContainersManager", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/plugins/jboss/arquillian/configuration/persistent/ArquillianContainersManager", "<init>"));
        }
        this.state = new ArquillianContainersState();
        this.appManager = appManager;
        this.project = project;
    }

    @NotNull
    public static ArquillianContainersManager getInstance(Project project) {
        ArquillianContainersManager arquillianContainersManager = (ArquillianContainersManager)ServiceManager.getService((Project)project, ArquillianContainersManager.class);
        if (arquillianContainersManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/jboss/arquillian/configuration/persistent/ArquillianContainersManager", "getInstance"));
        }
        return arquillianContainersManager;
    }

    @NotNull
    public ArquillianContainersState getState() {
        ArquillianContainersState arquillianContainersState = this.state;
        if (arquillianContainersState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/jboss/arquillian/configuration/persistent/ArquillianContainersManager", "getState"));
        }
        return arquillianContainersState;
    }

    public void loadState(ArquillianContainersState state) {
        this.state = state;
    }

    public void saveContainersModel(ArquillianContainersModel containersModel) {
        this.state.containers = containersModel.getChildrenStates();
    }

    public boolean hasChanges(ArquillianContainersModel containersModel) {
        return containersModel.hasChanges(this.state);
    }

    public ArquillianContainerState findStateByName(final String name) {
        return (ArquillianContainerState)JBIterable.from(this.state.containers).filter((Condition)new Condition<ArquillianContainerState>(){

            public boolean value(ArquillianContainerState state) {
                return Comparing.equal((String)name, (String)state.getName());
            }
        }).first();
    }
}

