/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.jboss.arquillian.runConfiguration;

import com.intellij.execution.ExecutionAdapter;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.WrappingRunConfiguration;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.maven.dependencies.MavenManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.plugins.jboss.arquillian.ArquillianBundle;
import com.intellij.plugins.jboss.arquillian.configuration.persistent.ArquillianContainerState;
import com.intellij.plugins.jboss.arquillian.configuration.persistent.ArquillianContainersManager;
import com.intellij.plugins.jboss.arquillian.configuration.persistent.ArquillianExistLibraryState;
import com.intellij.plugins.jboss.arquillian.configuration.persistent.ArquillianLibraryState;
import com.intellij.plugins.jboss.arquillian.configuration.persistent.ArquillianMavenLibraryState;
import com.intellij.plugins.jboss.arquillian.runConfiguration.ArquillianRunConfiguration;
import com.intellij.plugins.jboss.arquillian.runConfiguration.ArquillianTestFrameworkRunConfiguration;
import com.intellij.util.messages.MessageBus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.utils.library.remote.MavenDependenciesRemoteManager;

public abstract class ArquillianRunConfigurationType
implements ConfigurationType {
    static {
        MessageBus messageBus = ApplicationManager.getApplication().getMessageBus();
        messageBus.connect().subscribe(ExecutionManager.EXECUTION_TOPIC, (Object)new ExecutionAdapter(){

            public void processStarting(String executorId, final @NotNull ExecutionEnvironment env) {
                if (env == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/intellij/plugins/jboss/arquillian/runConfiguration/ArquillianRunConfigurationType$1", "processStarting"));
                }
                RunProfile runProfile = env.getRunProfile();
                while (runProfile instanceof WrappingRunConfiguration) {
                    runProfile = ((WrappingRunConfiguration)runProfile).getPeer();
                }
                if (!(runProfile instanceof ArquillianTestFrameworkRunConfiguration)) {
                    return;
                }
                ArquillianRunConfiguration arquillianRunConfiguration = ((ArquillianTestFrameworkRunConfiguration)runProfile).getRunConfiguration();
                ArquillianContainerState containerState = ArquillianContainersManager.getInstance(env.getProject()).findStateByName(arquillianRunConfiguration.getContainerStateName());
                if (containerState == null) {
                    throw new ProcessCanceledException();
                }
                if (MavenDependenciesRemoteManager.getInstance((Project)env.getProject()).busy()) {
                    ExecutionUtil.handleExecutionError((Project)env.getProject(), (String)env.getExecutor().getToolWindowId(), (RunProfile)env.getRunProfile(), (ExecutionException)new ExecutionException(ArquillianBundle.message("arquillian.run.failed.due.to.maven.activity", new Object[0])));
                    throw new ProcessCanceledException();
                }
                for (ArquillianLibraryState library : containerState.libraries) {
                    final RunProfile finalRunProfile = runProfile;
                    library.accept(new ArquillianLibraryState.Visitor<Void>(){

                        @Override
                        public Void visitMavenLibrary(ArquillianMavenLibraryState state) {
                            try {
                                MavenManager.getInstance().getOrLoadMavenArtifactJars(env.getProject(), state.groupId, state.artifactId, state.version, state.downloadSources, state.downloadJavaDocs);
                            }
                            catch (ExecutionException e) {
                                ExecutionUtil.handleExecutionError((Project)env.getProject(), (String)env.getExecutor().getToolWindowId(), (RunProfile)finalRunProfile, (ExecutionException)e);
                                throw new ProcessCanceledException((Throwable)e);
                            }
                            return null;
                        }

                        @Override
                        public Void visitExistLibrary(ArquillianExistLibraryState state) {
                            return null;
                        }
                    });
                }
            }
        });
    }
}

