/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.utils;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.execution.ui.actions.CloseAction;
import com.intellij.facet.FacetManager;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.javaee.artifact.JavaeeArtifactUtil;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.web.WebRoot;
import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.JavaAwareProjectJdkTableImpl;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.jsp.WebDirectoryElement;
import com.intellij.util.DocumentUtil;
import com.intellij.ws.engines.LibraryDescriptor;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Properties;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommonWsUtils {
    @NonNls
    public static final String FILE_URL_PREFIX = "file:";
    @NonNls
    static final String marker = "// Please, do not remove this line from file template, here invocation of web service will be inserted";
    public static Logger LOG = Logger.getInstance((String)"webservicesplugin.enablewssupport");
    public static final boolean hasJ2EE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static VirtualFile addFileToModuleFromTemplate(final @NotNull String[] pathComponents, final @NotNull InputStream templateInputStream, final boolean createInContentRoot, final boolean overwriteExisitingFile, VirtualFile[] sourceRoots, final WebFacet webFacet) {
        if (pathComponents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathComponents", "com/intellij/ws/utils/CommonWsUtils", "addFileToModuleFromTemplate"));
        }
        if (templateInputStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateInputStream", "com/intellij/ws/utils/CommonWsUtils", "addFileToModuleFromTemplate"));
        }
        if (sourceRoots.length == 0) {
            VirtualFile virtualFile = null;
            return virtualFile;
        }
        final VirtualFile[] sourceRoots1 = sourceRoots;
        VirtualFile virtualFile = (VirtualFile)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<VirtualFile>(){

            public VirtualFile compute() {
                VirtualFile[] fileComponents = new VirtualFile[pathComponents.length];
                int i = 0;
                if (createInContentRoot && hasJ2EE && webFacet != null) {
                    for (i = fileComponents.length - 1; i >= 0; --i) {
                        String string = CommonWsUtils.buildPath(pathComponents, i + 1);
                        for (WebRoot webRoot : webFacet.getWebRoots()) {
                            VirtualFile virtualFile;
                            VirtualFile webRootFile = webRoot.getFile();
                            if (webRootFile == null || (virtualFile = webRootFile.findFileByRelativePath(string)) == null) continue;
                            fileComponents[i] = virtualFile;
                            break;
                        }
                        if (fileComponents[i] == null) continue;
                        ++i;
                        break;
                    }
                } else {
                    for (VirtualFile file : sourceRoots1) {
                        for (i = 0; i < fileComponents.length; ++i) {
                            fileComponents[i] = (i == 0 ? file : fileComponents[i - 1]).findFileByRelativePath(pathComponents[i]);
                            if (fileComponents[i] == null) break;
                        }
                        if (i <= 0) {
                            continue;
                        }
                        break;
                    }
                }
                try {
                    boolean bl;
                    boolean bl2;
                    boolean bl3 = bl2 = i == fileComponents.length;
                    if (bl2 && overwriteExisitingFile) {
                        bl = false;
                    }
                    for (int j = Math.max(i, 0); j < fileComponents.length; ++j) {
                        VirtualFile parentVirtualFile = j == 0 ? sourceRoots1[0] : fileComponents[j - 1];
                        LOG.assertTrue(parentVirtualFile != null, (Object)("src: " + sourceRoots1[0] + "; file component: " + (j == 0 ? "<no>" : fileComponents[j - 1])));
                        fileComponents[j] = j + 1 != fileComponents.length ? parentVirtualFile.createChildDirectory((Object)LocalFileSystem.getInstance(), pathComponents[j]) : parentVirtualFile.createChildData((Object)LocalFileSystem.getInstance(), pathComponents[j]);
                    }
                    if (fileComponents[fileComponents.length - 1] != null && !bl) {
                        OutputStream outputStream = fileComponents[fileComponents.length - 1].getOutputStream((Object)this);
                        FileUtil.copy((InputStream)templateInputStream, (OutputStream)outputStream);
                        outputStream.flush();
                        outputStream.close();
                        return fileComponents[fileComponents.length - 1];
                    }
                }
                catch (IOException iOException) {
                    LOG.error((Throwable)iOException);
                }
                return null;
            }
        });
        return virtualFile;
        finally {
            try {
                templateInputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Nullable
    public static VirtualFile addFileToModuleFromTemplate(@NotNull Module module, @NotNull String[] pathComponents, @NotNull InputStream templateInputStream, boolean createInContentRoot, boolean overwriteExisitingFile, WebFacet webFacet) {
        VirtualFile[] sourceRoots;
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/ws/utils/CommonWsUtils", "addFileToModuleFromTemplate"));
        }
        if (pathComponents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathComponents", "com/intellij/ws/utils/CommonWsUtils", "addFileToModuleFromTemplate"));
        }
        if (templateInputStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateInputStream", "com/intellij/ws/utils/CommonWsUtils", "addFileToModuleFromTemplate"));
        }
        ModuleRootManager moduleManager = ModuleRootManager.getInstance((Module)module);
        if (createInContentRoot) {
            if (hasJ2EE && webFacet != null) {
                ArrayList<VirtualFile> roots = new ArrayList<VirtualFile>();
                for (WebRoot webRoot : webFacet.getWebRoots()) {
                    roots.add(webRoot.getFile());
                }
                sourceRoots = VfsUtilCore.toVirtualFileArray(roots);
                if (sourceRoots.length == 0) {
                    sourceRoots = moduleManager.getContentRoots();
                }
            } else {
                sourceRoots = moduleManager.getContentRoots();
            }
        } else {
            sourceRoots = moduleManager.getSourceRoots();
        }
        return CommonWsUtils.addFileToModuleFromTemplate(pathComponents, templateInputStream, createInContentRoot, overwriteExisitingFile, sourceRoots, webFacet);
    }

    @Nullable
    public static VirtualFile addFileToModuleFromTemplate(@NotNull Module module, @NotNull String[] pathComponents, @NotNull InputStream templateInputStream, boolean createInContentRoot, boolean overwriteExisitingFile) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/ws/utils/CommonWsUtils", "addFileToModuleFromTemplate"));
        }
        if (pathComponents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathComponents", "com/intellij/ws/utils/CommonWsUtils", "addFileToModuleFromTemplate"));
        }
        if (templateInputStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateInputStream", "com/intellij/ws/utils/CommonWsUtils", "addFileToModuleFromTemplate"));
        }
        return CommonWsUtils.addFileToModuleFromTemplate(module, pathComponents, templateInputStream, createInContentRoot, overwriteExisitingFile, (WebFacet)FacetManager.getInstance((Module)module).getFacetByType(WebFacet.ID));
    }

    private static String buildPath(String[] pathComponents, int last) {
        StringBuilder pathBuilder = new StringBuilder();
        for (int i = 0; i < last; ++i) {
            String pathComponent = pathComponents[i];
            if (pathBuilder.length() > 0) {
                pathBuilder.append('/');
            }
            pathBuilder.append(pathComponent);
        }
        return pathBuilder.toString();
    }

    @Nullable
    public static VirtualFile findFileByPath(Module module, String[] pathComponents, boolean findInContentRoot) {
        VirtualFile[] sourceRoots;
        WebFacet webFacet;
        ModuleRootManager moduleManager = ModuleRootManager.getInstance((Module)module);
        if (hasJ2EE && findInContentRoot && (webFacet = (WebFacet)FacetManager.getInstance((Module)module).getFacetByType(WebFacet.ID)) != null) {
            String relativePath = CommonWsUtils.buildPath(pathComponents, pathComponents.length);
            for (WebRoot webRoot : webFacet.getWebRoots()) {
                VirtualFile virtualFile;
                VirtualFile webRootFile = webRoot.getFile();
                if (webRootFile == null || (virtualFile = webRootFile.findFileByRelativePath(relativePath)) == null) continue;
                return virtualFile;
            }
            WebDirectoryElement element = CommonWsUtils.findWebDirectoryByElement(relativePath, webFacet);
            if (element != null) {
                return element.getOriginalVirtualFile();
            }
            return null;
        }
        VirtualFile[] virtualFileArray = sourceRoots = findInContentRoot ? moduleManager.getContentRoots() : moduleManager.getSourceRoots();
        if (sourceRoots.length == 0) {
            return null;
        }
        VirtualFile[] virtualFileArray2 = sourceRoots;
        int n = virtualFileArray2.length;
        for (int i = 0; i < n; ++i) {
            String pathComponent;
            VirtualFile file;
            VirtualFile current = file = virtualFileArray2[i];
            String[] stringArray = pathComponents;
            int n2 = stringArray.length;
            for (int j = 0; j < n2 && (current = current.findChild(pathComponent = stringArray[j])) != null; ++j) {
            }
            if (current == null) continue;
            return current;
        }
        return null;
    }

    public static boolean isWebModule(Module module) {
        return hasJ2EE && FacetManager.getInstance((Module)module).getFacetByType(WebFacet.ID) != null;
    }

    @Nullable
    public static WebDirectoryElement findWebDirectoryByElement(String path, WebFacet webFacet) {
        if (!hasJ2EE) {
            return null;
        }
        if (webFacet == null) {
            return null;
        }
        return WebUtil.getWebUtil().findWebDirectoryElement(path, webFacet);
    }

    public static void setupLibsForDeployment(Module currentModule, LibraryDescriptor[] libInfos) {
        CommonWsUtils.setupLibsForDeployment(currentModule, libInfos, (WebFacet)FacetManager.getInstance((Module)currentModule).getFacetByType(WebFacet.ID));
    }

    public static void setupLibsForDeployment(Module currentModule, LibraryDescriptor[] libInfos, final WebFacet facet) {
        if (!hasJ2EE) {
            return;
        }
        if (facet == null) {
            return;
        }
        LibraryTable projectLibraryTable = LibraryTablesRegistrar.getInstance().getLibraryTable(currentModule.getProject());
        for (LibraryDescriptor libInfo : libInfos) {
            Library library;
            String libraryName;
            if (!libInfo.isToIncludeInJavaEEContainerDeployment() || (libraryName = libInfo.getName()) == null || (library = projectLibraryTable.getLibraryByName(libraryName)) == null) continue;
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    JavaeeArtifactUtil.getInstance().addLibraryToAllArtifactsContainingFacet(library, (JavaeeFacet)facet);
                }
            });
        }
    }

    public static boolean hasJ2EE() {
        return hasJ2EE;
    }

    public static String getFromFileTemplateWithCustomParameters(Project project, String templateName, String ... additionalParameters) {
        Properties properties = FileTemplateManager.getInstance((Project)project).getDefaultProperties();
        if (additionalParameters != null) {
            for (int i = 0; i < additionalParameters.length; ++i) {
                String paramName = additionalParameters[i];
                if (i + 1 >= additionalParameters.length) continue;
                properties.put(paramName, additionalParameters[++i]);
            }
        }
        FileTemplate fileTemplate = FileTemplateManager.getInstance((Project)project).getJ2eeTemplate(templateName);
        assert (fileTemplate != null);
        try {
            return fileTemplate.getText(properties);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getDefaultClientCode(Project project, String packageQName, String className, String templateName) {
        return CommonWsUtils.getFromFileTemplateWithCustomParameters(project, templateName, "PACKAGE_NAME", packageQName, "CLASS_NAME", className);
    }

    public static void runTemplate(final @NotNull Editor editor, final String templateName) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/ws/utils/CommonWsUtils", "runTemplate"));
        }
        CommonWsUtils.doFileSystemRefresh();
        final int i = editor.getDocument().getText().indexOf(marker);
        assert (i != -1) : "Web Services Client template does not have insertion point // Please, do not remove this line from file template, here invocation of web service will be inserted";
        editor.getCaretModel().moveToOffset(i);
        DocumentUtil.writeInRunUndoTransparentAction((Runnable)new Runnable(){

            @Override
            public void run() {
                editor.getDocument().replaceString(i, i + CommonWsUtils.marker.length(), (CharSequence)"");
            }
        });
        final Project project = editor.getProject();
        assert (project != null);
        DumbService.getInstance((Project)project).runWhenSmart(new Runnable(){

            @Override
            public void run() {
                TemplateImpl template = TemplateSettings.getInstance().getTemplate(templateName, "Web Services");
                if (template != null) {
                    TemplateManager.getInstance((Project)project).startTemplate(editor, (Template)template);
                } else {
                    new Exception("Unexpected branch").printStackTrace();
                }
            }
        });
    }

    public static void doFileSystemRefresh() {
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                VirtualFileManager.getInstance().syncRefresh();
            }
        });
    }

    public static void scanFile(File file, FileProcessor processor) throws IOException {
        LineNumberReader reader = new LineNumberReader(new InputStreamReader(new BufferedInputStream(new FileInputStream(file))));
        CommonWsUtils.doScanFile(reader, processor);
    }

    public static void doScanFile(LineNumberReader reader, FileProcessor processor) throws IOException {
        String s = reader.readLine();
        while (s != null && processor.process(s)) {
            s = reader.readLine();
        }
        reader.close();
        processor.fileScanningEnded();
    }

    public static String getVMExecutablePathForSdk(@NotNull Sdk jdk) {
        if (jdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jdk", "com/intellij/ws/utils/CommonWsUtils", "getVMExecutablePathForSdk"));
        }
        return ((JavaSdkType)jdk.getSdkType()).getVMExecutablePath(jdk);
    }

    public static String getToolsJarPathForSdk(@NotNull Sdk jdk) {
        if (jdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jdk", "com/intellij/ws/utils/CommonWsUtils", "getToolsJarPathForSdk"));
        }
        return ((JavaSdkType)jdk.getSdkType()).getToolsPath(jdk);
    }

    public static boolean isAcceptableSdk(@Nullable Sdk jdk) {
        return jdk != null && jdk.getSdkType() instanceof JavaSdkType;
    }

    public static CloseAction createRunnerAction(RunContentDescriptor myDescriptor, Project project) {
        return new CloseAction(DefaultRunExecutor.getRunExecutorInstance(), myDescriptor, project);
    }

    public static void showRunContent(@NotNull RunContentManager contentManager, RunContentDescriptor myDescriptor) {
        if (contentManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentManager", "com/intellij/ws/utils/CommonWsUtils", "showRunContent"));
        }
        contentManager.showRunContent(DefaultRunExecutor.getRunExecutorInstance(), myDescriptor);
    }

    public static Sdk getInternalJdk() {
        return JavaAwareProjectJdkTableImpl.getInstanceEx().getInternalJdk();
    }

    static {
        boolean EE = false;
        try {
            Class.forName("com.intellij.javaee.web.facet.WebFacet");
            IdeaPluginDescriptor ideaPluginDescriptor = PluginManager.getPlugin((PluginId)PluginId.getId((String)"com.intellij.javaee"));
            if (ideaPluginDescriptor != null && !PluginManager.shouldSkipPlugin((IdeaPluginDescriptor)ideaPluginDescriptor)) {
                EE = true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        finally {
            hasJ2EE = EE;
        }
    }

    public static interface FileProcessor {
        public void fileScanningEnded() throws IOException;

        public boolean process(String var1) throws IOException;
    }
}

