/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.core.maven;

import com.intellij.tapestry.core.maven.MavenConfiguration;
import com.intellij.tapestry.core.maven.RemoteRepositoryDescription;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Repository;
import org.apache.maven.model.RepositoryPolicy;
import org.apache.maven.model.Resource;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;

public class MavenUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createMavenSupport(String path, MavenConfiguration mavenConfiguration, String tapestryVersion) throws IOException {
        File file = new File(path + "/pom.xml");
        MavenXpp3Writer mavenXpp3Writer = new MavenXpp3Writer();
        Model model = new Model();
        model.setModelVersion("4.0.0");
        model.setPackaging("war");
        model.setGroupId(mavenConfiguration.getGroupId());
        model.setArtifactId(mavenConfiguration.getArtifactId());
        if (mavenConfiguration.getVersion() != null && mavenConfiguration.getVersion().length() > 0) {
            model.setVersion(mavenConfiguration.getVersion());
        } else {
            model.setVersion("1.0-SNAPSHOT");
        }
        Dependency dependency = new Dependency();
        dependency.setGroupId("org.apache.tapestry");
        dependency.setArtifactId("tapestry-core");
        dependency.setVersion(tapestryVersion);
        model.addDependency(dependency);
        Build build = new Build();
        Resource resource = new Resource();
        resource.setDirectory("src/main/java");
        resource.addInclude("**/*.tml");
        resource.addInclude("**/*.properties");
        build.addResource(resource);
        model.setBuild(build);
        if (mavenConfiguration.isCreateParentPom()) {
            Parent parent = new Parent();
            parent.setArtifactId(mavenConfiguration.getArtifactIdParentPom());
            parent.setGroupId(mavenConfiguration.getGroupIdParentPom());
            parent.setVersion(mavenConfiguration.getVersionParentPom());
            model.setParent(parent);
        }
        if (mavenConfiguration.isAddRemoteRepository()) {
            for (RemoteRepositoryDescription repositoryDescription : mavenConfiguration.getRemoteRepositoryList()) {
                Repository repository = new Repository();
                RepositoryPolicy repositoryPolicyReleases = new RepositoryPolicy();
                repositoryPolicyReleases.setEnabled(true);
                RepositoryPolicy repositoryPolicySnapshots = new RepositoryPolicy();
                repositoryPolicySnapshots.setEnabled(true);
                repository.setName(repositoryDescription.getName());
                repository.setId(repositoryDescription.getId());
                repository.setUrl(repositoryDescription.getUrl());
                repositoryPolicyReleases.setEnabled(repositoryDescription.isCreatingReleases());
                repository.setReleases(repositoryPolicyReleases);
                repositoryPolicySnapshots.setEnabled(repositoryDescription.isCreatingSnapshots());
                repository.setSnapshots(repositoryPolicySnapshots);
                model.addRepository(repository);
            }
        }
        FileWriter fileWriter = new FileWriter(file);
        try {
            mavenXpp3Writer.write((Writer)fileWriter, model);
        }
        finally {
            fileWriter.close();
        }
    }
}

