/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.intellij.facet;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeId;
import com.intellij.framework.detection.FacetBasedFrameworkDetector;
import com.intellij.framework.detection.FileContentPattern;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.JavaModuleType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.tapestry.core.TapestryConstants;
import com.intellij.tapestry.intellij.facet.TapestryFacet;
import com.intellij.tapestry.intellij.facet.TapestryFacetConfiguration;
import com.intellij.tapestry.intellij.facet.TapestryFrameworkSupportProvider;
import com.intellij.tapestry.intellij.facet.TapestryVersion;
import com.intellij.tapestry.lang.TmlFileType;
import com.intellij.util.indexing.FileContent;
import icons.TapestryIcons;
import java.util.Arrays;
import java.util.HashSet;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TapestryFacetType
extends FacetType<TapestryFacet, TapestryFacetConfiguration> {
    public static final FacetTypeId<TapestryFacet> ID = new FacetTypeId("tapestry");

    TapestryFacetType() {
        super(ID, "tapestry", "Tapestry");
    }

    public static TapestryFacetType getInstance() {
        return (TapestryFacetType)TapestryFacetType.findInstance(TapestryFacetType.class);
    }

    public TapestryFacetConfiguration createDefaultConfiguration() {
        return new TapestryFacetConfiguration();
    }

    public TapestryFacet createFacet(@NotNull Module module, String name, @NotNull TapestryFacetConfiguration configuration, @Nullable Facet underlyingFacet) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/tapestry/intellij/facet/TapestryFacetType", "createFacet"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/tapestry/intellij/facet/TapestryFacetType", "createFacet"));
        }
        return new TapestryFacet(this, module, name, configuration, underlyingFacet);
    }

    public boolean isSuitableModuleType(ModuleType moduleType) {
        return moduleType instanceof JavaModuleType;
    }

    public Icon getIcon() {
        return TapestryIcons.Tapestry_logo_small;
    }

    public static class TapestryFrameworkDetector
    extends FacetBasedFrameworkDetector<TapestryFacet, TapestryFacetConfiguration> {
        public TapestryFrameworkDetector() {
            super("tapestry");
        }

        public FacetType<TapestryFacet, TapestryFacetConfiguration> getFacetType() {
            return TapestryFacetType.getInstance();
        }

        @NotNull
        public FileType getFileType() {
            TmlFileType tmlFileType = TmlFileType.INSTANCE;
            if (tmlFileType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/intellij/facet/TapestryFacetType$TapestryFrameworkDetector", "getFileType"));
            }
            return tmlFileType;
        }

        @NotNull
        public ElementPattern<FileContent> createSuitableFilePattern() {
            FileContentPattern fileContentPattern = FileContentPattern.fileContent();
            if (fileContentPattern == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/intellij/facet/TapestryFacetType$TapestryFrameworkDetector", "createSuitableFilePattern"));
            }
            return fileContentPattern;
        }

        public void setupFacet(@NotNull TapestryFacet facet, ModifiableRootModel model) {
            if (facet == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/intellij/tapestry/intellij/facet/TapestryFacetType$TapestryFrameworkDetector", "setupFacet"));
            }
            TapestryFacetConfiguration configuration = (TapestryFacetConfiguration)facet.getConfiguration();
            HashSet<String> componentDirectories = new HashSet<String>(Arrays.asList(TapestryConstants.ELEMENT_PACKAGES));
            for (VirtualFile file : FileTypeIndex.getFiles((FileType)TmlFileType.INSTANCE, (GlobalSearchScope)GlobalSearchScope.moduleScope((Module)facet.getModule()))) {
                VirtualFile sourceRootForFile;
                VirtualFile parent = file.getParent();
                if (!componentDirectories.contains(parent.getName()) || (sourceRootForFile = ProjectRootManager.getInstance((Project)model.getProject()).getFileIndex().getSourceRootForFile(parent)) == null) continue;
                String relativePath = VfsUtilCore.getRelativePath((VirtualFile)parent.getParent(), (VirtualFile)sourceRootForFile, (char)'.');
                configuration.setApplicationPackage(relativePath);
                break;
            }
            TapestryFrameworkSupportProvider.setupConfiguration(configuration, facet.getModule(), TapestryVersion.TAPESTRY_5_3_6);
        }
    }
}

