/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.intellij.lang.reference;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiAttributeValueReference
implements PsiReference {
    private final XmlAttribute _attribute;
    private final PsiElement _bindElement;

    public PsiAttributeValueReference(XmlAttribute attributeValue, PsiElement bindElement) {
        this._attribute = attributeValue;
        this._bindElement = bindElement;
    }

    public PsiElement getElement() {
        return this._attribute;
    }

    public TextRange getRangeInElement() {
        XmlAttributeValue element = this._attribute.getValueElement();
        if (element == null) {
            return new TextRange(0, 0);
        }
        TextRange valueTextRange = element.getValueTextRange();
        return valueTextRange.shiftRight(-this._attribute.getTextRange().getStartOffset());
    }

    @Nullable
    public PsiElement resolve() {
        return this._bindElement;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this._bindElement.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/intellij/lang/reference/PsiAttributeValueReference", "getCanonicalText"));
        }
        return string;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        throw new UnsupportedOperationException();
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/tapestry/intellij/lang/reference/PsiAttributeValueReference", "bindToElement"));
        }
        throw new UnsupportedOperationException();
    }

    public boolean isReferenceTo(PsiElement element) {
        return this.resolve() == element;
    }

    @NotNull
    public Object[] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/intellij/lang/reference/PsiAttributeValueReference", "getVariants"));
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public boolean isSoft() {
        return false;
    }
}

