/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.highlighter;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.highlighter.JspHighlighterFactory;
import com.intellij.ide.highlighter.XmlLikeFileType;
import com.intellij.lang.Language;
import com.intellij.lang.jsp.JspWithOtherWorldIntegrationService;
import com.intellij.lang.jsp.NewJspLanguage;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileTypes.EditorHighlighterProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeEditorHighlighterProviders;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PlatformIcons;
import com.intellij.xml.util.XmlUtil;
import java.nio.charset.Charset;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewJspFileType
extends XmlLikeFileType {
    public static LanguageFileType INSTANCE = new NewJspFileType();
    @NonNls
    private static final String DEFAULT_EXTENSION = "jsp";

    private NewJspFileType() {
        super((Language)NewJspLanguage.INSTANCE);
        FileTypeEditorHighlighterProviders.INSTANCE.addExplicitExtension((Object)this, (Object)new EditorHighlighterProvider(){

            public EditorHighlighter getEditorHighlighter(@Nullable Project project, @NotNull FileType fileType, @Nullable VirtualFile virtualFile, @NotNull EditorColorsScheme colors) {
                if (fileType == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/ide/highlighter/NewJspFileType$1", "getEditorHighlighter"));
                }
                if (colors == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colors", "com/intellij/ide/highlighter/NewJspFileType$1", "getEditorHighlighter"));
                }
                return JspHighlighterFactory.createJSPHighlighter(colors, project, virtualFile);
            }
        });
    }

    @NotNull
    public String getName() {
        if ("JSP" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/highlighter/NewJspFileType", "getName"));
        }
        return "JSP";
    }

    @NotNull
    public String getDescription() {
        String string = IdeBundle.message((String)"filetype.description.jsp", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/highlighter/NewJspFileType", "getDescription"));
        }
        return string;
    }

    @NotNull
    public String getDefaultExtension() {
        if (DEFAULT_EXTENSION == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/highlighter/NewJspFileType", "getDefaultExtension"));
        }
        return DEFAULT_EXTENSION;
    }

    public Icon getIcon() {
        return PlatformIcons.JSP_ICON;
    }

    public boolean isJVMDebuggingSupported() {
        return true;
    }

    public String getCharset(@NotNull VirtualFile file, @NotNull byte[] content) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/highlighter/NewJspFileType", "getCharset"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ide/highlighter/NewJspFileType", "getCharset"));
        }
        return JspWithOtherWorldIntegrationService.getInstance().detectCharsetAsPerJspSpec(file, content, this.getLanguage());
    }

    public Charset extractCharsetFromFileContent(@Nullable Project project, @Nullable VirtualFile file, @NotNull CharSequence content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ide/highlighter/NewJspFileType", "extractCharsetFromFileContent"));
        }
        String name = XmlUtil.extractXmlEncodingFromProlog((CharSequence)content);
        Charset charset = CharsetToolkit.forName((String)name);
        if (charset != null) {
            return charset;
        }
        return JspWithOtherWorldIntegrationService.getInstance().detectCharsetAsPerJspSpec(project, file, content, this.getLanguage());
    }
}

