/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.stylus.annotator;

import com.intellij.css.util.CssPsiUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.css.CssSimpleSelector;
import com.intellij.psi.css.descriptor.CssContextType;
import com.intellij.psi.css.descriptor.CssPseudoSelectorDescriptor;
import com.intellij.psi.css.descriptor.CssPseudoSelectorDescriptorStub;
import com.intellij.psi.css.impl.util.scheme.CssElementDescriptorProviderImpl;
import com.intellij.psi.css.resolve.CssStyleReferenceStub;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.stylus.StylusLanguage;
import org.jetbrains.plugins.stylus.psi.impl.StylusMixinImpl;

public class StylusElementDescriptorProvider
extends CssElementDescriptorProviderImpl {
    private static final CssPseudoSelectorDescriptor EXTEND_PSEUDO_CLASS_DESCRIPTOR = new CssPseudoSelectorDescriptorStub("extend");

    public boolean isMyContext(@Nullable PsiElement context) {
        return StylusLanguage.INSTANCE.is(CssPsiUtil.getStylesheetLanguage((PsiElement)context));
    }

    @NotNull
    public Collection<? extends CssPseudoSelectorDescriptor> getAllPseudoSelectorDescriptors(@Nullable PsiElement context) {
        HashSet result = ContainerUtil.newHashSet();
        result.add(EXTEND_PSEUDO_CLASS_DESCRIPTOR);
        result.addAll(super.getAllPseudoSelectorDescriptors(context));
        HashSet hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/stylus/annotator/StylusElementDescriptorProvider", "getAllPseudoSelectorDescriptors"));
        }
        return hashSet;
    }

    @NotNull
    public Collection<? extends CssPseudoSelectorDescriptor> findPseudoSelectorDescriptors(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/stylus/annotator/StylusElementDescriptorProvider", "findPseudoSelectorDescriptors"));
        }
        Collection<Object> collection = "extend".equalsIgnoreCase(name) ? Collections.singletonList(EXTEND_PSEUDO_CLASS_DESCRIPTOR) : super.findPseudoSelectorDescriptors(name);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/stylus/annotator/StylusElementDescriptorProvider", "findPseudoSelectorDescriptors"));
        }
        return collection;
    }

    @NotNull
    public PsiElement[] getDeclarationsForSimpleSelector(@NotNull CssSimpleSelector selector) {
        if (selector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selector", "org/jetbrains/plugins/stylus/annotator/StylusElementDescriptorProvider", "getDeclarationsForSimpleSelector"));
        }
        if (PsiElement.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/stylus/annotator/StylusElementDescriptorProvider", "getDeclarationsForSimpleSelector"));
        }
        return PsiElement.EMPTY_ARRAY;
    }

    public boolean providesClassicCss() {
        return false;
    }

    public CssContextType getCssContextType(@Nullable PsiElement context) {
        StylusMixinImpl mixin;
        CssContextType ruleType = super.getCssContextType(context);
        if (ruleType == CssContextType.NONE && (mixin = (StylusMixinImpl)PsiTreeUtil.getParentOfType((PsiElement)context, StylusMixinImpl.class)) != null) {
            return CssContextType.ANY;
        }
        return ruleType;
    }

    @NotNull
    public PsiReference getStyleReference(PsiElement element, int start, int end, boolean caseSensitive) {
        CssStyleReferenceStub cssStyleReferenceStub = new CssStyleReferenceStub(element, TextRange.create((int)start, (int)end));
        if (cssStyleReferenceStub == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/stylus/annotator/StylusElementDescriptorProvider", "getStyleReference"));
        }
        return cssStyleReferenceStub;
    }
}

