/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.stylus.references;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.stylus.psi.impl.StylusMixinImpl;
import org.jetbrains.plugins.stylus.psi.impl.StylusMixinInvocationImpl;
import org.jetbrains.plugins.stylus.psi.stubs.StylusMixinIndex;

public class StylusMixinReference
extends PsiPolyVariantReferenceBase<StylusMixinInvocationImpl> {
    public StylusMixinReference(StylusMixinInvocationImpl psiElement) {
        super((PsiElement)psiElement);
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        String mixinName = ((StylusMixinInvocationImpl)this.myElement).getName();
        if (StringUtil.isEmpty((String)mixinName)) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/stylus/references/StylusMixinReference", "multiResolve"));
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        GlobalSearchScope scope = CssUtil.getCompletionAndResolvingScopeForElement((PsiElement)this.myElement);
        final ArrayList result = ContainerUtil.newArrayList();
        StylusMixinIndex.process(mixinName, ((StylusMixinInvocationImpl)this.myElement).getProject(), scope, (Processor<? super StylusMixinImpl>)new Processor<StylusMixinImpl>(){

            public boolean process(StylusMixinImpl mixin) {
                result.add(new PsiElementResolveResult((PsiElement)mixin, true));
                return true;
            }
        });
        ResolveResult[] resolveResultArray = result.toArray(new ResolveResult[result.size()]);
        if (resolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/stylus/references/StylusMixinReference", "multiResolve"));
        }
        return resolveResultArray;
    }

    @NotNull
    public Object[] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/stylus/references/StylusMixinReference", "getVariants"));
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    protected TextRange calculateDefaultRangeInElement() {
        PsiElement fullNameIdentifier = ((StylusMixinInvocationImpl)this.myElement).getFirstChild();
        return fullNameIdentifier != null && fullNameIdentifier.getText().length() > 0 ? TextRange.from((int)fullNameIdentifier.getStartOffsetInParent(), (int)fullNameIdentifier.getTextLength()) : TextRange.EMPTY_RANGE;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        return ((StylusMixinInvocationImpl)this.myElement).setName(newElementName);
    }
}

