/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.stylus.structureView;

import com.intellij.ide.util.treeView.smartTree.Filter;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.impl.structure.CssStructureViewElement;
import com.intellij.psi.css.impl.structure.CssStructureViewElementsProvider;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.stylus.StylusLanguage;
import org.jetbrains.plugins.stylus.psi.StylusCssBlock;
import org.jetbrains.plugins.stylus.psi.StylusFile;
import org.jetbrains.plugins.stylus.psi.StylusVariableDeclaration;
import org.jetbrains.plugins.stylus.psi.impl.StylusMixinImpl;
import org.jetbrains.plugins.stylus.structureView.StylusVariableStructureViewElement;
import org.jetbrains.plugins.stylus.structureView.StylusVariablesFilter;

public class StylusStructureViewElementsProvider
implements CssStructureViewElementsProvider {
    private static final Filter[] STYLUS_FILTERS = new Filter[]{new StylusVariablesFilter()};
    private static final Class[] STYLUS_SUITABLE_CLASSES = new Class[]{StylusMixinImpl.class, StylusVariableDeclaration.class, StylusCssBlock.class};

    @NotNull
    public Collection<? extends CssStructureViewElement> createStructureViewElements(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/stylus/structureView/StylusStructureViewElementsProvider", "createStructureViewElements"));
        }
        if (element.getLanguage() != StylusLanguage.INSTANCE) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/stylus/structureView/StylusStructureViewElementsProvider", "createStructureViewElements"));
            }
            return list;
        }
        if (element instanceof StylusMixinImpl) {
            ArrayList arrayList = ContainerUtil.newArrayList((Object[])new CssStructureViewElement[]{CssStructureViewElement.create((PsiElement)element)});
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/stylus/structureView/StylusStructureViewElementsProvider", "createStructureViewElements"));
            }
            return arrayList;
        }
        if (element instanceof StylusCssBlock) {
            ArrayList arrayList = ContainerUtil.newArrayList((Object[])new CssStructureViewElement[]{CssStructureViewElement.create((PsiElement)element, null, (String)((StylusCssBlock)element).getName())});
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/stylus/structureView/StylusStructureViewElementsProvider", "createStructureViewElements"));
            }
            return arrayList;
        }
        if (element instanceof StylusVariableDeclaration && !(element.getParent() instanceof StylusMixinImpl)) {
            ArrayList arrayList = ContainerUtil.newArrayList((Object[])new StylusVariableStructureViewElement[]{new StylusVariableStructureViewElement((StylusVariableDeclaration)element)});
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/stylus/structureView/StylusStructureViewElementsProvider", "createStructureViewElements"));
            }
            return arrayList;
        }
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/stylus/structureView/StylusStructureViewElementsProvider", "createStructureViewElements"));
        }
        return list;
    }

    public boolean isMyContext(PsiElement element) {
        return element.getContainingFile() instanceof StylusFile;
    }

    @NotNull
    public Filter[] getFilters() {
        if (STYLUS_FILTERS == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/stylus/structureView/StylusStructureViewElementsProvider", "getFilters"));
        }
        return STYLUS_FILTERS;
    }

    @NotNull
    public Class[] getSuitableClasses() {
        if (STYLUS_SUITABLE_CLASSES == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/stylus/structureView/StylusStructureViewElementsProvider", "getSuitableClasses"));
        }
        return STYLUS_SUITABLE_CLASSES;
    }

    public boolean hasInnerStructure(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/stylus/structureView/StylusStructureViewElementsProvider", "hasInnerStructure"));
        }
        return element instanceof StylusCssBlock;
    }
}

