/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project.data.javaee;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetType;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.javaee.DeploymentDescriptorsConstants;
import com.intellij.javaee.artifact.JavaeeArtifactUtil;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.ui.packaging.ExplodedWarArtifactType;
import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.javaee.web.facet.WebFacetType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.ModuleDataService;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactProperties;
import com.intellij.packaging.artifacts.ArtifactPropertiesProvider;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.artifacts.ModifiableArtifact;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.elements.ArchivePackagingElement;
import com.intellij.packaging.impl.elements.FileCopyPackagingElement;
import com.intellij.packaging.impl.elements.ManifestFileUtil;
import com.intellij.util.Function;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.descriptors.ConfigFileInfoSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.data.War;
import org.jetbrains.plugins.gradle.model.data.WarDirectory;
import org.jetbrains.plugins.gradle.model.data.WebConfigurationModelData;
import org.jetbrains.plugins.gradle.service.project.data.javaee.GradleArtifactProperties;
import org.jetbrains.plugins.gradle.service.project.data.javaee.GradleArtifactPropertiesProvider;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class JavaEEGradleDataServiceHelper {
    private static final Logger LOG = Logger.getInstance(JavaEEGradleDataServiceHelper.class);
    private static final String WEB_INF_DIR_NAME = "WEB-INF";

    public static Collection<Artifact> configureWebModule(@NotNull ModuleData moduleData, @NotNull WebConfigurationModelData data, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (moduleData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleData", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaEEGradleDataServiceHelper", "configureWebModule"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaEEGradleDataServiceHelper", "configureWebModule"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaEEGradleDataServiceHelper", "configureWebModule"));
        }
        String moduleName = moduleData.getInternalName();
        WebFacetType webFacetType = WebFacetType.getInstance();
        if (webFacetType == null) {
            return Collections.emptyList();
        }
        List moduleArtifacts = ContainerUtil.newSmartList();
        Module module = modelsProvider.findIdeModule(moduleName);
        if (module != null) {
            HashSet outputDirs = ContainerUtil.newHashSet();
            ContainerUtil.addIfNotNull((Collection)outputDirs, (Object)moduleData.getCompileOutputPath(ExternalSystemSourceType.RESOURCE));
            String facetNamePrefix = JavaEEGradleDataServiceHelper.getFacetNamePrefix((FacetType)webFacetType);
            ModifiableFacetModel facetModel = modelsProvider.getModifiableFacetModel(module);
            Collection webFacets = facetModel.getFacetsByType(webFacetType.getId());
            for (WebFacet webFacet : webFacets) {
                if (!webFacet.getName().startsWith(facetNamePrefix)) continue;
                facetModel.removeFacet((Facet)webFacet);
            }
            for (War war : data.getWars()) {
                String facetName = JavaEEGradleDataServiceHelper.adjustName(facetNamePrefix, war.getName());
                WebFacet webFacet = JavaEEGradleDataServiceHelper.createOrReplaceWebFacet(facetModel, module, facetName, webFacetType, war);
                String artifactName = JavaEEGradleDataServiceHelper.resolveArtifactName(moduleData, war);
                Artifact archiveArtifact = JavaEEGradleDataServiceHelper.createOrUpdateWebArtifact(modelsProvider, module, artifactName, webFacetType, webFacet, war, webFacetType.getArchiveArtifactType(), outputDirs);
                moduleArtifacts.add(archiveArtifact);
                Artifact explodedArtifact = JavaEEGradleDataServiceHelper.createOrUpdateWebArtifact(modelsProvider, module, artifactName + " (exploded)", webFacetType, webFacet, war, webFacetType.getExplodedArtifactType(), outputDirs);
                moduleArtifacts.add(explodedArtifact);
            }
        }
        return moduleArtifacts;
    }

    public static String getFacetNamePrefix(@NotNull FacetType facetType) {
        if (facetType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facetType", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaEEGradleDataServiceHelper", "getFacetNamePrefix"));
        }
        return facetType.getPresentableName() + ' ' + GradleConstants.SYSTEM_ID.getReadableName();
    }

    public static String resolveArtifactName(@NotNull ModuleData moduleData, @NotNull War war) {
        if (moduleData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleData", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaEEGradleDataServiceHelper", "resolveArtifactName"));
        }
        if (war == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "war", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaEEGradleDataServiceHelper", "resolveArtifactName"));
        }
        String artifactNamePrefix = GradleConstants.SYSTEM_ID.getReadableName() + " : ";
        StringBuilder buf = new StringBuilder(artifactNamePrefix);
        if (!StringUtil.isEmpty((String)moduleData.getGroup())) {
            buf.append(moduleData.getGroup()).append(':');
        }
        buf.append(moduleData.getInternalName());
        String artifactName = JavaEEGradleDataServiceHelper.adjustName(buf.toString(), war.getName());
        return artifactName;
    }

    private static WebFacet createOrReplaceWebFacet(@NotNull ModifiableFacetModel facetModel, @NotNull Module module, @NotNull String facetName, @NotNull WebFacetType webFacetType, @NotNull War war) {
        File webXml;
        if (facetModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facetModel", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaEEGradleDataServiceHelper", "createOrReplaceWebFacet"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaEEGradleDataServiceHelper", "createOrReplaceWebFacet"));
        }
        if (facetName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facetName", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaEEGradleDataServiceHelper", "createOrReplaceWebFacet"));
        }
        if (webFacetType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "webFacetType", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaEEGradleDataServiceHelper", "createOrReplaceWebFacet"));
        }
        if (war == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "war", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaEEGradleDataServiceHelper", "createOrReplaceWebFacet"));
        }
        Collection webFacets = facetModel.getFacetsByType(webFacetType.getId());
        for (WebFacet webFacet : webFacets) {
            if (!facetName.equals(webFacet.getName())) continue;
            facetModel.removeFacet((Facet)webFacet);
            break;
        }
        WebFacet webFacet = webFacetType.createFacet(module, facetName, webFacetType.createDefaultConfiguration(), null);
        facetModel.addFacet((Facet)webFacet);
        JavaEEGradleDataServiceHelper.addWebRoot(webFacet, war.getWebAppDir().getAbsolutePath(), "/");
        HashSet<String> added = new HashSet<String>();
        for (Object webResource : war.getWebResources()) {
            String relativePath;
            String dir;
            WarDirectory warDirectory = webResource.getWarDirectory();
            if (!WarDirectory.WAR_ROOT.equals((Object)warDirectory) && !WarDirectory.WEB_INF.equals((Object)warDirectory) && !warDirectory.isCustomDirectory()) continue;
            if (webResource.getFile().isFile()) {
                dir = FileUtil.toCanonicalPath((String)webResource.getFile().getParent());
                relativePath = JavaEEGradleDataServiceHelper.normalizeRelativePath(warDirectory.getRelativePath(), StringUtil.trimEnd((String)webResource.getWarRelativePath(), (String)webResource.getFile().getName()));
            } else {
                dir = FileUtil.toCanonicalPath((String)webResource.getFile().getPath());
                relativePath = JavaEEGradleDataServiceHelper.normalizeRelativePath(warDirectory.getRelativePath(), webResource.getWarRelativePath());
            }
            if (!added.add(dir) || FileUtil.isAncestor((File)war.getWebAppDir(), (File)new File(dir), (boolean)false)) continue;
            JavaEEGradleDataServiceHelper.addWebRoot(webFacet, dir, relativePath);
        }
        HashSet sourceRoots = ContainerUtil.newHashSet((Object[])ModuleRootManager.getInstance((Module)module).getSourceRootUrls(false));
        for (String sourceRoot : sourceRoots) {
            webFacet.addWebSourceRoot(sourceRoot);
        }
        File file = webXml = war.getWebXml() != null ? war.getWebXml() : new File(war.getWebAppDir(), "WEB-INF/web.xml");
        if (webXml.isFile()) {
            ConfigFileInfoSet descriptors = webFacet.getDescriptorsContainer().getConfiguration();
            descriptors.addConfigFile(DeploymentDescriptorsConstants.WEB_XML_META_DATA, VfsUtilCore.pathToUrl((String)FileUtil.toSystemIndependentName((String)webXml.getPath())));
        }
        return webFacet;
    }

    private static void addWebRoot(@NotNull WebFacet webFacet, @NotNull String dir, @NotNull String relativePath) {
        if (webFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "webFacet", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaEEGradleDataServiceHelper", "addWebRoot"));
        }
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaEEGradleDataServiceHelper", "addWebRoot"));
        }
        if (relativePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePath", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaEEGradleDataServiceHelper", "addWebRoot"));
        }
        VirtualFile webDir = null;
        try {
            webDir = VfsUtil.createDirectoryIfMissing((String)dir);
        }
        catch (IOException e) {
            LOG.warn(String.format("Can't add web root for dir: '%s'", dir), (Throwable)e);
        }
        if (webDir != null && !WebUtil.isInsideWebRoots((VirtualFile)webDir, (List)webFacet.getWebRoots())) {
            webFacet.addWebRoot(webDir, relativePath);
        }
    }

    private static String normalizeRelativePath(String ... paths) {
        String relativePath = StringUtil.trimEnd((String)FileUtil.normalize((String)FileUtil.toSystemIndependentName((String)StringUtil.join((String[])paths, (String)"/"))), (String)"/");
        return relativePath.startsWith("//") ? relativePath.substring(1) : relativePath;
    }

    private static Artifact createOrUpdateWebArtifact(@NotNull IdeModifiableModelsProvider modelsProvider, @NotNull Module module, @NotNull String artifactName, @NotNull WebFacetType webFacetType, @NotNull WebFacet webFacet, @NotNull War war, @NotNull ArtifactType artifactType, @NotNull Set<String> outputDirs) {
        File outputFile;
        CompositePackagingElement rootElement;
        ModifiableArtifact modifiableArtifact;
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaEEGradleDataServiceHelper", "createOrUpdateWebArtifact"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaEEGradleDataServiceHelper", "createOrUpdateWebArtifact"));
        }
        if (artifactName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactName", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaEEGradleDataServiceHelper", "createOrUpdateWebArtifact"));
        }
        if (webFacetType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "webFacetType", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaEEGradleDataServiceHelper", "createOrUpdateWebArtifact"));
        }
        if (webFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "webFacet", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaEEGradleDataServiceHelper", "createOrUpdateWebArtifact"));
        }
        if (war == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "war", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaEEGradleDataServiceHelper", "createOrUpdateWebArtifact"));
        }
        if (artifactType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactType", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaEEGradleDataServiceHelper", "createOrUpdateWebArtifact"));
        }
        if (outputDirs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputDirs", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaEEGradleDataServiceHelper", "createOrUpdateWebArtifact"));
        }
        ModifiableArtifactModel artifactModel = modelsProvider.getModifiableArtifactModel();
        Artifact artifact = artifactModel.findArtifact(artifactName);
        if (artifact == null) {
            modifiableArtifact = artifactModel.addArtifact(artifactName, artifactType);
            rootElement = modifiableArtifact.getRootElement();
        } else {
            modifiableArtifact = artifactModel.getOrCreateModifiableArtifact(artifact);
            rootElement = modifiableArtifact.getRootElement();
            rootElement.removeAllChildren();
        }
        if (rootElement instanceof ArchivePackagingElement) {
            ArchivePackagingElement archivePackagingElement = (ArchivePackagingElement)rootElement;
            archivePackagingElement.rename(war.getName());
        }
        PackagingElementFactory packagingElementFactory = PackagingElementFactory.getInstance();
        rootElement.addOrFindChild(JavaeeArtifactUtil.getInstance().createFacetResourcesElement((JavaeeFacet)webFacet));
        CompositePackagingElement moduleOutputPackagingElement = packagingElementFactory.getOrCreateDirectory(rootElement, webFacetType.getDefaultUriForDirectory());
        moduleOutputPackagingElement.addOrFindChild(packagingElementFactory.createModuleOutput(module));
        for (String outputDir : outputDirs) {
            moduleOutputPackagingElement.addOrFindChild(packagingElementFactory.createDirectoryCopyWithParentDirectories(outputDir, "/"));
        }
        List warClasspath = ContainerUtil.mapNotNull((Collection)war.getClasspath(), (Function)new Function<File, String>(){

            public String fun(File file) {
                return !file.exists() ? null : FileUtil.toSystemIndependentName((String)file.getAbsolutePath());
            }
        });
        ArrayList additionalGradleWarClasspath = ContainerUtil.newArrayList((Iterable)warClasspath);
        JavaEEGradleDataServiceHelper.addModuleDependencies(module, warClasspath, additionalGradleWarClasspath, packagingElementFactory, modelsProvider, webFacetType, modifiableArtifact, ContainerUtil.newHashSet());
        for (String path : additionalGradleWarClasspath) {
            if (!new File(path).isFile()) continue;
            FileCopyPackagingElement element = new FileCopyPackagingElement(path);
            packagingElementFactory.getOrCreateDirectory(rootElement, webFacetType.getDefaultUriForJar()).addOrFindChildren(Collections.singletonList(element));
        }
        String defaultArtifactOutputPath = ArtifactUtil.getDefaultArtifactOutputPath((String)modifiableArtifact.getName(), (Project)module.getProject());
        if (defaultArtifactOutputPath != null && (outputFile = new File(defaultArtifactOutputPath).getParentFile()) != null) {
            String outputPath = outputFile.getName().equals(module.getName()) ? outputFile.getPath() : outputFile.getPath() + '/' + module.getName();
            String explodedOutputPath = outputPath + "/exploded/" + war.getName();
            modifiableArtifact.setOutputPath(FileUtil.toSystemIndependentName((String)PathUtil.getCanonicalPath((String)(artifactType instanceof ExplodedWarArtifactType ? explodedOutputPath : outputPath))));
            JavaEEGradleDataServiceHelper.addManifest(modifiableArtifact, explodedOutputPath, war);
        }
        GradleArtifactProperties gradleArtifactProperties = new GradleArtifactProperties();
        gradleArtifactProperties.setExternalProjectPath(ExternalSystemApiUtil.getExternalRootProjectPath((Module)module));
        modifiableArtifact.setProperties((ArtifactPropertiesProvider)GradleArtifactPropertiesProvider.getInstance(), (ArtifactProperties)gradleArtifactProperties);
        return artifactModel.getOriginalArtifact((Artifact)modifiableArtifact);
    }

    private static void addModuleDependencies(Module module, List<String> warClasspath, List<String> additionalGradleWarClasspath, PackagingElementFactory packagingElementFactory, IdeModifiableModelsProvider modelsProvider, WebFacetType webFacetType, ModifiableArtifact modifiableArtifact, HashSet<Module> processedModules) {
        if (processedModules.contains(module)) {
            return;
        }
        processedModules.add(module);
        for (OrderEntry entry : modelsProvider.getOrderEntries(module)) {
            String moduleArchiveName;
            ExportableOrderEntry exportableOrderEntry;
            if (entry instanceof ExportableOrderEntry && (exportableOrderEntry = (ExportableOrderEntry)entry).getScope() != DependencyScope.COMPILE && exportableOrderEntry.getScope() != DependencyScope.RUNTIME) continue;
            if (entry instanceof LibraryOrderEntry) {
                LibraryOrderEntry libraryOrderEntry = (LibraryOrderEntry)entry;
                boolean onGradleWarClasspathLibrary = false;
                for (VirtualFile virtualFile : libraryOrderEntry.getFiles(OrderRootType.CLASSES)) {
                    String systemIndependentName = FileUtil.toSystemIndependentName((String)virtualFile.getPresentableUrl());
                    onGradleWarClasspathLibrary = onGradleWarClasspathLibrary || warClasspath.contains(systemIndependentName);
                    additionalGradleWarClasspath.remove(systemIndependentName);
                }
                if (!onGradleWarClasspathLibrary || libraryOrderEntry.getLibrary() == null) continue;
                List elements = packagingElementFactory.createLibraryElements(libraryOrderEntry.getLibrary());
                for (PackagingElement element : elements) {
                    String relativePath = element.getFilesKind(modelsProvider.getPackagingElementResolvingContext()).containsJarFiles() ? webFacetType.getDefaultUriForJar() : webFacetType.getDefaultUriForDirectory();
                    packagingElementFactory.getOrCreateDirectory(modifiableArtifact.getRootElement(), relativePath).addOrFindChildren(Collections.singletonList(element));
                }
                continue;
            }
            if (!(entry instanceof ModuleOrderEntry)) continue;
            ModuleOrderEntry moduleOrderEntry = (ModuleOrderEntry)entry;
            Module moduleOrderEntryModule = moduleOrderEntry.getModule();
            HashSet moduleResourceOutputDirs = ContainerUtil.newHashSet();
            if (moduleOrderEntryModule == null) continue;
            ModuleData moduleData = (ModuleData)moduleOrderEntryModule.getUserData(ModuleDataService.MODULE_DATA_KEY);
            if (moduleData != null) {
                moduleArchiveName = JavaEEGradleDataServiceHelper.formatModuleArchiveFileName(moduleData);
                for (File gradleArtifact : moduleData.getArtifacts()) {
                    additionalGradleWarClasspath.remove(FileUtil.toSystemIndependentName((String)gradleArtifact.getAbsolutePath()));
                }
                ContainerUtil.addIfNotNull((Collection)moduleResourceOutputDirs, (Object)moduleData.getCompileOutputPath(ExternalSystemSourceType.RESOURCE));
            } else {
                moduleArchiveName = moduleOrderEntry.getModuleName();
            }
            CompositePackagingElement moduleArchive = packagingElementFactory.createArchive(moduleArchiveName);
            moduleArchive.addOrFindChild(packagingElementFactory.createModuleOutput(moduleOrderEntryModule));
            for (String outputDir : moduleResourceOutputDirs) {
                moduleArchive.addOrFindChild(packagingElementFactory.createDirectoryCopyWithParentDirectories(outputDir, "/"));
            }
            packagingElementFactory.getOrCreateDirectory(modifiableArtifact.getRootElement(), webFacetType.getDefaultUriForJar()).addOrFindChild((PackagingElement)moduleArchive);
            JavaEEGradleDataServiceHelper.addModuleDependencies(moduleOrderEntryModule, warClasspath, additionalGradleWarClasspath, packagingElementFactory, modelsProvider, webFacetType, modifiableArtifact, processedModules);
        }
    }

    @NotNull
    private static String formatModuleArchiveFileName(@NotNull ModuleData moduleData) {
        if (moduleData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleData", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaEEGradleDataServiceHelper", "formatModuleArchiveFileName"));
        }
        StringBuilder buf = new StringBuilder();
        if (!StringUtil.isEmpty((String)moduleData.getGroup())) {
            buf.append(moduleData.getGroup()).append('-');
        }
        buf.append(moduleData.getInternalName());
        if (!StringUtil.isEmpty((String)moduleData.getVersion())) {
            buf.append('-').append(moduleData.getVersion());
        }
        String string = buf.append(".jar").toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaEEGradleDataServiceHelper", "formatModuleArchiveFileName"));
        }
        return string;
    }

    private static void addManifest(@NotNull ModifiableArtifact modifiableArtifact, @NotNull String outputPath, @NotNull War war) {
        if (modifiableArtifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifiableArtifact", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaEEGradleDataServiceHelper", "addManifest"));
        }
        if (outputPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputPath", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaEEGradleDataServiceHelper", "addManifest"));
        }
        if (war == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "war", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaEEGradleDataServiceHelper", "addManifest"));
        }
        if (war.getManifestContent() == null) {
            return;
        }
        try {
            VirtualFile metaInfDirectory = VfsUtil.createDirectoryIfMissing((String)(outputPath + '/' + ManifestFileUtil.MANIFEST_DIR_NAME));
            if (metaInfDirectory == null) {
                LOG.warn(String.format("Unable to create META-INF directory at path: %s", outputPath));
                return;
            }
            VirtualFile manifestVFile = metaInfDirectory.findOrCreateChildData(JavaEEGradleDataServiceHelper.class, ManifestFileUtil.MANIFEST_FILE_NAME);
            VfsUtil.saveText((VirtualFile)manifestVFile, (String)war.getManifestContent());
            PackagingElementFactory.getInstance().addFileCopy(modifiableArtifact.getRootElement(), ManifestFileUtil.MANIFEST_DIR_NAME, manifestVFile.getPath(), ManifestFileUtil.MANIFEST_FILE_NAME);
        }
        catch (IOException e) {
            LOG.warn("Unable to add manifest to the artifact", (Throwable)e);
        }
    }

    private static String adjustName(@NotNull String namePrefix, @Nullable String warName) {
        if (namePrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namePrefix", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaEEGradleDataServiceHelper", "adjustName"));
        }
        return StringUtil.replaceChar((String)(namePrefix + (StringUtil.isEmpty((String)warName) ? "" : " : " + warName)), (char)'/', (char)'_');
    }
}

