/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project.data.javaee;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetType;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.javaee.ui.packaging.WebApplicationArtifactType;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.javaee.web.facet.WebFacetType;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.DisposeAwareProjectChange;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Ref;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactPropertiesProvider;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.elements.FacetBasedPackagingElement;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.data.War;
import org.jetbrains.plugins.gradle.model.data.WebConfigurationModelData;
import org.jetbrains.plugins.gradle.service.project.data.javaee.GradleArtifactProperties;
import org.jetbrains.plugins.gradle.service.project.data.javaee.GradleArtifactPropertiesProvider;
import org.jetbrains.plugins.gradle.service.project.data.javaee.JavaEEGradleDataServiceHelper;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Order(value=1000)
public class WebModuleGradleDataService
extends AbstractProjectDataService<WebConfigurationModelData, Artifact> {
    @NotNull
    public Key<WebConfigurationModelData> getTargetDataKey() {
        Key key = WebConfigurationModelData.KEY;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/data/javaee/WebModuleGradleDataService", "getTargetDataKey"));
        }
        return key;
    }

    public void importData(@NotNull Collection<DataNode<WebConfigurationModelData>> toImport, @Nullable ProjectData projectData, @NotNull Project project, final @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toImport", "org/jetbrains/plugins/gradle/service/project/data/javaee/WebModuleGradleDataService", "importData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/gradle/service/project/data/javaee/WebModuleGradleDataService", "importData"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "org/jetbrains/plugins/gradle/service/project/data/javaee/WebModuleGradleDataService", "importData"));
        }
        for (DataNode<WebConfigurationModelData> node : toImport) {
            Object parentNodeData;
            DataNode parentNode;
            final WebConfigurationModelData webConfigurationModelData = (WebConfigurationModelData)node.getData();
            if (!GradleConstants.SYSTEM_ID.equals((Object)webConfigurationModelData.getOwner()) || (parentNode = node.getParent()) == null || !((parentNodeData = parentNode.getData()) instanceof ModuleData)) continue;
            final ModuleData moduleData = (ModuleData)parentNodeData;
            ExternalSystemApiUtil.executeProjectChangeAction((boolean)true, (DisposeAwareProjectChange)new DisposeAwareProjectChange((ComponentManager)project){

                public void execute() {
                    JavaEEGradleDataServiceHelper.configureWebModule(moduleData, webConfigurationModelData, modelsProvider);
                }
            });
        }
    }

    @NotNull
    public Computable<Collection<Artifact>> computeOrphanData(final @NotNull Collection<DataNode<WebConfigurationModelData>> toImport, final @NotNull ProjectData projectData, final @NotNull Project project, final @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toImport", "org/jetbrains/plugins/gradle/service/project/data/javaee/WebModuleGradleDataService", "computeOrphanData"));
        }
        if (projectData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectData", "org/jetbrains/plugins/gradle/service/project/data/javaee/WebModuleGradleDataService", "computeOrphanData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/gradle/service/project/data/javaee/WebModuleGradleDataService", "computeOrphanData"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "org/jetbrains/plugins/gradle/service/project/data/javaee/WebModuleGradleDataService", "computeOrphanData"));
        }
        Computable<Collection<Artifact>> computable = new Computable<Collection<Artifact>>(){

            public Collection<Artifact> compute() {
                List orphanArtifacts = ContainerUtil.newSmartList();
                AbstractExternalSystemSettings settings = ExternalSystemApiUtil.getSettings((Project)project, (ProjectSystemId)projectData.getOwner());
                List linkedProjectsPaths = ContainerUtil.map((Collection)settings.getLinkedProjectsSettings(), (Function)new Function<ExternalProjectSettings, String>(){

                    public String fun(ExternalProjectSettings settings) {
                        return settings.getExternalProjectPath();
                    }
                });
                List importedArtifacts = WebModuleGradleDataService.resolveArtifactNames(toImport);
                ModifiableArtifactModel artifactModel = modelsProvider.getModifiableArtifactModel();
                for (Artifact artifact : artifactModel.getAllArtifactsIncludingInvalid()) {
                    String externalProjectPath;
                    Object state;
                    if (!(artifact.getArtifactType() instanceof WebApplicationArtifactType) || !artifact.getName().startsWith(GradleConstants.SYSTEM_ID.getReadableName()) || !((state = artifact.getProperties((ArtifactPropertiesProvider)GradleArtifactPropertiesProvider.getInstance()).getState()) instanceof GradleArtifactProperties) || linkedProjectsPaths.contains(externalProjectPath = ((GradleArtifactProperties)((Object)state)).getExternalProjectPath()) && (!projectData.getLinkedExternalProjectPath().equals(externalProjectPath) || importedArtifacts.contains(artifact.getName()))) continue;
                    orphanArtifacts.add(artifact);
                }
                return orphanArtifacts;
            }
        };
        if (computable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/data/javaee/WebModuleGradleDataService", "computeOrphanData"));
        }
        return computable;
    }

    public void removeData(@NotNull Computable<Collection<Artifact>> toRemove, @NotNull Collection<DataNode<WebConfigurationModelData>> toIgnore, final @NotNull ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toRemove == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toRemove", "org/jetbrains/plugins/gradle/service/project/data/javaee/WebModuleGradleDataService", "removeData"));
        }
        if (toIgnore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toIgnore", "org/jetbrains/plugins/gradle/service/project/data/javaee/WebModuleGradleDataService", "removeData"));
        }
        if (projectData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectData", "org/jetbrains/plugins/gradle/service/project/data/javaee/WebModuleGradleDataService", "removeData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/gradle/service/project/data/javaee/WebModuleGradleDataService", "removeData"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "org/jetbrains/plugins/gradle/service/project/data/javaee/WebModuleGradleDataService", "removeData"));
        }
        List<String> ignoredArtifacts = WebModuleGradleDataService.resolveArtifactNames(toIgnore);
        List artifactsToRemove = ContainerUtil.newSmartList();
        artifactsToRemove.addAll((Collection)toRemove.compute());
        ModifiableArtifactModel artifactModel = modelsProvider.getModifiableArtifactModel();
        for (Artifact artifact : artifactsToRemove) {
            artifactModel.removeArtifact(artifact);
        }
        for (Artifact artifact : (List)new GradleWebArtifactsFinder(artifactModel).getValue()) {
            if (!ignoredArtifacts.contains(artifact.getName())) continue;
            artifactModel.removeArtifact(artifact);
        }
        WebFacetType webFacetType = WebFacetType.getInstance();
        if (webFacetType != null) {
            List orphanFacets = ContainerUtil.newSmartList();
            String gradleFacetNamePrefix = JavaEEGradleDataServiceHelper.getFacetNamePrefix((FacetType)webFacetType);
            GradleWebArtifactsFinder gradleWebArtifactsFinder = new GradleWebArtifactsFinder(artifactModel);
            List modules = ContainerUtil.filter((Object[])modelsProvider.getModules(), (Condition)new Condition<Module>(){

                public boolean value(Module module) {
                    return projectData.getLinkedExternalProjectPath().equals(ExternalSystemApiUtil.getExternalRootProjectPath((Module)module));
                }
            });
            PackagingElementResolvingContext context = modelsProvider.getPackagingElementResolvingContext();
            for (Module module : modules) {
                for (WebFacet webFacet : context.getFacetsProvider().getFacetsByType(module, webFacetType.getId())) {
                    if (!webFacet.getName().startsWith(gradleFacetNamePrefix)) continue;
                    boolean used = false;
                    List artifacts = (List)gradleWebArtifactsFinder.getValue();
                    for (Artifact artifact : artifacts) {
                        if (!WebModuleGradleDataService.isUsedIn(webFacet, artifact, context)) continue;
                        used = true;
                        break;
                    }
                    if (used) continue;
                    orphanFacets.add(webFacet);
                }
            }
            for (WebFacet orphanFacet : orphanFacets) {
                if (orphanFacet.isDisposed()) continue;
                Module orphanFacetModule = orphanFacet.getModule();
                ModifiableFacetModel modifiableFacetModel = modelsProvider.getModifiableFacetModel(orphanFacetModule);
                modifiableFacetModel.removeFacet((Facet)orphanFacet);
            }
        }
    }

    private static boolean isUsedIn(final @NotNull WebFacet webFacet, @NotNull Artifact artifact, final @NotNull PackagingElementResolvingContext context) {
        if (webFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "webFacet", "org/jetbrains/plugins/gradle/service/project/data/javaee/WebModuleGradleDataService", "isUsedIn"));
        }
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "org/jetbrains/plugins/gradle/service/project/data/javaee/WebModuleGradleDataService", "isUsedIn"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/gradle/service/project/data/javaee/WebModuleGradleDataService", "isUsedIn"));
        }
        final Ref result = Ref.create((Object)Boolean.FALSE);
        ArtifactUtil.processPackagingElements((Artifact)artifact, null, (Processor)new Processor<PackagingElement<?>>(){

            public boolean process(@NotNull PackagingElement<?> element) {
                Facet facet;
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/gradle/service/project/data/javaee/WebModuleGradleDataService$4", "process"));
                }
                if (element instanceof FacetBasedPackagingElement && webFacet.equals((Object)(facet = ((FacetBasedPackagingElement)element).findFacet(context)))) {
                    result.set((Object)Boolean.TRUE);
                    return false;
                }
                return true;
            }
        }, (PackagingElementResolvingContext)context, (boolean)true);
        return (Boolean)result.get();
    }

    @NotNull
    private static List<String> resolveArtifactNames(@NotNull Collection<DataNode<WebConfigurationModelData>> nodes) {
        if (nodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodes", "org/jetbrains/plugins/gradle/service/project/data/javaee/WebModuleGradleDataService", "resolveArtifactNames"));
        }
        List artifacts = ContainerUtil.newSmartList();
        for (DataNode<WebConfigurationModelData> node : nodes) {
            Object parentNodeData;
            DataNode parentNode;
            WebConfigurationModelData webConfigurationModelData = (WebConfigurationModelData)node.getData();
            if (!GradleConstants.SYSTEM_ID.equals((Object)webConfigurationModelData.getOwner()) || (parentNode = node.getParent()) == null || !((parentNodeData = parentNode.getData()) instanceof ModuleData)) continue;
            ModuleData moduleData = (ModuleData)parentNodeData;
            for (War war : webConfigurationModelData.getWars()) {
                String artifactName = JavaEEGradleDataServiceHelper.resolveArtifactName(moduleData, war);
                artifacts.add(artifactName);
                artifacts.add(artifactName + " (exploded)");
            }
        }
        List list = artifacts;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/data/javaee/WebModuleGradleDataService", "resolveArtifactNames"));
        }
        return list;
    }

    private static boolean isGradleWebArtifact(@NotNull Artifact artifactToCheck) {
        if (artifactToCheck == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactToCheck", "org/jetbrains/plugins/gradle/service/project/data/javaee/WebModuleGradleDataService", "isGradleWebArtifact"));
        }
        return artifactToCheck.getArtifactType() instanceof WebApplicationArtifactType && artifactToCheck.getName().startsWith(GradleConstants.SYSTEM_ID.getReadableName());
    }

    private static class GradleWebArtifactsFinder
    extends NotNullLazyValue<List<? extends Artifact>> {
        private final ModifiableArtifactModel myArtifactModel;

        public GradleWebArtifactsFinder(ModifiableArtifactModel artifactModel) {
            this.myArtifactModel = artifactModel;
        }

        @NotNull
        protected List<? extends Artifact> compute() {
            List result = ContainerUtil.newSmartList();
            for (Artifact artifact : this.myArtifactModel.getAllArtifactsIncludingInvalid()) {
                if (!WebModuleGradleDataService.isGradleWebArtifact(artifact)) continue;
                result.add(artifact);
            }
            List list = result;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/data/javaee/WebModuleGradleDataService$GradleWebArtifactsFinder", "compute"));
            }
            return list;
        }
    }
}

