/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.ide.presentation.VirtualFilePresentation;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.util.ConstantFunction;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.PlatformIcons;
import com.intellij.ws.rest.JaxRsLineMarkerProvider;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;

public class JaxRsLineMarkerInfo
extends LineMarkerInfo<PsiIdentifier> {
    public static final Function<PsiIdentifier, String> TOOLTIP = new ConstantFunction((Object)"Go to template");

    public JaxRsLineMarkerInfo(PsiIdentifier element, VirtualFile file) {
        super((PsiElement)element, element.getTextRange(), PlatformIcons.JSP_ICON, 4, TOOLTIP, (GutterIconNavigationHandler)new JaxRsTemplateNavHandler(element.getProject(), file), GutterIconRenderer.Alignment.LEFT);
    }

    static class JaxRsTemplateNavHandler
    implements GutterIconNavigationHandler<PsiIdentifier> {
        private final Project project;
        private final VirtualFile file;

        JaxRsTemplateNavHandler(Project project, VirtualFile file) {
            this.project = project;
            this.file = file;
        }

        public void navigate(MouseEvent e, PsiIdentifier elt) {
            final ArrayList<VirtualFile> files = new ArrayList<VirtualFile>();
            for (VirtualFile f : this.file.getChildren()) {
                if (!JaxRsLineMarkerProvider.isAllowedExt(f)) continue;
                files.add(f);
            }
            if (files.size() > 1) {
                final JBList list = new JBList(files);
                list.installCellRenderer((NotNullFunction)new NotNullFunction<VirtualFile, JComponent>(){

                    @NotNull
                    public JComponent fun(VirtualFile o) {
                        JLabel jLabel = new JLabel(o.getName(), VirtualFilePresentation.getIcon((VirtualFile)o), 2);
                        if (jLabel == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/rest/JaxRsLineMarkerInfo$JaxRsTemplateNavHandler$1", "fun"));
                        }
                        return jLabel;
                    }
                });
                JBPopupFactory.getInstance().createListPopupBuilder((JList)list).setTitle("Choose template").setItemChoosenCallback(new Runnable(){

                    @Override
                    public void run() {
                        int selectedIndex = list.getSelectedIndex();
                        if (selectedIndex == -1) {
                            return;
                        }
                        FileEditorManager.getInstance((Project)JaxRsTemplateNavHandler.this.project).openFile((VirtualFile)files.get(selectedIndex), true);
                    }
                }).setAutoselectOnMouseMove(true).createPopup().show(new RelativePoint(e));
            } else if (files.size() == 1) {
                FileEditorManager.getInstance((Project)this.project).openFile((VirtualFile)files.get(0), true);
            }
        }
    }
}

