/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@State(name="RSProjectComponent", storages={@Storage(file="$PROJECT_FILE$")})
public class RSProjectComponent
implements PersistentStateComponent<Settings> {
    private final Settings mySettings = new Settings();

    public static RSProjectComponent getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ws/rest/RSProjectComponent", "getInstance"));
        }
        return (RSProjectComponent)ServiceManager.getService((Project)project, RSProjectComponent.class);
    }

    public Settings getState() {
        return this.mySettings;
    }

    public void loadState(Settings state) {
        this.mySettings.myLastRestClientHost = state.myLastRestClientHost;
        this.mySettings.myShowAllResources = state.myShowAllResources;
        this.mySettings.myShowResourcesView = state.myShowResourcesView;
    }

    public static class Settings {
        @NonNls
        public String myLastRestClientHost = "http://localhost:9998";
        public boolean myShowResourcesView = true;
        public boolean myShowAllResources = false;
        public boolean myShowGetResources = true;
        public boolean myShowPostResources = true;
        public boolean myShowDeleteResources = true;
        public boolean myShowPutResources = true;

        public String getLastRestClientHost() {
            return this.myLastRestClientHost;
        }

        public boolean isShowResourcesView() {
            return this.myShowResourcesView;
        }

        public boolean isShowAllResources() {
            return this.myShowAllResources;
        }

        public boolean isShowGetResources() {
            return this.myShowGetResources;
        }

        public boolean isShowPostResources() {
            return this.myShowPostResources;
        }

        public boolean isShowDeleteResources() {
            return this.myShowDeleteResources;
        }

        public boolean isShowPutResources() {
            return this.myShowPutResources;
        }
    }
}

