/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiExpressionPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.impl.JavaConstantExpressionEvaluator;
import com.intellij.util.ProcessingContext;
import com.intellij.ws.rest.utils.RSUtils;
import org.jetbrains.annotations.NotNull;

public class RestMimeCompletion
extends CompletionContributor {
    private static final PsiJavaElementPattern.Capture<PsiLiteralExpression> MIME_ANNO_VALUE = (PsiJavaElementPattern.Capture)PsiJavaPatterns.literalExpression().insideAnnotationParam((ElementPattern)PsiJavaPatterns.string().oneOf(new String[]{"javax.ws.rs.ProduceMime", "javax.ws.rs.Produces", "javax.ws.rs.ConsumeMime", "javax.ws.rs.Consumes"}), "value");
    private static final PsiExpressionPattern.Capture<PsiExpression> INSIDE_ANNOTATION = (PsiExpressionPattern.Capture)PsiJavaPatterns.psiExpression().insideAnnotationParam((ElementPattern)PsiJavaPatterns.string().oneOf(new String[]{"javax.ws.rs.ProduceMime", "javax.ws.rs.Produces", "javax.ws.rs.ConsumeMime", "javax.ws.rs.Consumes"}), "value");

    public RestMimeCompletion() {
        this.extend(CompletionType.BASIC, (ElementPattern)PsiJavaPatterns.psiElement().withParent(MIME_ANNO_VALUE), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/ws/rest/completion/RestMimeCompletion$1", "addCompletions"));
                }
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/ws/rest/completion/RestMimeCompletion$1", "addCompletions"));
                }
                PsiLiteralExpression literal = (PsiLiteralExpression)parameters.getPosition().getContext();
                Object obj = JavaConstantExpressionEvaluator.computeConstantExpression((PsiExpression)literal, (boolean)false);
                if (!(obj instanceof String)) {
                    return;
                }
                String value = obj.toString();
                Project project = parameters.getPosition().getProject();
                String[] mimes = RSUtils.getAllMimes(project, RSUtils.PREDEFINED_MIME_TYPES);
                boolean secondPartOnly = value.contains("/");
                String prefix = secondPartOnly ? value.substring(0, value.indexOf(47)) : value;
                for (String mime : mimes) {
                    if (mime.equals(result.getPrefixMatcher().getPrefix())) continue;
                    if (secondPartOnly) {
                        if (!mime.contains("/") || !mime.startsWith(prefix)) continue;
                        mime = mime.substring(mime.indexOf(47) + 1);
                        result.addElement((LookupElement)LookupElementBuilder.create((String)mime));
                        continue;
                    }
                    result.addElement((LookupElement)LookupElementBuilder.create((String)mime));
                }
                if (mimes.length != 0) {
                    result.stopHere();
                }
            }
        });
        this.extend(CompletionType.BASIC, (ElementPattern)PsiJavaPatterns.psiElement().withParent(INSIDE_ANNOTATION), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
                String[] mimes;
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/ws/rest/completion/RestMimeCompletion$2", "addCompletions"));
                }
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/ws/rest/completion/RestMimeCompletion$2", "addCompletions"));
                }
                for (String mime : mimes = RSUtils.getAllMimes(parameters.getPosition().getProject(), RSUtils.PREDEFINED_MIME_TYPES)) {
                    result.addElement((LookupElement)LookupElementBuilder.create((String)("\"" + mime + "\"")).withPresentableText(mime));
                }
                if (mimes.length != 0) {
                    result.stopHere();
                }
            }
        });
    }
}

