/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.ws.inspections.fixes.RemoveElementFix;
import com.intellij.ws.rest.RSBundle;
import com.intellij.ws.rest.inspections.BaseRestInspection;
import com.intellij.ws.rest.utils.RSUtils;
import org.jetbrains.annotations.NotNull;

public class MultipleMethodDesignatorsInspection
extends BaseRestInspection {
    protected void checkMember(ProblemsHolder problemsHolder, PsiMember psiMember) {
        PsiMethod method;
        PsiAnnotation[] annotations;
        if (psiMember instanceof PsiMethod && (annotations = RSUtils.getHttpAnnotations(method = (PsiMethod)psiMember)).length > 1) {
            for (int i = 1; i < annotations.length; ++i) {
                PsiAnnotation anno = annotations[i];
                problemsHolder.registerProblem((PsiElement)anno, this.getDisplayName(), ProblemHighlightType.ERROR, new LocalQuickFix[]{new RemoveElementFix((PsiElement)anno, RSBundle.message("remove.annotation", new Object[0]))});
            }
        }
    }

    protected void doCheckClass(PsiClass c, ProblemsHolder problemsHolder) {
    }

    @NotNull
    public String getDisplayName() {
        String string = RSBundle.message("webservices.inspections.rest.multiple.method.designators.inspection", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/rest/inspections/MultipleMethodDesignatorsInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/rest/inspections/MultipleMethodDesignatorsInspection", "getShortName"));
        }
        return string;
    }
}

