/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.ws.inspections.fixes.RemoveElementFix;
import com.intellij.ws.rest.RSBundle;
import com.intellij.ws.rest.inspections.BaseRestInspection;
import com.intellij.ws.rest.utils.RSUtils;
import org.jetbrains.annotations.NotNull;

public class UnreachableResourceMethodInspection
extends BaseRestInspection {
    protected void checkMember(ProblemsHolder problemsHolder, PsiMember psiMember) {
        if (!(psiMember instanceof PsiMethod)) {
            return;
        }
        PsiMethod method = (PsiMethod)psiMember;
        PsiClass c = method.getContainingClass();
        if (c == null) {
            return;
        }
        if (!RSUtils.isResourceMethod(method) || RSUtils.isResourceClass(c) || !RSUtils.isNonAbstractAndPublicClass(c) || RSUtils.findInheritorClassAnnotatedAs("javax.ws.rs.Path", c) != null) {
            return;
        }
        UnreachableResourceMethodInspection.checkAnnotationPresence("javax.ws.rs.Path", "Path", method, problemsHolder);
        UnreachableResourceMethodInspection.checkAnnotationPresence("javax.ws.rs.GET", "GET", method, problemsHolder);
        UnreachableResourceMethodInspection.checkAnnotationPresence("javax.ws.rs.POST", "POST", method, problemsHolder);
        UnreachableResourceMethodInspection.checkAnnotationPresence("javax.ws.rs.PUT", "PUT", method, problemsHolder);
        UnreachableResourceMethodInspection.checkAnnotationPresence("javax.ws.rs.DELETE", "DELETE", method, problemsHolder);
        UnreachableResourceMethodInspection.checkAnnotationPresence("javax.ws.rs.HEAD", "HEAD", method, problemsHolder);
    }

    protected void doCheckClass(PsiClass c, ProblemsHolder problemsHolder) {
    }

    private static void checkAnnotationPresence(@NotNull String annotationFQN, @NotNull String annotationShortName, @NotNull PsiMethod method, ProblemsHolder problemsHolder) {
        if (annotationFQN == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationFQN", "com/intellij/ws/rest/inspections/UnreachableResourceMethodInspection", "checkAnnotationPresence"));
        }
        if (annotationShortName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationShortName", "com/intellij/ws/rest/inspections/UnreachableResourceMethodInspection", "checkAnnotationPresence"));
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/ws/rest/inspections/UnreachableResourceMethodInspection", "checkAnnotationPresence"));
        }
        PsiAnnotation annotation = RSUtils.findAnnotation(annotationFQN, (PsiModifierListOwner)method);
        if (annotation != null) {
            String shortName = "@" + annotationShortName;
            problemsHolder.registerProblem((PsiElement)annotation, RSBundle.message("webservices.inspections.rest.resource.method.inspection.problem", shortName), ProblemHighlightType.ERROR, new LocalQuickFix[]{new RemoveElementFix((PsiElement)annotation, RSBundle.message("webservices.inspections.remove.annotation.fix.name", shortName))});
        }
    }

    @NotNull
    public String getDisplayName() {
        String string = RSBundle.message("webservices.inspections.rest.resource.method.inspection.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/rest/inspections/UnreachableResourceMethodInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        String string = RSBundle.message("webservices.inspections.rest.resource.method.inspection.short.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/rest/inspections/UnreachableResourceMethodInspection", "getShortName"));
        }
        return string;
    }
}

