/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest.model.jam;

import com.intellij.jam.JamElement;
import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamClassMeta;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMember;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedElementsSearch;
import com.intellij.ws.rest.model.jam.RSHttpMethod;
import com.intellij.ws.rest.model.jam.RSJamPsiClassPath;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class RSJamModel {
    @NotNull
    private final Project myProject;

    public static RSJamModel getModel(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ws/rest/model/jam/RSJamModel", "getModel"));
        }
        return (RSJamModel)ServiceManager.getService((Project)project, RSJamModel.class);
    }

    public RSJamModel(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ws/rest/model/jam/RSJamModel", "<init>"));
        }
        this.myProject = project;
    }

    public List<RSJamPsiClassPath> getPsiClassPaths(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ws/rest/model/jam/RSJamModel", "getPsiClassPaths"));
        }
        return this.getPsiClassPaths(this.getProjectScope(project, true));
    }

    public List<RSJamPsiClassPath> getPsiClassPaths(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/ws/rest/model/jam/RSJamModel", "getPsiClassPaths"));
        }
        return this.getPsiClassPaths(this.getModuleScope(module, true));
    }

    public List<RSJamPsiClassPath> getPsiClassPaths(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/ws/rest/model/jam/RSJamModel", "getPsiClassPaths"));
        }
        return this.getJamClassElements(RSJamPsiClassPath.META, "javax.ws.rs.Path", scope);
    }

    public boolean hasPathAnnotatedElements(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/ws/rest/model/jam/RSJamModel", "hasPathAnnotatedElements"));
        }
        PsiClass aClass = JavaPsiFacade.getInstance((Project)this.myProject).findClass("javax.ws.rs.Path", GlobalSearchScope.allScope((Project)this.myProject));
        if (aClass != null) {
            return AnnotatedElementsSearch.searchElements((PsiClass)aClass, (SearchScope)this.getModuleScope(module, true), (Class[])new Class[]{PsiMember.class}).findFirst() != null;
        }
        return false;
    }

    public List<RSHttpMethod> getHttpMethods(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/ws/rest/model/jam/RSJamModel", "getHttpMethods"));
        }
        JamService service = JamService.getJamService((Project)this.myProject);
        return service.getAnnotatedMembersList(psiClass, RSHttpMethod.RS_HTTP_METHOD_JAM_KEY, true, true, true, true);
    }

    public <T extends JamElement> List<T> getJamClassElements(JamClassMeta<T> clazz, String anno, @NotNull GlobalSearchScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/ws/rest/model/jam/RSJamModel", "getJamClassElements"));
        }
        JamService service = JamService.getJamService((Project)this.myProject);
        return service.getJamClassElements(clazz, anno, scope);
    }

    public GlobalSearchScope getModuleScope(@NotNull Module module, boolean showFromLibraries) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/ws/rest/model/jam/RSJamModel", "getModuleScope"));
        }
        return showFromLibraries ? GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module) : GlobalSearchScope.moduleWithDependenciesScope((Module)module);
    }

    public GlobalSearchScope getProjectScope(@NotNull Project project, boolean showFromLibraries) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ws/rest/model/jam/RSJamModel", "getProjectScope"));
        }
        return showFromLibraries ? GlobalSearchScope.allScope((Project)project) : GlobalSearchScope.projectScope((Project)project);
    }
}

