/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest.references;

import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiReference;
import com.intellij.util.ProcessingContext;
import com.intellij.ws.references.WSReferenceProvider;
import com.intellij.ws.rest.references.MimeReference;
import org.jetbrains.annotations.NotNull;

public class MimeReferenceProvider
extends WSReferenceProvider {
    private static final PsiJavaElementPattern.Capture<PsiElement> PATTERN = (PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().insideAnnotationParam((ElementPattern)StandardPatterns.string().oneOf(new String[]{"javax.ws.rs.Produces", "javax.ws.rs.Consumes"}));

    public ElementPattern<? extends PsiElement> getPattern() {
        return PATTERN;
    }

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        PsiReference[] psiReferenceArray;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ws/rest/references/MimeReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/ws/rest/references/MimeReferenceProvider", "getReferencesByElement"));
        }
        if (element instanceof PsiLiteralExpression) {
            PsiReference[] psiReferenceArray2 = new PsiReference[1];
            psiReferenceArray = psiReferenceArray2;
            psiReferenceArray2[0] = new MimeReference((PsiLiteralExpression)element);
        } else {
            psiReferenceArray = PsiReference.EMPTY_ARRAY;
        }
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/rest/references/MimeReferenceProvider", "getReferencesByElement"));
        }
        return psiReferenceArray;
    }
}

