/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest.references;

import com.intellij.javaee.model.annotations.AnnotationModelUtil;
import com.intellij.javaee.util.UriTemplateParser;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.ws.references.WSReference;
import com.intellij.ws.rest.RSBundle;
import com.intellij.ws.rest.references.PathParamPsiElement;
import com.intellij.ws.rest.references.RestPathReference;
import com.intellij.ws.rest.utils.RSUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PathParamReference
extends WSReference<PsiLiteralExpression> {
    private PsiLiteralExpression myParam;
    private final String myStringValue;
    private final Pattern GOOD_PATH_NAME = Pattern.compile("[a-zA-Z0-9_-]*");

    public PathParamReference(PsiLiteralExpression pathParamLiteral) {
        super((PsiElement)pathParamLiteral, true);
        this.myParam = pathParamLiteral;
        Object value = this.myParam.getValue();
        this.myStringValue = value instanceof String ? (String)value : null;
    }

    public PsiElement resolve() {
        if (this.myStringValue == null) {
            return null;
        }
        PsiLiteralExpression member = this.myParam;
        while ((member = PsiTreeUtil.getParentOfType((PsiElement)member, PsiMember.class)) != null) {
            PsiElement element;
            PsiAnnotationMemberValue attributeValue;
            PsiMember psiMember = (PsiMember)member;
            PsiAnnotation annotation = RSUtils.findAnnotation("javax.ws.rs.Path", (PsiModifierListOwner)psiMember);
            if (annotation == null || (attributeValue = annotation.findAttributeValue("value")) == null || !((element = attributeValue.getOriginalElement()) instanceof PsiLiteralExpression)) continue;
            for (PsiReference reference : element.getReferences()) {
                RestPathReference pathReference;
                if (!(reference instanceof RestPathReference) || !this.myStringValue.equals((pathReference = (RestPathReference)reference).getName())) continue;
                return pathReference.resolve();
            }
        }
        return null;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        if (this.GOOD_PATH_NAME.matcher(newElementName).matches()) {
            PsiExpression newLiteral = JavaPsiFacade.getElementFactory((Project)((PsiLiteralExpression)this.getElement()).getProject()).createExpressionFromText("\"" + newElementName + "\"", this.myParam.getContext());
            this.myParam = (PsiLiteralExpression)this.myParam.replace((PsiElement)newLiteral);
        }
        return this.myParam;
    }

    @NotNull
    public String getValue() {
        String string = this.myStringValue == null ? "" : this.myStringValue;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/rest/references/PathParamReference", "getValue"));
        }
        return string;
    }

    public boolean isReferenceTo(PsiElement element) {
        return element instanceof PathParamPsiElement && this.getValue().equals(((PathParamPsiElement)element).getName()) && this.getValue().length() > 0 && PathParamReference.findParent(this.myStringValue, element) == PathParamReference.findParent(this.myStringValue, (PsiElement)this.myParam);
    }

    @Nullable
    private static PsiElement findParent(String param, PsiElement member) {
        while ((member = PsiTreeUtil.getParentOfType((PsiElement)member, PsiMember.class)) != null) {
            PsiAnnotation path;
            PsiMember psiMember = (PsiMember)member;
            PsiModifierList modifierList = psiMember.getModifierList();
            if (modifierList == null || (path = modifierList.findAnnotation("javax.ws.rs.Path")) == null || !PathParamReference.findNames(path).contains(param)) continue;
            return psiMember;
        }
        return null;
    }

    @NotNull
    public Object[] getVariants() {
        PsiElement element = PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), PsiMethod.class);
        if (element == null) {
            element = PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), PsiClass.class);
        }
        Object[] objectArray = element == null ? ArrayUtil.EMPTY_OBJECT_ARRAY : PathParamReference.findPathAnnotationValue(element).toArray();
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/rest/references/PathParamReference", "getVariants"));
        }
        return objectArray;
    }

    static List<String> findPathAnnotationValue(PsiElement el) {
        ArrayList<String> variants = new ArrayList<String>();
        PsiAnnotation annotation = null;
        while (el != null) {
            PsiModifierList modifierList;
            if (el instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)el;
                annotation = method.getModifierList().findAnnotation("javax.ws.rs.Path");
            }
            if (el instanceof PsiClass && (modifierList = ((PsiClass)el).getModifierList()) != null) {
                annotation = modifierList.findAnnotation("javax.ws.rs.Path");
            }
            if (annotation != null) {
                variants.addAll(PathParamReference.findNames(annotation));
                annotation = null;
            }
            if (!((el = el.getParent()) instanceof PsiFile)) continue;
            break;
        }
        return variants;
    }

    static List<String> findNames(PsiAnnotation annotation) {
        ArrayList<String> variants = new ArrayList<String>();
        if (annotation != null) {
            String path = (String)AnnotationModelUtil.getStringValue((PsiAnnotation)annotation, (String)"value", null).getValue();
            try {
                variants.addAll(new UriTemplateParser(path).getNames());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return variants;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String string = RSBundle.message("cannot.resolve.param", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/rest/references/PathParamReference", "getUnresolvedMessagePattern"));
        }
        return string;
    }
}

