/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest.utils;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.javaee.model.annotations.AnnotationGenericValue;
import com.intellij.javaee.model.annotations.AnnotationModelUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.java.stubs.index.JavaAnnotationIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Query;
import com.intellij.util.containers.ArrayListSet;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.ws.rest.constants.RSAnnotations;
import com.intellij.ws.rest.model.jam.RSHttpMethod;
import com.intellij.ws.rest.model.jam.RSJamPsiClassPath;
import com.intellij.ws.rest.model.jam.RSJamPsiMethodPath;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RSUtils {
    @NonNls
    public static final String[] PREDEFINED_MIME_TYPES = new String[]{"*/*", "text/plain", "text/html", "application/xml", "application/json", "application/atom+xml"};
    @NonNls
    public static final String VALUE = "value";

    private RSUtils() {
    }

    public static boolean isAnnotatedAs(@NotNull String fqn, @NotNull PsiElement c) {
        if (fqn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqn", "com/intellij/ws/rest/utils/RSUtils", "isAnnotatedAs"));
        }
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/ws/rest/utils/RSUtils", "isAnnotatedAs"));
        }
        PsiModifierList modifiers = null;
        if (c instanceof PsiModifierListOwner) {
            modifiers = ((PsiModifierListOwner)c).getModifierList();
        }
        return modifiers != null && modifiers.findAnnotation(fqn) != null;
    }

    public static PsiAnnotation[] getHttpAnnotations(PsiMethod method) {
        ArrayList<PsiAnnotation> annotations = new ArrayList<PsiAnnotation>();
        PsiModifierList modifierList = method.getModifierList();
        if (modifierList == null) {
            return PsiAnnotation.EMPTY_ARRAY;
        }
        for (PsiAnnotation annotation : modifierList.getAnnotations()) {
            String fqn = annotation.getQualifiedName();
            if (fqn == null || !RSAnnotations.HTTP_ANNOTATIONS.contains(fqn)) continue;
            annotations.add(annotation);
        }
        return annotations.toArray(new PsiAnnotation[annotations.size()]);
    }

    @NotNull
    public static String getResourcePath(@NotNull RSHttpMethod httpMethod) {
        RSJamPsiMethodPath methodPathResource;
        RSJamPsiClassPath psiClassPath;
        if (httpMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "httpMethod", "com/intellij/ws/rest/utils/RSUtils", "getResourcePath"));
        }
        StringBuilder buffer = new StringBuilder();
        PsiMethod psiMethod = httpMethod.getPsiElement();
        JamService service = JamService.getJamService((Project)psiMethod.getProject());
        PsiClass containingClass = psiMethod.getContainingClass();
        if (containingClass != null && (psiClassPath = (RSJamPsiClassPath)service.getJamElement((PsiElement)containingClass, new JamMemberMeta[]{RSJamPsiClassPath.META})) != null) {
            buffer.append(psiClassPath.getResourceValue());
        }
        if ((methodPathResource = (RSJamPsiMethodPath)service.getJamElement((PsiElement)psiMethod, new JamMemberMeta[]{RSJamPsiMethodPath.META})) != null) {
            buffer.append(methodPathResource.getResourceValue());
        }
        String string = buffer.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/rest/utils/RSUtils", "getResourcePath"));
        }
        return string;
    }

    public static boolean isResourceClass(PsiClass resource) {
        while (resource != null) {
            if (RSUtils.isAnnotatedAs("javax.ws.rs.Path", (PsiElement)resource)) {
                return true;
            }
            resource = resource.getSuperClass();
        }
        return false;
    }

    @Nullable
    public static PsiAnnotation findAnnotation(@NotNull String fqn, @NotNull PsiModifierListOwner owner) {
        PsiAnnotation[] annos;
        if (fqn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqn", "com/intellij/ws/rest/utils/RSUtils", "findAnnotation"));
        }
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/ws/rest/utils/RSUtils", "findAnnotation"));
        }
        PsiModifierList modifiers = owner.getModifierList();
        if (modifiers == null || modifiers.getAnnotations().length == 0) {
            return null;
        }
        for (PsiAnnotation anno : annos = modifiers.getAnnotations()) {
            if (!fqn.equals(anno.getQualifiedName())) continue;
            return anno;
        }
        return null;
    }

    @Nullable
    public static PsiClass getParent(@NotNull PsiAnnotation anno) {
        if (anno == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anno", "com/intellij/ws/rest/utils/RSUtils", "getParent"));
        }
        for (PsiElement el = anno.getParent(); el != null; el = el.getParent()) {
            if (!(el instanceof PsiClass)) continue;
            return (PsiClass)el;
        }
        return null;
    }

    public static boolean isNonAbstractAndPublicClass(PsiClass c) {
        PsiModifierList modifiers = c == null ? null : c.getModifierList();
        return modifiers != null && !c.isAnnotationType() && !c.isEnum() && !c.isInterface() && !modifiers.hasExplicitModifier("abstract") && modifiers.hasExplicitModifier("public");
    }

    @Nullable
    public static String getAnnotationValue(@NotNull PsiAnnotation anno) {
        if (anno == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anno", "com/intellij/ws/rest/utils/RSUtils", "getAnnotationValue"));
        }
        return (String)AnnotationModelUtil.getStringValue((PsiAnnotation)anno, (String)VALUE, null).getValue();
    }

    public static String[] getAllMimes(Project project) {
        Collection annos = JavaAnnotationIndex.getInstance().get("ProduceMime", project, GlobalSearchScope.projectScope((Project)project));
        annos.addAll(JavaAnnotationIndex.getInstance().get("ConsumeMime", project, GlobalSearchScope.projectScope((Project)project)));
        annos.addAll(JavaAnnotationIndex.getInstance().get("Produces", project, GlobalSearchScope.projectScope((Project)project)));
        annos.addAll(JavaAnnotationIndex.getInstance().get("Consumes", project, GlobalSearchScope.projectScope((Project)project)));
        ArrayListSet types = new ArrayListSet();
        for (PsiAnnotation produce : annos) {
            List values = AnnotationModelUtil.getStringArrayValue((PsiAnnotation)produce, (String)VALUE);
            for (AnnotationGenericValue value : values) {
                types.add(value.getValue());
            }
        }
        return ArrayUtil.toStringArray((Collection)types);
    }

    public static String[] getAllMimes(Project project, @NotNull String[] mergeWith) {
        if (mergeWith == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergeWith", "com/intellij/ws/rest/utils/RSUtils", "getAllMimes"));
        }
        return RSUtils.merge(mergeWith, RSUtils.getAllMimes(project), String.class);
    }

    public static boolean isResourceMethod(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/ws/rest/utils/RSUtils", "isResourceMethod"));
        }
        return RSUtils.isAnnotatedAs("javax.ws.rs.GET", (PsiElement)method) || RSUtils.isAnnotatedAs("javax.ws.rs.POST", (PsiElement)method) || RSUtils.isAnnotatedAs("javax.ws.rs.PUT", (PsiElement)method) || RSUtils.isAnnotatedAs("javax.ws.rs.DELETE", (PsiElement)method) || RSUtils.isAnnotatedAs("javax.ws.rs.HEAD", (PsiElement)method);
    }

    @NonNls
    @NotNull
    public static String getShortName(@NonNls @NotNull String fqn) {
        if (fqn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqn", "com/intellij/ws/rest/utils/RSUtils", "getShortName"));
        }
        String string = fqn.contains(".") ? fqn.substring(fqn.lastIndexOf(".") + 1) : fqn;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/rest/utils/RSUtils", "getShortName"));
        }
        return string;
    }

    @Nullable
    public static PsiClass findInheritorClassAnnotatedAs(@NotNull @NonNls String fqn, @NotNull PsiClass c) {
        if (fqn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqn", "com/intellij/ws/rest/utils/RSUtils", "findInheritorClassAnnotatedAs"));
        }
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/ws/rest/utils/RSUtils", "findInheritorClassAnnotatedAs"));
        }
        Query query = ClassInheritorsSearch.search((PsiClass)c, (SearchScope)GlobalSearchScope.projectScope((Project)c.getProject()), (boolean)true);
        Collection classes = query.findAll();
        for (PsiClass clazz : classes) {
            if (RSUtils.findAnnotation(fqn, (PsiModifierListOwner)clazz) != null) {
                return clazz;
            }
            PsiClass cl = RSUtils.findInheritorClassAnnotatedAs(fqn, clazz);
            if (cl == null) continue;
            return cl;
        }
        return null;
    }

    public static <T> T[] merge(T[] a1, T[] a2, Class<T> type) {
        ArrayListSet set = new ArrayListSet();
        ContainerUtil.addAll((Collection)set, (Object[])a1);
        ContainerUtil.addAll((Collection)set, (Object[])a2);
        Object[] array = (Object[])Array.newInstance(type, set.size());
        return set.toArray(array);
    }

    public static boolean isRootResourceClass(PsiElement element) {
        return element instanceof PsiClass && RSUtils.isNonAbstractAndPublicClass((PsiClass)element) && RSUtils.isAnnotatedAs("javax.ws.rs.Path", element);
    }

    public static void annotateFieldWithPathParam(Project project, PsiField field, String name) {
        PsiModifierList modifierList = field.getModifierList();
        if (modifierList == null) {
            return;
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(field.getContainingFile())) {
            return;
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
        PsiAnnotation annotation = factory.createAnnotationFromText("@javax.ws.rs.PathParam(\"" + name + "\")", (PsiElement)field);
        PsiElement firstChild = modifierList.getFirstChild();
        if (firstChild != null) {
            modifierList.addBefore((PsiElement)annotation, firstChild);
        } else {
            modifierList.add((PsiElement)annotation);
        }
        JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)modifierList);
    }

    public static boolean isRestLibAttached(Module module) {
        return RSUtils.isRestLibAttached(module, "javax.ws.rs.Path");
    }

    public static boolean isRestLibAttached(Module module, String requiredClassName) {
        return JavaPsiFacade.getInstance((Project)module.getProject()).findClass(requiredClassName, GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module)) != null;
    }
}

