/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest.view;

import com.intellij.codeInsight.documentation.DocumentationComponent;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.ui.FinderRecursivePanel;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ws.rest.model.jam.RSHttpMethod;
import com.intellij.ws.rest.model.jam.RSJamModel;
import com.intellij.ws.rest.model.jam.RSJamPsiClassPath;
import com.intellij.ws.rest.model.jam.RSJamPsiMethodPath;
import com.intellij.ws.rest.view.RSViewFinderRecursivePanel;
import icons.RSIcons;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RSHttpMethodFinderRecursivePanel
extends FinderRecursivePanel<RSHttpMethod> {
    private final RSJamPsiClassPath myPath;
    private RSViewFinderRecursivePanel myPanel;
    private DocumentationComponent myDocumentationComponent;

    public RSHttpMethodFinderRecursivePanel(RSViewFinderRecursivePanel panel, @NotNull RSJamPsiClassPath path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/ws/rest/view/RSHttpMethodFinderRecursivePanel", "<init>"));
        }
        super((FinderRecursivePanel)panel);
        this.myPanel = panel;
        this.myPath = path;
    }

    @Nullable
    protected JComponent createRightComponent(RSHttpMethod method) {
        return this.getDocumentationComponent((PsiElement)method.getPsiElement());
    }

    public DocumentationComponent getDocumentationComponent(PsiElement element) {
        DocumentationManager manager = DocumentationManager.getInstance((Project)this.myPanel.getProject());
        if (this.myDocumentationComponent == null) {
            this.myDocumentationComponent = new DocumentationComponent(manager);
            Disposer.register((Disposable)this, (Disposable)this.myDocumentationComponent);
        }
        manager.fetchDocInfo(element, this.myDocumentationComponent);
        return this.myDocumentationComponent;
    }

    protected void doCustomizeCellRenderer(SimpleColoredComponent coloredComponent, JList list, RSHttpMethod method, int index, boolean selected, boolean hasFocus) {
        coloredComponent.clear();
        coloredComponent.setIcon(this.myPanel.isShowResourcesView() ? RSIcons.WebServicesClass : this.getItemIcon(method));
        JamService service = JamService.getJamService((Project)this.getProject());
        RSJamPsiMethodPath methodPathResource = (RSJamPsiMethodPath)service.getJamElement((PsiElement)method.getPsiElement(), new JamMemberMeta[]{RSJamPsiMethodPath.META});
        String methodSignature = RSHttpMethodFinderRecursivePanel.getMethodSignature(method);
        String resourceValue = null;
        if (methodPathResource != null) {
            resourceValue = methodPathResource.getResourceValue();
        }
        resourceValue = resourceValue == null ? "" : "\"" + resourceValue + "\"";
        coloredComponent.append(this.myPanel.isShowResourcesView() ? resourceValue : methodSignature);
        coloredComponent.append(" @" + method.getShortAnnoName() + " ", SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES, this.myPanel.isShowResourcesView());
        coloredComponent.append("(" + (this.myPanel.isShowResourcesView() ? methodSignature : resourceValue) + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
    }

    public static String getMethodSignature(RSHttpMethod method) {
        return PsiFormatUtil.formatMethod((PsiMethod)method.getPsiElement(), (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)7, (int)2);
    }

    @NotNull
    protected List<RSHttpMethod> getListItems() {
        ArrayList<RSHttpMethod> items = new ArrayList<RSHttpMethod>();
        List<RSHttpMethod> methods = RSJamModel.getModel(this.getProject()).getHttpMethods(this.myPath.getPsiElement());
        for (RSHttpMethod httpMethod : RSViewFinderRecursivePanel.getFilteredMethods(methods, this.getProject())) {
            items.add(httpMethod);
        }
        ArrayList<RSHttpMethod> arrayList = items;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/rest/view/RSHttpMethodFinderRecursivePanel", "getListItems"));
        }
        return arrayList;
    }

    protected JComponent createDefaultRightComponent() {
        return this.getDocumentationComponent((PsiElement)this.myPath.getPsiElement());
    }

    @Nullable
    protected Icon getItemIcon(RSHttpMethod method) {
        return method.getPsiElement().getIcon(0);
    }

    protected boolean hasChildren(RSHttpMethod method) {
        return false;
    }

    @NotNull
    protected String getItemText(RSHttpMethod method) {
        String resourceValue;
        if (!method.isValid()) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/rest/view/RSHttpMethodFinderRecursivePanel", "getItemText"));
            }
            return "";
        }
        JamService service = JamService.getJamService((Project)this.getProject());
        RSJamPsiMethodPath methodPathResource = (RSJamPsiMethodPath)service.getJamElement((PsiElement)method.getPsiElement(), new JamMemberMeta[]{RSJamPsiMethodPath.META});
        String methodSignature = RSHttpMethodFinderRecursivePanel.getMethodSignature(method);
        if (methodPathResource != null && (resourceValue = methodPathResource.getResourceValue()) != null) {
            String string = methodSignature + " ( \"" + resourceValue + "\" )";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/rest/view/RSHttpMethodFinderRecursivePanel", "getItemText"));
            }
            return string;
        }
        String string = methodSignature;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/rest/view/RSHttpMethodFinderRecursivePanel", "getItemText"));
        }
        return string;
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        RSHttpMethod httpMethod = (RSHttpMethod)((Object)this.getSelectedValue());
        if (CommonDataKeys.NAVIGATABLE.is(dataId) && httpMethod != null) {
            return httpMethod.getPsiElement();
        }
        return super.getData(dataId);
    }
}

