/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.w3validators.css;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.css.CssCharset;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssElementDescriptorProvider;
import com.intellij.psi.css.CssFile;
import com.intellij.psi.css.CssSelector;
import com.intellij.psi.css.CssSimpleSelector;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.CssUri;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtil;
import com.intellij.psi.css.inspections.suppress.CssSuppressionUtil;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlFile;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.w3validators.W3ValidatorsBundle;
import org.jetbrains.w3validators.css.W3CssValidatorInspection;
import org.jetbrains.w3validators.css.W3DisableInspectionFix;
import org.jetbrains.w3validators.css.W3IgnoreVendorPropertiesFix;
import org.w3c.css.css.StyleSheet;
import org.w3c.css.css.StyleSheetParser;
import org.w3c.css.parser.CssError;
import org.w3c.css.parser.CssParseException;
import org.w3c.css.parser.Errors;
import org.w3c.css.parser.analyzer.ParseException;
import org.w3c.css.parser.analyzer.Token;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import sun.net.www.protocol.file.Handler;

public class W3CssExternalAnnotator
extends ExternalAnnotator<MyVisitor, MyVisitor> {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.w3validators.css.W3CssExternalAnnotator");

    public MyVisitor collectInformation(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/w3validators/css/W3CssExternalAnnotator", "collectInformation"));
        }
        if (!(file instanceof XmlFile) && !(file instanceof CssFile)) {
            return null;
        }
        W3CssValidatorInspection inspection = W3CssExternalAnnotator.getInspection((PsiElement)file);
        if (inspection == null) {
            return null;
        }
        MyVisitor visitor = new MyVisitor(inspection.myCssVersion, inspection.myIgnoreVendorSpecificProperties);
        file.accept((PsiElementVisitor)visitor);
        return visitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MyVisitor doAnnotate(MyVisitor visitor) {
        ApplContext context = new ApplContext(W3ValidatorsBundle.message("css.content.type", new Object[0]));
        context.setCssVersion(visitor.myCssVersion);
        context.setTreatVendorExtensionsAsWarnings(visitor.myIgnoreVendorSpecificProperties);
        for (MyInfo info : visitor.myInfos) {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(info.myStylesheetText.getBytes(Charsets.UTF_8));
            try {
                context.setCharsetForURL(info.myUrl, info.myCharset);
                StyleSheetParser parser = new StyleSheetParser();
                parser.parseStyleElement(context, (InputStream)inputStream, null, "all", info.myUrl, 0);
                StyleSheet styleSheet = parser.getStyleSheet();
                styleSheet.findConflicts(context);
                info.myErrors = styleSheet.getErrors();
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    LOG.info((Throwable)e);
                }
            }
        }
        return visitor;
    }

    public void apply(@NotNull PsiFile file, MyVisitor visitor, @NotNull AnnotationHolder holder) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/w3validators/css/W3CssExternalAnnotator", "apply"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/w3validators/css/W3CssExternalAnnotator", "apply"));
        }
        Document document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
        if (document == null) {
            return;
        }
        for (MyInfo info : visitor.myInfos) {
            PsiElement element;
            if (info.myErrors == null || !((element = info.myStylesheetAnchor.retrieve()) instanceof CssStylesheet)) continue;
            W3CssExternalAnnotator.reportErrors((CssStylesheet)element, document, info.myErrors, holder);
        }
    }

    @Nullable
    private static W3CssValidatorInspection getInspection(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/w3validators/css/W3CssExternalAnnotator", "getInspection"));
        }
        String shortName = "W3CssValidation";
        HighlightDisplayKey key = HighlightDisplayKey.find((String)"W3CssValidation");
        if (key == null) {
            return null;
        }
        InspectionProfile profile = InspectionProjectProfileManager.getInstance((Project)context.getProject()).getInspectionProfile();
        if (!profile.isToolEnabled(key, context)) {
            return null;
        }
        return (W3CssValidatorInspection)profile.getUnwrappedTool("W3CssValidation", context);
    }

    private static void reportErrors(CssStylesheet stylesheet, Document document, Errors errors, AnnotationHolder annotationHolder) {
        ProgressManager.checkCanceled();
        int startLine = document.getLineNumber(stylesheet.getTextRange().getStartOffset());
        PsiFile psiFile = stylesheet.getContainingFile();
        W3CssValidatorInspection inspection = W3CssExternalAnnotator.getInspection((PsiElement)stylesheet);
        for (CssError error : errors.getErrors()) {
            PsiElement selectorList;
            PsiElement parent;
            String message;
            ProgressManager.checkCanceled();
            int line = error.getLine() - 1;
            if (line <= 0) continue;
            int startOffset = document.getLineStartOffset(line + startLine);
            Throwable exception = error.getException();
            if (!(exception instanceof ParseException)) continue;
            ParseException parseException = (ParseException)exception;
            if (parseException instanceof CssParseException) {
                String message2 = parseException.getMessage();
                message2 = message2 == null ? "Parse Error" : message2;
                CssParseException cssParseException = (CssParseException)parseException;
                String property = cssParseException.getProperty();
                if (property != null) {
                    PsiElement element;
                    PsiElement psiElement = psiFile.findElementAt(startOffset);
                    if (psiElement instanceof PsiWhiteSpace) {
                        psiElement = psiFile.findElementAt(psiElement.getTextRange().getEndOffset());
                    }
                    if (psiElement == null || !((element = psiElement.getParent()) instanceof CssDeclaration)) continue;
                    CssDeclaration firstDecl = (CssDeclaration)element;
                    int endOffset = document.getLineEndOffset(line + startLine);
                    CssDeclaration decl = W3CssExternalAnnotator.findCssDeclaration(property, firstDecl, new TextRange(startOffset, endOffset));
                    W3CssExternalAnnotator.registerProblem((PsiElement)(decl != null ? decl : firstDecl), "W3C: " + message2, annotationHolder, inspection);
                    continue;
                }
                Exception innerParseException = cssParseException.getException();
                if (!(innerParseException instanceof ParseException)) continue;
                message2 = "W3C: Parse error " + cssParseException.getSkippedString();
                ParseException parseException1 = (ParseException)innerParseException;
                Token token = parseException1.currentToken;
                if (token == null) continue;
                int tokenLine = token.beginLine - 1;
                int tokenColumn = token.beginColumn;
                int lineStartOffset = document.getLineStartOffset(tokenLine + startLine);
                PsiElement psiElement = psiFile.findElementAt(lineStartOffset + tokenColumn);
                if (psiElement == null) continue;
                W3CssExternalAnnotator.registerProblem(psiElement, message2, annotationHolder, inspection);
                continue;
            }
            if (!(parseException instanceof InvalidParamException)) continue;
            PsiElement psiElement = psiFile.findElementAt(startOffset);
            if (psiElement instanceof PsiWhiteSpace) {
                psiElement = psiFile.findElementAt(psiElement.getTextRange().getEndOffset());
            }
            if ((message = parseException.getMessage()) == null || psiElement == null) continue;
            PsiElement element = psiElement.getParent();
            if (element instanceof CssDeclaration) {
                CssDeclaration declaration = (CssDeclaration)element;
                W3CssExternalAnnotator.registerProblem((PsiElement)declaration, "W3C: " + message, annotationHolder, inspection);
                continue;
            }
            if (!(element instanceof CssSimpleSelector) || (parent = element.getParent()) == null || !(parent instanceof CssSelector) || (selectorList = parent.getParent()) == null) continue;
            W3CssExternalAnnotator.registerProblem(selectorList, "W3C: " + message, annotationHolder, inspection);
        }
    }

    private static void registerProblem(@NotNull PsiElement selectorList, String message, AnnotationHolder annotationHolder, @Nullable W3CssValidatorInspection inspection) {
        CssTermList value;
        if (selectorList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectorList", "org/jetbrains/w3validators/css/W3CssExternalAnnotator", "registerProblem"));
        }
        if (inspection == null || CssSuppressionUtil.isSuppressedFor((PsiElement)selectorList, (String)inspection.getID())) {
            return;
        }
        if (selectorList instanceof CssDeclaration && (value = ((CssDeclaration)selectorList).getValue()) != null) {
            for (PsiElement child : value.getChildren()) {
                PsiElement[] children;
                if (!(child instanceof CssTerm)) continue;
                for (PsiElement element : children = child.getChildren()) {
                    if (!(element instanceof CssUri) || !InjectedLanguageUtil.hasInjections((PsiLanguageInjectionHost)((PsiLanguageInjectionHost)element))) continue;
                    return;
                }
            }
        }
        Annotation annotation = annotationHolder.createWarningAnnotation(selectorList, message);
        if (!inspection.myIgnoreVendorSpecificProperties && selectorList instanceof CssDeclaration && StringUtil.startsWithChar((CharSequence)((CssDeclaration)selectorList).getPropertyName(), (char)'-')) {
            annotation.registerFix((IntentionAction)new W3IgnoreVendorPropertiesFix(inspection));
        }
        annotation.registerFix((IntentionAction)new W3DisableInspectionFix(inspection));
    }

    @Nullable
    private static CssDeclaration findCssDeclaration(@NotNull String propertyName, @NotNull CssDeclaration first, @NotNull TextRange lineRange) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "org/jetbrains/w3validators/css/W3CssExternalAnnotator", "findCssDeclaration"));
        }
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "org/jetbrains/w3validators/css/W3CssExternalAnnotator", "findCssDeclaration"));
        }
        if (lineRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lineRange", "org/jetbrains/w3validators/css/W3CssExternalAnnotator", "findCssDeclaration"));
        }
        for (CssDeclaration element = first; element != null && (element == first || lineRange.contains(element.getTextRange())); element = element.getNextSibling()) {
            CssDeclaration decl;
            if (!(element instanceof CssDeclaration) || !propertyName.equalsIgnoreCase((decl = element).getPropertyName())) continue;
            return decl;
        }
        return null;
    }

    private static class MyInfo {
        private final URL myUrl;
        private final String myStylesheetText;
        private final PsiAnchor myStylesheetAnchor;
        private final Charset myCharset;
        public volatile Errors myErrors;

        private MyInfo(URL url, PsiAnchor stylesheetAnchor, String stylesheetText, Charset charset) {
            this.myUrl = url;
            this.myStylesheetAnchor = stylesheetAnchor;
            this.myStylesheetText = stylesheetText;
            this.myCharset = charset;
        }
    }

    public static class MyVisitor
    extends PsiRecursiveElementWalkingVisitor {
        private final List<MyInfo> myInfos = new ArrayList<MyInfo>();
        private final String myCssVersion;
        private final boolean myIgnoreVendorSpecificProperties;

        public MyVisitor(String cssVersion, boolean ignoreVendorSpecificProperties) {
            this.myIgnoreVendorSpecificProperties = ignoreVendorSpecificProperties;
            this.myCssVersion = cssVersion;
        }

        public void visitElement(PsiElement element) {
            super.visitElement(element);
            if (element instanceof CssStylesheet) {
                CssStylesheet stylesheet = (CssStylesheet)element;
                CssElementDescriptorProvider descriptorProvider = CssDescriptorsUtil.findDescriptorProvider((PsiElement)stylesheet);
                if (descriptorProvider == null || !descriptorProvider.providesClassicCss()) {
                    return;
                }
                if (!stylesheet.isValid()) {
                    return;
                }
                if (PsiUtilCore.getTemplateLanguageFile((PsiElement)stylesheet) != stylesheet.getContainingFile()) {
                    return;
                }
                String s = stylesheet.getText();
                try {
                    String url;
                    String protocol;
                    VirtualFile virtualFile;
                    PsiFile psiFile = stylesheet.getContainingFile();
                    if (psiFile != null && (virtualFile = psiFile.getVirtualFile()) != null && ("file".equals(protocol = VirtualFileManager.extractProtocol((String)(url = virtualFile.getUrl()))) || "temp".equals(protocol))) {
                        Charset charset = MyVisitor.getCharset(stylesheet);
                        URL urlObj = new URL(null, url, new Handler());
                        this.myInfos.add(new MyInfo(urlObj, PsiAnchor.create((PsiElement)stylesheet), s, charset));
                    }
                }
                catch (MalformedURLException e) {
                    LOG.error((Throwable)e);
                }
            }
        }

        private static Charset getCharset(CssStylesheet stylesheet) {
            String charsetName;
            CssCharset charsetElement = stylesheet.getCharset();
            if (charsetElement != null && (charsetName = charsetElement.getValue()) != null) {
                try {
                    return Charset.forName(charsetName);
                }
                catch (IllegalCharsetNameException e) {
                    LOG.info((Throwable)e);
                }
                catch (UnsupportedCharsetException e) {
                    LOG.info((Throwable)e);
                }
            }
            return Charset.defaultCharset();
        }
    }
}

