/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.w3validators.css;

import com.intellij.codeInsight.daemon.impl.AnnotationHolderImpl;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.inspections.CssApiBaseInspection;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.containers.BidirectionalMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.w3validators.W3ValidatorsBundle;
import org.jetbrains.w3validators.css.W3CssExternalAnnotator;

public class W3CssValidatorInspection
extends CssApiBaseInspection {
    @NonNls
    public static final String SHORT_NAME = "W3CssValidation";
    public String myCssVersion = "css3";
    public boolean myIgnoreVendorSpecificProperties = false;
    @NonNls
    private static final BidirectionalMap<String, String> myVersionToProfile = new BidirectionalMap();

    @NotNull
    public String getGroupDisplayName() {
        String string = W3ValidatorsBundle.message("css.inspection.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/w3validators/css/W3CssValidatorInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getDisplayName() {
        String string = W3ValidatorsBundle.message("css.inspection.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/w3validators/css/W3CssValidatorInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if (SHORT_NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/w3validators/css/W3CssValidatorInspection", "getShortName"));
        }
        return SHORT_NAME;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    public JComponent createOptionsPanel() {
        JPanel result = new JPanel(new BorderLayout());
        JPanel inner = new JPanel();
        inner.setBorder((Border)IdeBorderFactory.createTitledBorder((String)"Settings", (boolean)true));
        inner.setLayout(new BoxLayout(inner, 1));
        result.add((Component)inner, "North");
        JPanel versionPanel = new JPanel(new BorderLayout());
        versionPanel.add((Component)new JLabel(W3ValidatorsBundle.message("css.version.panel.title", new Object[0])), "West");
        ComboBox comboBox = new ComboBox(myVersionToProfile.keySet().toArray());
        List list = myVersionToProfile.getKeysByValue((Object)this.myCssVersion);
        if (list != null && list.size() == 1) {
            comboBox.setSelectedItem(list.get(0));
        }
        comboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(@NotNull ItemEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/w3validators/css/W3CssValidatorInspection$1", "itemStateChanged"));
                }
                Object item = e.getItem();
                if (item instanceof String) {
                    String version = (String)item;
                    String temp = (String)myVersionToProfile.get((Object)version);
                    if (!W3CssValidatorInspection.this.myCssVersion.equals(temp)) {
                        W3CssValidatorInspection.this.myCssVersion = temp;
                    }
                }
            }
        });
        versionPanel.add((Component)comboBox, "Center");
        inner.add(versionPanel);
        inner.add((Component)new SingleCheckboxOptionsPanel(W3ValidatorsBundle.message("ignore.vendor.specific.properties", new Object[0]), (InspectionProfileEntry)this, "myIgnoreVendorSpecificProperties"));
        return result;
    }

    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/w3validators/css/W3CssValidatorInspection", "checkFile"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/w3validators/css/W3CssValidatorInspection", "checkFile"));
        }
        if (isOnTheFly) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        W3CssExternalAnnotator annotator = new W3CssExternalAnnotator();
        W3CssExternalAnnotator.MyVisitor info = annotator.collectInformation(file);
        if (info != null) {
            W3CssExternalAnnotator.MyVisitor annotationResult = annotator.doAnnotate(info);
            AnnotationHolderImpl annotationHolder = new AnnotationHolderImpl(new AnnotationSession(file));
            annotator.apply(file, annotationResult, (AnnotationHolder)annotationHolder);
            return W3CssValidatorInspection.convertToProblemDescriptors((List<Annotation>)annotationHolder, manager, file);
        }
        return ProblemDescriptor.EMPTY_ARRAY;
    }

    private static ProblemDescriptor[] convertToProblemDescriptors(List<Annotation> annotations, InspectionManager manager, PsiFile file) {
        if (annotations.size() == 0) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        ArrayList<ProblemDescriptor> problems = new ArrayList<ProblemDescriptor>();
        for (Annotation annotation : annotations) {
            if (annotation.getSeverity() == HighlightSeverity.INFORMATION || annotation.getStartOffset() == annotation.getEndOffset()) continue;
            PsiElement startElement = file.findElementAt(annotation.getStartOffset());
            PsiElement endElement = file.findElementAt(annotation.getEndOffset() - 1);
            if (startElement == null || endElement == null) continue;
            problems.add(manager.createProblemDescriptor(startElement, endElement, annotation.getMessage(), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false, new LocalQuickFix[0]));
        }
        return problems.toArray(new ProblemDescriptor[problems.size()]);
    }

    static {
        myVersionToProfile.put((Object)"CSS Level 1", (Object)"css1");
        myVersionToProfile.put((Object)"CSS Level 2", (Object)"css2");
        myVersionToProfile.put((Object)"CSS Level 2.1", (Object)"css21");
        myVersionToProfile.put((Object)"CSS Level 3", (Object)"css3");
    }
}

