/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.inspections;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.patterns.ElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReference;
import com.intellij.ws.references.WSReference;
import com.intellij.ws.references.WSReferenceProvider;
import com.intellij.ws.utils.JavaElementVisitor;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractWebServicesReferenceInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/ws/inspections/AbstractWebServicesReferenceInspection", "buildVisitor"));
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            @Override
            public void checkElement(PsiElement element) {
                AbstractWebServicesReferenceInspection.this.checkElement(element, holder);
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/inspections/AbstractWebServicesReferenceInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    @NotNull
    protected abstract Map<ElementPattern<? extends PsiElement>, WSReferenceProvider> getProviders();

    protected void checkElement(PsiElement element, ProblemsHolder holder) {
        for (ElementPattern<? extends PsiElement> pattern : this.getProviders().keySet()) {
            if (!pattern.accepts((Object)element)) continue;
            for (PsiReference reference : element.getReferences()) {
                if (reference.resolve() != null) continue;
                if (reference instanceof WSReference) {
                    WSReference ref = (WSReference)reference;
                    String message = ref.getUnresolvedMessagePattern();
                    if (message == null) continue;
                    holder.registerProblem(holder.getManager().createProblemDescriptor(element, message, holder.isOnTheFly(), ref.getQuickFixes(), ref.getProblemType()));
                    continue;
                }
                if (!(reference instanceof JavaClassReference)) continue;
                holder.registerProblem(element, "Unresolved symbol", ProblemHighlightType.ERROR, new LocalQuickFix[0]);
            }
        }
    }

    public boolean isEnabledByDefault() {
        return true;
    }
}

