/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.actions;

import com.intellij.history.LocalHistory;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Consumer;
import com.intellij.ws.WSBundle;
import com.intellij.ws.actions.BaseWebServiceIntentionAction;
import com.intellij.ws.actions.DeployWebServiceDialog;
import com.intellij.ws.actions.EnableWebServicesSupportUtils;
import com.intellij.ws.engines.wsengine.WSEngine;
import com.intellij.ws.index.FileBasedWSIndex;
import com.intellij.ws.utils.CommonWsUtils;
import com.intellij.ws.utils.DeployUtils;
import com.intellij.ws.utils.LibUtils;
import com.intellij.ws.utils.XmlRecursiveElementVisitor;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExposeAsWebServiceIntention
extends BaseWebServiceIntentionAction {
    @NotNull
    public String getText() {
        String string = WSBundle.message("expose.class.as.web.service.dialog.title", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/actions/ExposeAsWebServiceIntention", "getText"));
        }
        return string;
    }

    @Override
    public void invoke(Project project, PsiElement element) {
        ExposeAsWebServiceIntention.runAction(project, (PsiClass)element.getParent(), null);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ws/actions/ExposeAsWebServiceIntention", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ws/actions/ExposeAsWebServiceIntention", "isAvailable"));
        }
        return ExposeAsWebServiceIntention.isWebServiceClass(element) && !FileBasedWSIndex.hasEntriesFor((PsiClass)element.getParent());
    }

    public boolean startInWriteAction() {
        return false;
    }

    public static void runAction(final Project project, PsiClass classFromDataContext, @Nullable DeployWebServiceDialog previousDialog) {
        final DeployWebServiceDialog dialog = new DeployWebServiceDialog(project, classFromDataContext, previousDialog);
        if (dialog.showAndGet()) {
            LocalHistory.getInstance().putSystemLabel(project, WSBundle.message("expose.class.as.web.service.lvcs.label", new Object[0]));
            final WSEngine currentEngine = dialog.getCurrentEngine();
            Consumer<Exception> onException = new Consumer<Exception>(){

                public void consume(Exception e) {
                    Messages.showErrorDialog((Project)project, (String)e.getMessage(), (String)"Error");
                }
            };
            Runnable restartAction = new Runnable(){

                @Override
                public void run() {
                    ExposeAsWebServiceIntention.runAction(project, null, dialog);
                }
            };
            final Runnable onSuccessAfterServiceDeployment = new Runnable((Consumer)onException, dialog, project){
                final /* synthetic */ Consumer val$onException;
                final /* synthetic */ DeployWebServiceDialog val$dialog;
                final /* synthetic */ Project val$project;
                {
                    this.val$onException = consumer;
                    this.val$dialog = deployWebServiceDialog;
                    this.val$project = project;
                }

                @Override
                public void run() {
                    ExposeAsWebServiceIntention.continueDeployment(currentEngine, (Consumer<Exception>)this.val$onException, this.val$dialog, this.val$project);
                }
            };
            Runnable deploymentAction = new Runnable((Consumer)onException, restartAction){
                final /* synthetic */ Consumer val$onException;
                final /* synthetic */ Runnable val$restartAction;
                {
                    this.val$onException = consumer;
                    this.val$restartAction = runnable2;
                }

                @Override
                public void run() {
                    currentEngine.deployWebService(dialog, dialog.getSelectedModule(), onSuccessAfterServiceDeployment, (Consumer<Exception>)this.val$onException, this.val$restartAction);
                }
            };
            currentEngine.undeployWebService(dialog.getWsName(), dialog.getSelectedModule(), deploymentAction, onException, restartAction);
        }
    }

    private static void continueDeployment(WSEngine currentEngine, Consumer<Exception> onException, DeployWebServiceDialog dialog, Project project) {
        String servletName;
        Module selectedModule = dialog.getSelectedModule();
        if (dialog.isToAddLibs()) {
            EnableWebServicesSupportUtils.setupWebServicesInfrastructureForModule(project, false, selectedModule, currentEngine, true, null);
        }
        if ((servletName = currentEngine.getDeploymentServletName()) != null) {
            final String[] servletClassResult = new String[1];
            try {
                String s = DeployUtils.loadWSWebXml(servletName);
                PsiFile psiFile = PsiFileFactory.getInstance((Project)project).createFileFromText("s.xml", s);
                psiFile.acceptChildren((PsiElementVisitor)new XmlRecursiveElementVisitor(){

                    @Override
                    public void visitXmlTag(XmlTag xmlTag) {
                        if (xmlTag.getName().equals("servlet-class") && servletClassResult[0] == null) {
                            servletClassResult[0] = LibUtils.getStringValue(xmlTag);
                        }
                        if (servletClassResult[0] == null) {
                            super.visitXmlTag(xmlTag);
                        }
                    }
                });
            }
            catch (IOException e) {
                onException.consume((Object)e);
            }
        }
        CommonWsUtils.doFileSystemRefresh();
    }
}

