/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.engines.websphere;

import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.ws.WSBundle;
import com.intellij.ws.WebServicesPluginSettings;
import com.intellij.ws.engines.LibraryDescriptor;
import com.intellij.ws.engines.LibraryInfo;
import com.intellij.ws.engines.wsengine.DeployWebServiceOptions;
import com.intellij.ws.engines.wsengine.GenerateJavaFromWsdlOptions;
import com.intellij.ws.engines.wsengine.GenerateWsdlFromJavaOptions;
import com.intellij.ws.engines.wsengine.WSEngine;
import com.intellij.ws.utils.ExternalProcessHandler;
import com.intellij.ws.utils.InvokeExternalCodeUtil;
import com.intellij.ws.utils.LibUtils;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import org.jetbrains.annotations.Nullable;

public class WebSphereWSEngine
implements WSEngine {
    public static final String WEBSPHERE_PLATFORM = WSBundle.message("websphere.platform.name", new Object[0]);

    @Override
    public boolean hasSeparateClientServerJavaCodeGenerationOption() {
        return true;
    }

    @Override
    public boolean allowsTestCaseGeneration() {
        return true;
    }

    @Override
    @Nullable
    public String[] getSupportedMappingTypesForJavaFromWsdl() {
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    @Override
    public String getDeploymentServletName() {
        return null;
    }

    @Override
    public String getDeploymentServletClassName() {
        return null;
    }

    @Override
    public void doAdditionalWSServerSetup(Module currentModule, WebFacet webFacet) {
    }

    @Override
    public String checkNotAcceptableClassForGenerateWsdl(PsiClass clazz) {
        return null;
    }

    @Override
    public String checkNotAcceptableClassForDeployment(PsiClass clazz) {
        return null;
    }

    @Override
    public void generateWsdlFromJava(GenerateWsdlFromJavaOptions options, Consumer<File> onSuccessAction, Consumer<Exception> onException, Runnable editAgain) {
        PsiClass psiClass = options.getClassForOperation();
        String generateWsdlDir = psiClass.getContainingFile().getContainingDirectory().getVirtualFile().getPath();
        File tempFile = new File(generateWsdlDir + "/" + psiClass.getName() + ".wsdl");
        ArrayList<String> params = new ArrayList<String>();
        params.add("-location");
        params.add(options.getWebServiceURL());
        params.add("-namespace");
        params.add(options.getWebServiceNamespace());
        params.add("-classpath");
        params.add(InvokeExternalCodeUtil.buildClasspathForModule((Module)options.getModule()));
        params.add("-output");
        params.add(tempFile.getPath());
        params.add("-methods");
        params.add(options.getMethods());
        params.add("-style");
        params.add(options.getBindingStyle());
        params.add("-soapAction");
        params.add(options.getSoapAction());
        params.add("-use");
        params.add(options.getUseOfItems());
        params.add(psiClass.getQualifiedName());
        InvokeExternalCodeUtil.BatchExternalProcessHandler batchExternalProcessHandler = new InvokeExternalCodeUtil.BatchExternalProcessHandler(WEBSPHERE_PLATFORM + " WSDL from Java", "Java2WSDL", params);
        batchExternalProcessHandler.setLaunchDir(new File(this.getBasePath(), "bin"));
        InvokeExternalCodeUtil.invokeExternalProcess2((ExternalProcessHandler)batchExternalProcessHandler, (Project)options.getModule().getProject(), (Runnable)options.getSuccessRunnable(onSuccessAction, tempFile), onException, options.isParametersStillValidPredicate(), (Runnable)editAgain);
    }

    @Override
    public void deployWebService(DeployWebServiceOptions createOptions, Module module, Runnable onSuccessAction, Consumer<Exception> onExceptionAction, Runnable restartAction) {
        onSuccessAction.run();
    }

    @Override
    public void undeployWebService(String webServiceName, Module module, Runnable onSuccessAction, Consumer<Exception> onExceptionAction, Runnable restartAction) {
        onSuccessAction.run();
    }

    @Override
    public String[] getAvailableWebServices(Module module) {
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    @Override
    public String[] getWebServicesOperations(String webServiceName, Module module) {
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    @Override
    public ExternalProcessHandler getGenerateJavaFromWsdlHandler(GenerateJavaFromWsdlOptions options) throws InvokeExternalCodeUtil.ExternalCodeException {
        String nsFromUrl;
        ArrayList<String> params = new ArrayList<String>();
        params.add("-o");
        params.add(options.getOutputPath());
        if (options.isServersideSkeletonGeneration()) {
            params.add("-role");
            params.add("server");
            params.add("-container");
            params.add("web");
        } else {
            params.add("-role");
            params.add("client");
        }
        params.add("-genJava");
        params.add("Overwrite");
        params.add("-genXML");
        params.add("Overwrite");
        if (options.isToGenerateTestCase()) {
            params.add("-testCase");
        }
        if (!options.isSupportWrappedStyleOperation()) {
            params.add("-noWrappedOperations");
        }
        if (options.generateClassesForArrays()) {
            params.add("-noWrappedArrays");
        }
        if (options.isGenerateAllElements()) {
            params.add("-all");
        }
        if (options.getUser().length() > 0) {
            params.add("-user");
            params.add(options.getUser());
            params.add("-password");
            params.add(new String(options.getPassword()));
        }
        params.add("-NStoPkg");
        File savedWsdlFile = options.getSavedWsdlFile();
        String detectedNsFromWsdl = LibUtils.retrieveTargetNamespace(savedWsdlFile);
        String string = nsFromUrl = detectedNsFromWsdl != null ? detectedNsFromWsdl : options.getWsdlUrl();
        if (nsFromUrl.endsWith("?wsdl")) {
            nsFromUrl = nsFromUrl.substring(0, nsFromUrl.length() - 5);
        }
        params.add(nsFromUrl + "=" + options.getPackagePrefix());
        params.add(options.getWsdlUrl());
        InvokeExternalCodeUtil.BatchExternalProcessHandler batchExternalProcessHandler = new InvokeExternalCodeUtil.BatchExternalProcessHandler(WEBSPHERE_PLATFORM + " Java from WSDL", "WSDL2Java", params){};
        batchExternalProcessHandler.setLaunchDir(new File(this.getBasePath(), "bin"));
        return batchExternalProcessHandler;
    }

    @Override
    public boolean isConfigured() {
        return this.getBasePath() != null;
    }

    @Override
    public String getName() {
        return WEBSPHERE_PLATFORM;
    }

    @Override
    public LibraryDescriptor[] getLibraryDescriptors(String bindingType, boolean isForGeneratedCode) {
        if (isForGeneratedCode) {
            String basePath = this.getBasePath();
            String runtimesDir = "runtimes";
            File file = new File(basePath, "runtimes");
            File[] files = file.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".jar") && name.contains("webservices.thinclient");
                }
            });
            if (files != null && files.length == 1) {
                return new LibraryDescriptor[]{new LibraryInfo("IBM WebServices Thin Client Library", "runtimes/" + files[0].getName()), new LibraryInfo("Xerces", "java/jre/lib/xml.jar"), new LibraryInfo("J2EE", "lib/j2ee.jar")};
            }
        }
        return new LibraryDescriptor[0];
    }

    @Override
    public String getBasePath() {
        return WebServicesPluginSettings.getInstance().getWebSphereWSPath();
    }

    @Override
    public boolean supportsJaxWs2() {
        return false;
    }

    @Override
    public boolean deploymentSupported() {
        return false;
    }

    @Override
    public String getServiceInvocationTemplateName() {
        return "iwws";
    }

    @Override
    public String getWebServicesInterfaceTemplateName() {
        return "j2ee1_4.webservice.interface.java";
    }

    @Override
    public String getWebServicesTemplateName() {
        return "j2ee1_4.webservice.java";
    }
}

