/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.inspections;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProvider;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.xml.XmlFile;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.util.Function;
import com.intellij.ws.index.FileBasedWSIndex;
import com.intellij.ws.index.WSIndexEntry;
import com.intellij.ws.inspections.BaseWebServicesInspection;
import com.intellij.ws.utils.DeployUtils;
import icons.WSIcons;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.ListModel;
import org.jetbrains.annotations.NotNull;

public class WSLineMarkerProvider
implements LineMarkerProvider {
    private final FileBasedWSIndex index = FileBasedWSIndex.getInstance();

    public LineMarkerInfo getLineMarkerInfo(@NotNull PsiElement context) {
        PsiClass psiClass;
        WSIndexEntry[] entries;
        PsiClass psiClass2;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/ws/inspections/WSLineMarkerProvider", "getLineMarkerInfo"));
        }
        if (!(context instanceof PsiIdentifier)) {
            return null;
        }
        final PsiElement element = context.getParent();
        if (element instanceof PsiClass) {
            psiClass2 = (PsiClass)element;
            entries = this.index.getWsEntries(psiClass2);
        } else if (element instanceof PsiMethod) {
            psiClass2 = ((PsiMethod)element).getContainingClass();
            if (psiClass2 == null) {
                return null;
            }
            String key = FileBasedWSIndex.getKey((PsiMember)psiClass2);
            if (key == null) {
                return null;
            }
            Module module = ModuleUtil.findModuleForPsiElement((PsiElement)element);
            if (module == null) {
                return null;
            }
            entries = FileBasedWSIndex.getEntries(module, psiClass2.getName());
        } else {
            entries = null;
        }
        if (entries == null || entries.length == 0) {
            return null;
        }
        final ArrayList<VirtualFile> files = new ArrayList<VirtualFile>(entries.length);
        final ArrayList<TextRange> ranges = new ArrayList<TextRange>(entries.length);
        Project project = element.getProject();
        PsiMember member = (PsiMember)element;
        PsiClass psiClass3 = psiClass = member instanceof PsiClass ? (PsiClass)member : member.getContainingClass();
        if (psiClass == null || !BaseWebServicesInspection.getClassContext(psiClass).isExternallyBound()) {
            return null;
        }
        for (WSIndexEntry entry : entries) {
            if (!entry.isResolved(project)) {
                entry.resolve(project);
            }
            TextRange wsRange = entry.getWsRange(member);
            VirtualFile file = entry.getFile();
            if (wsRange == null || file == null) continue;
            files.add(file);
            ranges.add(wsRange);
        }
        if (member instanceof PsiMethod && !DeployUtils.canBeWebMethod(member)) {
            return null;
        }
        if (files.isEmpty()) {
            return null;
        }
        GutterIconNavigationHandler<PsiMember> handler = new GutterIconNavigationHandler<PsiMember>(){

            public void navigate(MouseEvent e, PsiMember elt) {
                if (entries.length > 1 && files.size() > 1) {
                    JBList list = new JBList((ListModel)new AbstractListModel(){

                        @Override
                        public int getSize() {
                            return files.size();
                        }

                        @Override
                        public Object getElementAt(int index) {
                            return files.get(index);
                        }
                    });
                    list.setCellRenderer(new DefaultListCellRenderer(){

                        @Override
                        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                            return super.getListCellRendererComponent((JList<?>)list, ((VirtualFile)value).getPresentableName(), index, isSelected, cellHasFocus);
                        }
                    });
                    JBPopupFactory.getInstance().createListPopupBuilder((JList)list).setTitle("Select Target").setItemChoosenCallback(new Runnable((JList)list){
                        final /* synthetic */ JList val$list;
                        {
                            this.val$list = jList;
                        }

                        @Override
                        public void run() {
                            int selectedIndex = this.val$list.getSelectedIndex();
                            if (selectedIndex == -1) {
                                return;
                            }
                            WSLineMarkerProvider.navigate((VirtualFile)files.get(selectedIndex), (TextRange)ranges.get(selectedIndex), element.getManager());
                        }
                    }).createPopup().show(new RelativePoint(e));
                } else if (!files.isEmpty() && !ranges.isEmpty()) {
                    WSLineMarkerProvider.navigate((VirtualFile)files.get(0), (TextRange)ranges.get(0), element.getManager());
                }
            }
        };
        return new LineMarkerInfo((PsiElement)member, context.getTextRange(), WSIcons.WebServicesClass, 4, (Function)new Function<PsiMember, String>(){

            public String fun(PsiMember psiMember) {
                return WSLineMarkerProvider.getTooltipText(entries, psiMember);
            }
        }, (GutterIconNavigationHandler)handler, GutterIconRenderer.Alignment.LEFT);
    }

    private static void navigate(@NotNull VirtualFile file, @NotNull TextRange range, @NotNull PsiManager psiManager) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ws/inspections/WSLineMarkerProvider", "navigate"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/ws/inspections/WSLineMarkerProvider", "navigate"));
        }
        if (psiManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiManager", "com/intellij/ws/inspections/WSLineMarkerProvider", "navigate"));
        }
        if (file.isValid()) {
            PsiElement elementAt;
            XmlFile psiFile = (XmlFile)psiManager.findFile(file);
            assert (psiFile != null);
            int startOffset = range.getStartOffset();
            if (startOffset < psiFile.getTextLength() && (elementAt = psiFile.findElementAt(startOffset)) instanceof Navigatable) {
                ((Navigatable)elementAt).navigate(true);
            }
        }
    }

    private static String getTooltipText(WSIndexEntry[] entries, PsiMember member) {
        StringBuilder messageSource = new StringBuilder();
        for (WSIndexEntry entry : entries) {
            String wsStatus = entry.getWsStatus(member);
            if (wsStatus == null || messageSource.indexOf(wsStatus) != -1) continue;
            if (messageSource.length() > 0) {
                messageSource.append(',');
            }
            messageSource.append(wsStatus);
        }
        String message = messageSource.toString();
        return message == null ? "" : message;
    }

    public void collectSlowLineMarkers(@NotNull List<PsiElement> elements, @NotNull Collection<LineMarkerInfo> result) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/ws/inspections/WSLineMarkerProvider", "collectSlowLineMarkers"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/ws/inspections/WSLineMarkerProvider", "collectSlowLineMarkers"));
        }
    }
}

