/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.references;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceUtil;
import com.intellij.psi.impl.source.xml.SchemaPrefixReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.io.URLUtil;
import com.intellij.ws.references.BaseRangedReference;
import com.intellij.ws.references.MyPathReferenceProvider;
import com.intellij.ws.references.MyReferenceProvider;
import com.intellij.ws.references.MyResolveResult;
import com.intellij.ws.utils.DeployUtils;
import com.intellij.ws.utils.WsPsiUtil;
import com.intellij.ws.utils.WsReferenceProvidersHelper;
import com.intellij.xml.util.XmlUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WSDLReferenceProvider
extends MyReferenceProvider {
    @NonNls
    private static final String TYPE_ATTR_NAME = "type";
    @NonNls
    private static final String LOCATION_ATTR_NAME = "location";
    @NonNls
    private static final String ELEMENT_ATTR_NAME = "element";
    @NonNls
    public static final String NAME_ATTR_NAME = "name";
    @NonNls
    private static final String BINDING_ATTR_NAME = "binding";
    @NonNls
    private static final String MESSAGE_ATTR_NAME = "message";
    @NonNls
    private static final String TARGET_NAMESPACE_ATTR_NAME = "targetNamespace";
    @NonNls
    private static final String BINDING_TAG_NAME = "binding";
    @NonNls
    public static final String PORT_TYPE_TAG_NAME = "portType";
    @NonNls
    private static final String PORT_TAG_NAME = "port";
    @NonNls
    private static final String INPUT_TAG_NAME = "input";
    @NonNls
    private static final String OUTPUT_TAG_NAME = "output";
    @NonNls
    private static final String FAULT_TAG_NAME = "fault";
    @NonNls
    private static final String MESSAGE_TAG_NAME = "message";
    @NonNls
    public static final String OPERATION_TAG_NAME = "operation";
    @NonNls
    public static final String PART_TAG_NAME = "part";
    @NonNls
    public static final String COMPLEX_TYPE_TAG_NAME = "complexType";
    @NonNls
    public static final String ELEMENT_TAG_NAME = "element";
    @NonNls
    private static final String IMPORT_TAG_NAME = "import";
    @NonNls
    private static final String TYPES_TAG_NAME = "types";
    private static final TagCollector schemaTagCollector = new TagCollector(){

        @Override
        @NotNull
        public XmlTag[] findNeededTags(@NotNull XmlTag t, String param) {
            if (t == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/ws/references/WSDLReferenceProvider$1", "findNeededTags"));
            }
            XmlTag[] xmlTagArray = t.findSubTags("element", t.getNamespace());
            if (xmlTagArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/references/WSDLReferenceProvider$1", "findNeededTags"));
            }
            return xmlTagArray;
        }

        @Override
        @NotNull
        public XmlTag[] findImportedTags(@NotNull XmlTag t) {
            if (t == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/ws/references/WSDLReferenceProvider$1", "findImportedTags"));
            }
            XmlTag[] xmlTagArray = (XmlTag[])ArrayUtil.mergeArrays((Object[])t.findSubTags(WSDLReferenceProvider.IMPORT_TAG_NAME, t.getNamespace()), (Object[])t.findSubTags("include", t.getNamespace()));
            if (xmlTagArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/references/WSDLReferenceProvider$1", "findImportedTags"));
            }
            return xmlTagArray;
        }

        @Override
        @NotNull
        public String getImportedFileLocationAttrName() {
            if ("schemaLocation" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/references/WSDLReferenceProvider$1", "getImportedFileLocationAttrName"));
            }
            return "schemaLocation";
        }
    };
    private static final TagCollector wsdlTagsCollector = new TagCollector(){

        @Override
        @NotNull
        public XmlTag[] findNeededTags(@NotNull XmlTag t, String param) {
            if (t == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/ws/references/WSDLReferenceProvider$2", "findNeededTags"));
            }
            XmlTag[] xmlTagArray = t.findSubTags(param, t.getNamespace());
            if (xmlTagArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/references/WSDLReferenceProvider$2", "findNeededTags"));
            }
            return xmlTagArray;
        }

        @Override
        @NotNull
        public XmlTag[] findImportedTags(@NotNull XmlTag t) {
            if (t == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/ws/references/WSDLReferenceProvider$2", "findImportedTags"));
            }
            XmlTag[] xmlTagArray = t.findSubTags(WSDLReferenceProvider.IMPORT_TAG_NAME, t.getNamespace());
            if (xmlTagArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/references/WSDLReferenceProvider$2", "findImportedTags"));
            }
            return xmlTagArray;
        }

        @Override
        @NotNull
        public String getImportedFileLocationAttrName() {
            if (WSDLReferenceProvider.LOCATION_ATTR_NAME == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/references/WSDLReferenceProvider$2", "getImportedFileLocationAttrName"));
            }
            return WSDLReferenceProvider.LOCATION_ATTR_NAME;
        }
    };
    private final MyPathReferenceProvider myPathProvider = WsReferenceProvidersHelper.getInstance().acquirePathReferenceProvider(false);
    private static final String[] ATTR_NAMES = new String[]{"type", "name", "binding", "message", "location", "element"};
    @NonNls
    static String[] SCHEMA_URIS = XmlUtil.SCHEMA_URIS;

    @Override
    @Nullable
    public ElementFilter getAttributeFilter() {
        return null;
    }

    @Nullable
    static XmlTag getRootTag(PsiElement element) {
        XmlDocument document;
        XmlFile xmlFile;
        if (element instanceof XmlElement && (xmlFile = (XmlFile)element.getContainingFile()) != null && (document = xmlFile.getDocument()) != null) {
            return document.getRootTag();
        }
        return null;
    }

    @Override
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/ws/references/WSDLReferenceProvider", "getReferencesByElement"));
        }
        PsiElement parent = psiElement.getParent();
        if (parent instanceof XmlAttribute) {
            XmlAttribute xmlAttribute = (XmlAttribute)parent;
            XmlTag parentTag = xmlAttribute.getParent();
            String tagNS = parentTag.getNamespace();
            String attrName = xmlAttribute.getName();
            String tagLocalName = parentTag.getLocalName();
            if (!"http://schemas.xmlsoap.org/wsdl/".equals(tagNS) && !"http://www.w3.org/2003/03/wsdl".equals(tagNS)) {
                if (Arrays.binarySearch(SCHEMA_URIS, tagNS) >= 0 && NAME_ATTR_NAME.equals(attrName)) {
                    VirtualFile file;
                    PsiFile psiFile = psiElement.getContainingFile();
                    VirtualFile virtualFile = file = psiFile != null ? psiFile.getOriginalFile().getVirtualFile() : null;
                    if (file == null || !"wsdl".equals(file.getExtension())) {
                        if (PsiReference.EMPTY_ARRAY == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/references/WSDLReferenceProvider", "getReferencesByElement"));
                        }
                        return PsiReference.EMPTY_ARRAY;
                    }
                    if (COMPLEX_TYPE_TAG_NAME.equals(tagLocalName)) {
                        PsiReference[] psiReferenceArray = new PsiReference[]{new WsdlClassReference(psiElement, 1, psiElement.getTextLength() - 1)};
                        if (psiReferenceArray == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/references/WSDLReferenceProvider", "getReferencesByElement"));
                        }
                        return psiReferenceArray;
                    }
                    if ("element".equals(tagLocalName)) {
                        PsiReference[] psiReferenceArray = new PsiReference[]{new WsdlPropertyReference(psiElement)};
                        if (psiReferenceArray == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/references/WSDLReferenceProvider", "getReferencesByElement"));
                        }
                        return psiReferenceArray;
                    }
                }
                if (PsiReference.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/references/WSDLReferenceProvider", "getReferencesByElement"));
                }
                return PsiReference.EMPTY_ARRAY;
            }
            String text = StringUtil.unquoteString((String)psiElement.getText());
            int i = text.indexOf(58);
            if ("binding".equals(attrName)) {
                if (PORT_TAG_NAME.equals(tagLocalName)) {
                    PsiReference[] psiReferenceArray = WSDLReferenceProvider.collectQReferences(psiElement, text, i, "binding");
                    if (psiReferenceArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/references/WSDLReferenceProvider", "getReferencesByElement"));
                    }
                    return psiReferenceArray;
                }
            } else if ("message".equals(attrName)) {
                if (INPUT_TAG_NAME.equals(tagLocalName) || OUTPUT_TAG_NAME.equals(tagLocalName) || FAULT_TAG_NAME.equals(tagLocalName)) {
                    PsiReference[] psiReferenceArray = WSDLReferenceProvider.collectQReferences(psiElement, text, i, "message");
                    if (psiReferenceArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/references/WSDLReferenceProvider", "getReferencesByElement"));
                    }
                    return psiReferenceArray;
                }
            } else if (TYPE_ATTR_NAME.equals(attrName)) {
                boolean isBindingTagName = "binding".equals(tagLocalName);
                if (isBindingTagName || PART_TAG_NAME.equals(tagLocalName)) {
                    Object[] refs = isBindingTagName ? WSDLReferenceProvider.collectQReferences(psiElement, text, i, PORT_TYPE_TAG_NAME) : PsiReference.EMPTY_ARRAY;
                    if ((refs = (PsiReference[])ArrayUtil.append((Object[])refs, (Object)new WsdlClassReference(psiElement, i + 2, text.length() + 1))) == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/references/WSDLReferenceProvider", "getReferencesByElement"));
                    }
                    return refs;
                }
            } else if (NAME_ATTR_NAME.equals(attrName)) {
                String grandParentLocalName;
                XmlTag grandParentTag;
                if (PORT_TYPE_TAG_NAME.equals(tagLocalName)) {
                    PsiReference[] psiReferenceArray = new PsiReference[]{new WsdlClassReference(psiElement, 1, psiElement.getTextLength() - 1)};
                    if (psiReferenceArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/references/WSDLReferenceProvider", "getReferencesByElement"));
                    }
                    return psiReferenceArray;
                }
                if (OPERATION_TAG_NAME.equals(tagLocalName) && (grandParentTag = parentTag.getParentTag()) != null && (PORT_TYPE_TAG_NAME.equals(grandParentLocalName = grandParentTag.getLocalName()) || "binding".equals(grandParentLocalName))) {
                    PsiReference[] psiReferenceArray = new PsiReference[]{new WsdlMethodReference(psiElement)};
                    if (psiReferenceArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/references/WSDLReferenceProvider", "getReferencesByElement"));
                    }
                    return psiReferenceArray;
                }
            } else if (LOCATION_ATTR_NAME.equals(attrName)) {
                if (IMPORT_TAG_NAME.equals(tagLocalName) && !URLUtil.containsScheme((String)text)) {
                    PsiReference[] psiReferenceArray = this.myPathProvider.getReferencesByString(text, psiElement, 1);
                    if (psiReferenceArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/references/WSDLReferenceProvider", "getReferencesByElement"));
                    }
                    return psiReferenceArray;
                }
            } else if ("element".equals(attrName) && PART_TAG_NAME.equals(tagLocalName)) {
                WsdlEntityReference wsdlEntityReference = new WsdlEntityReference(psiElement, i + 2, text.length() + 1, null){

                    @Override
                    protected void processTags(PsiElementProcessor<XmlTag> processor) {
                        XmlTag rootTag = WSDLReferenceProvider.getRootTag(this.getElement());
                        if (rootTag == null) {
                            return;
                        }
                        for (XmlTag t : WSDLReferenceProvider.getWsdlTags(rootTag, WSDLReferenceProvider.TYPES_TAG_NAME)) {
                            for (XmlTag t2 : t.getSubTags()) {
                                if (WSDLReferenceProvider.processSchemaTags((PsiElementProcessor<XmlTag>)processor, t2)) continue;
                                return;
                            }
                        }
                        for (XmlTag t : WSDLReferenceProvider.getWsdlTags(rootTag, WSDLReferenceProvider.IMPORT_TAG_NAME)) {
                            PsiFile _xmlFile;
                            XmlAttribute locationAttr = t.getAttribute(WSDLReferenceProvider.LOCATION_ATTR_NAME);
                            if (locationAttr == null || !((_xmlFile = FileReferenceUtil.findFile((PsiElement)locationAttr.getValueElement())) instanceof XmlFile) || (rootTag = ((XmlFile)_xmlFile).getRootTag()) == null || !WSDLReferenceProvider.processSchemaTags((PsiElementProcessor<XmlTag>)processor, rootTag)) continue;
                            return;
                        }
                    }
                };
                PsiReference[] psiReferenceArray = new PsiReference[]{wsdlEntityReference};
                if (psiReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/references/WSDLReferenceProvider", "getReferencesByElement"));
                }
                return psiReferenceArray;
            }
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/references/WSDLReferenceProvider", "getReferencesByElement"));
        }
        return PsiReference.EMPTY_ARRAY;
    }

    private static boolean processSchemaTags(PsiElementProcessor<XmlTag> processor, XmlTag t2) {
        for (XmlTag t : WSDLReferenceProvider.collectTags(t2, null, schemaTagCollector, null)) {
            if (processor.execute((PsiElement)t)) continue;
            return false;
        }
        return true;
    }

    private static PsiReference[] collectQReferences(PsiElement psiElement, String text, int i, String tagName) {
        return PsiReference.EMPTY_ARRAY;
    }

    public static XmlTag[] getWsdlTags(XmlTag rootTag, String entityName) {
        return WSDLReferenceProvider.collectTags(rootTag, null, wsdlTagsCollector, entityName);
    }

    @Nullable
    private static XmlFile getXmlFileFromAttr(XmlTag t, String attrName) {
        XmlAttribute attribute;
        if (t.getAttributeValue(attrName) != null && (attribute = t.getAttribute(attrName, null)) != null) {
            PsiFile file = FileReferenceUtil.findFile((PsiElement)attribute.getValueElement());
            return file instanceof XmlFile ? (XmlFile)file : null;
        }
        return null;
    }

    private static XmlTag[] collectTags(XmlTag rootTag, Set<PsiFile> visitedFiles, TagCollector collector, String param) {
        if (visitedFiles != null) {
            visitedFiles.add((PsiFile)rootTag.getContainingFile());
        }
        Object[] subTags = collector.findNeededTags(rootTag, param);
        for (XmlTag importTag : collector.findImportedTags(rootTag)) {
            XmlTag includedDocRootTag;
            XmlFile imported = WSDLReferenceProvider.getXmlFileFromAttr(importTag, collector.getImportedFileLocationAttrName());
            if (imported == null) continue;
            if (visitedFiles == null) {
                visitedFiles = new THashSet();
                visitedFiles.add(rootTag.getContainingFile());
            }
            XmlDocument document = imported.getDocument();
            XmlTag xmlTag = includedDocRootTag = visitedFiles.contains(imported) || document == null ? null : document.getRootTag();
            if (includedDocRootTag == null) continue;
            subTags = (XmlTag[])ArrayUtil.mergeArrays((Object[])subTags, (Object[])WSDLReferenceProvider.collectTags(includedDocRootTag, (Set<PsiFile>)visitedFiles, collector, param));
        }
        return subTags;
    }

    @Override
    public String[] getAttributeNames() {
        return ATTR_NAMES;
    }

    static {
        Arrays.sort(SCHEMA_URIS);
    }

    public static class WsdlClassReference
    extends BaseRangedReference
    implements PsiPolyVariantReference {
        private static final String HTTP_PROTOCOL_PREFIX = "http://";
        private static final String JAVA_PREFIX = "java:";

        public WsdlClassReference(PsiElement psiElement, int index, int length) {
            super(psiElement, index, length);
        }

        public WsdlClassReference(XmlAttributeValue element) {
            super((PsiElement)element, ElementManipulators.getValueTextRange((PsiElement)element));
        }

        @Nullable
        protected String getPackageCandidateValueFromNs() {
            TextRange rangeInElement = this.getRangeInElement();
            if (rangeInElement.getStartOffset() > 2) {
                PsiElement psiElement;
                PsiReference referenceAt = this.getElement().findReferenceAt(rangeInElement.getStartOffset() - 2);
                if (referenceAt instanceof SchemaPrefixReference && (psiElement = referenceAt.resolve()) != null) {
                    String text = psiElement.getText();
                    return text == null ? null : StringUtil.unquoteString((String)text);
                }
            } else {
                String s;
                XmlTag rootTag = WSDLReferenceProvider.getRootTag(this.getElement());
                if (rootTag != null && (s = rootTag.getAttributeValue(WSDLReferenceProvider.TARGET_NAMESPACE_ATTR_NAME)) != null) {
                    return s;
                }
            }
            return null;
        }

        @Nullable
        public PsiElement resolve() {
            ResolveResult[] resolveResults = this.multiResolve(false);
            if (resolveResults.length == 1) {
                return resolveResults[0].getElement();
            }
            return null;
        }

        @NotNull
        public Object[] getVariants() {
            if (EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/references/WSDLReferenceProvider$WsdlClassReference", "getVariants"));
            }
            return EMPTY_ARRAY;
        }

        public boolean isSoft() {
            return true;
        }

        private void processCandidatePackages(PsiElementProcessor<PsiPackage> packageProcessor) {
            PsiDirectory psiDirectory;
            PsiPackage aPackage;
            PsiManager manager = this.getElement().getManager();
            String packageCandidateValueFromNs = this.getPackageCandidateValueFromNs();
            if (packageCandidateValueFromNs != null) {
                packageCandidateValueFromNs = WsdlClassReference.removeNsDecorations(packageCandidateValueFromNs);
                String axisPackageCandidateValueFromNs = WsdlClassReference.revertAxisDecoration(packageCandidateValueFromNs);
                aPackage = JavaPsiFacade.getInstance((Project)manager.getProject()).findPackage(axisPackageCandidateValueFromNs);
                if (aPackage != null && !packageProcessor.execute((PsiElement)aPackage)) {
                    return;
                }
                aPackage = JavaPsiFacade.getInstance((Project)manager.getProject()).findPackage(packageCandidateValueFromNs);
                if (aPackage != null && !packageProcessor.execute((PsiElement)aPackage)) {
                    return;
                }
            }
            if ((psiDirectory = this.getElement().getContainingFile().getParent()) != null && (aPackage = JavaDirectoryService.getInstance().getPackage(psiDirectory)) != null) {
                packageProcessor.execute((PsiElement)aPackage);
            }
        }

        private static String revertAxisDecoration(String s) {
            StringTokenizer tokenizer = new StringTokenizer(s, ".");
            StringBuilder buffer = new StringBuilder();
            while (tokenizer.hasMoreTokens()) {
                if (buffer.length() > 0) {
                    buffer.insert(0, '.');
                }
                buffer.insert(0, tokenizer.nextToken());
            }
            return buffer.toString();
        }

        private static String removeNsDecorations(String s) {
            if (s.startsWith(HTTP_PROTOCOL_PREFIX)) {
                s = s.substring(HTTP_PROTOCOL_PREFIX.length());
            }
            if (s.endsWith("/")) {
                s = s.substring(0, s.length() - 1);
            }
            if (s.startsWith(JAVA_PREFIX)) {
                s = s.substring(JAVA_PREFIX.length());
            }
            return s;
        }

        @NotNull
        public ResolveResult[] multiResolve(boolean b) {
            final ResolveResult[][] result = new ResolveResult[1][];
            Project project = this.getElement().getProject();
            final String canonicalText = this.getCanonicalText();
            this.processCandidatePackages(new PsiElementProcessor<PsiPackage>(){
                private final XmlTag parentTag;
                private String canonicalText2;
                private String canonicalText3;
                {
                    this.parentTag = (XmlTag)WsdlClassReference.this.getElement().getParent().getParent();
                    if (this.parentTag.getLocalName().equals("binding")) {
                        this.canonicalText2 = canonicalText + "Stub";
                        this.canonicalText3 = canonicalText + "_BindingStub";
                    } else if (this.parentTag.getLocalName().equals(WSDLReferenceProvider.PORT_TYPE_TAG_NAME)) {
                        this.canonicalText2 = canonicalText + "_PortType";
                        this.canonicalText3 = canonicalText + "_BindingImpl";
                    }
                }

                public boolean execute(@NotNull PsiPackage psiPackage) {
                    if (psiPackage == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "com/intellij/ws/references/WSDLReferenceProvider$WsdlClassReference$1", "execute"));
                    }
                    PsiClass myPossibleResult = null;
                    for (PsiClass clazz : psiPackage.getClasses()) {
                        if (!canonicalText.equals(clazz.getName()) && (this.canonicalText2 == null || !this.canonicalText2.equals(clazz.getName())) && (this.canonicalText3 == null || !this.canonicalText3.equals(clazz.getName()))) continue;
                        if (clazz.isInterface()) {
                            myPossibleResult = clazz;
                            continue;
                        }
                        result[0] = new ResolveResult[]{new MyResolveResult((PsiElement)clazz)};
                        return false;
                    }
                    if (myPossibleResult != null) {
                        result[0] = new ResolveResult[]{new MyResolveResult((PsiElement)myPossibleResult)};
                        return false;
                    }
                    return true;
                }
            });
            if (result[0] != null) {
                ResolveResult[] resolveResultArray = result[0];
                if (resolveResultArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/references/WSDLReferenceProvider$WsdlClassReference", "multiResolve"));
                }
                return resolveResultArray;
            }
            PsiClass[] classes = PsiShortNamesCache.getInstance((Project)project).getClassesByName(canonicalText, GlobalSearchScope.allScope((Project)project));
            ResolveResult[] results = new ResolveResult[classes.length];
            for (int i = 0; i < classes.length; ++i) {
                results[i] = new MyResolveResult((PsiElement)classes[i]);
            }
            if (results == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/references/WSDLReferenceProvider$WsdlClassReference", "multiResolve"));
            }
            return results;
        }
    }

    public static class WsdlPropertyReference
    extends PsiReferenceBase<PsiElement> {
        public WsdlPropertyReference(PsiElement psiElement) {
            super(psiElement);
        }

        public PsiElement handleElementRename(String string) throws IncorrectOperationException {
            String newName;
            if (this.resolve() instanceof PsiMethod && (newName = PropertyUtil.getPropertyName((String)string)) != null) {
                string = newName;
            }
            return super.handleElementRename(string);
        }

        private void process(PsiElementProcessor<PsiMember> processor) {
            PsiClass clazz = this.resolveClass();
            if (clazz != null) {
                WsPsiUtil.processProperties((PsiClass)clazz, processor);
                for (PsiField f : clazz.getFields()) {
                    if (!f.hasModifierProperty("public") || processor.execute((PsiElement)f)) continue;
                    return;
                }
            }
        }

        @Nullable
        public PsiElement resolve() {
            final PsiElement[] result = new PsiElement[1];
            this.process(new PsiElementProcessor<PsiMember>(){

                public boolean execute(@NotNull PsiMember psiMember) {
                    if (psiMember == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMember", "com/intellij/ws/references/WSDLReferenceProvider$WsdlPropertyReference$1", "execute"));
                    }
                    String text = WsdlPropertyReference.this.getCanonicalText();
                    String name = psiMember instanceof PsiMethod ? PropertyUtil.getPropertyName((PsiMethod)((PsiMethod)psiMember)) : psiMember.getName();
                    if (text.length() > 1 && Character.isLowerCase(text.charAt(0)) && Character.isUpperCase(text.charAt(1))) {
                        text = Character.toUpperCase(text.charAt(0)) + text.substring(1);
                    }
                    if (text.length() > 1 && Character.isUpperCase(text.charAt(0)) && Character.isLowerCase(text.charAt(1))) {
                        text = StringUtil.decapitalize((String)text);
                    }
                    if (text.equals(name)) {
                        result[0] = psiMember;
                        return false;
                    }
                    return true;
                }
            });
            return result[0];
        }

        @Nullable
        protected PsiClass resolveClass() {
            PsiElement psiElement;
            PsiReference[] references;
            XmlAttributeValue value;
            XmlAttribute attribute;
            XmlTag xmlTag;
            PsiClass clazz = null;
            PsiElement parentTag = this.getElement().getParent().getParent().getParent().getParent();
            if (parentTag instanceof XmlTag && WSDLReferenceProvider.COMPLEX_TYPE_TAG_NAME.equals((xmlTag = (XmlTag)parentTag).getLocalName()) && xmlTag.getAttributeValue(WSDLReferenceProvider.NAME_ATTR_NAME) != null && (attribute = xmlTag.getAttribute(WSDLReferenceProvider.NAME_ATTR_NAME, null)) != null && (value = attribute.getValueElement()) != null && (references = value.getReferences()).length > 0 && (psiElement = references[references.length - 1].resolve()) instanceof PsiClass) {
                clazz = (PsiClass)psiElement;
            }
            return clazz;
        }

        @NotNull
        public Object[] getVariants() {
            final ArrayList variants = new ArrayList(3);
            this.process(new PsiElementProcessor<PsiMember>(){

                public boolean execute(@NotNull PsiMember psiMember) {
                    if (psiMember == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMember", "com/intellij/ws/references/WSDLReferenceProvider$WsdlPropertyReference$2", "execute"));
                    }
                    if (psiMember instanceof PsiMethod) {
                        variants.add(PropertyUtil.getPropertyName((PsiMethod)((PsiMethod)psiMember)));
                    } else {
                        variants.add(psiMember.getName());
                    }
                    return true;
                }
            });
            Object[] objectArray = ArrayUtil.toObjectArray(variants);
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/references/WSDLReferenceProvider$WsdlPropertyReference", "getVariants"));
            }
            return objectArray;
        }

        public boolean isSoft() {
            return true;
        }
    }

    private static interface TagCollector {
        @NotNull
        public XmlTag[] findNeededTags(@NotNull XmlTag var1, String var2);

        @NotNull
        public XmlTag[] findImportedTags(@NotNull XmlTag var1);

        @NotNull
        @NonNls
        public String getImportedFileLocationAttrName();
    }

    static class WsdlEntityReference
    extends BaseRangedReference {
        private final String entityName;

        public WsdlEntityReference(PsiElement psiElement, int index, int endIndex, String _entityName) {
            super(psiElement, index, endIndex);
            this.entityName = _entityName;
        }

        @Nullable
        public PsiElement resolve() {
            final PsiElement[] result = new PsiElement[1];
            this.processTags(new PsiElementProcessor<XmlTag>(){
                final String canonicalText;
                {
                    this.canonicalText = WsdlEntityReference.this.getCanonicalText();
                }

                public boolean execute(@NotNull XmlTag element) {
                    if (element == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ws/references/WSDLReferenceProvider$WsdlEntityReference$1", "execute"));
                    }
                    if (this.canonicalText.equals(element.getAttributeValue(WSDLReferenceProvider.NAME_ATTR_NAME))) {
                        result[0] = element;
                        return false;
                    }
                    return true;
                }
            });
            return result[0];
        }

        @NotNull
        public Object[] getVariants() {
            final ArrayList result = new ArrayList(1);
            this.processTags(new PsiElementProcessor<XmlTag>(){

                public boolean execute(@NotNull XmlTag element) {
                    if (element == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ws/references/WSDLReferenceProvider$WsdlEntityReference$2", "execute"));
                    }
                    result.add(element.getAttributeValue(WSDLReferenceProvider.NAME_ATTR_NAME));
                    return true;
                }
            });
            Object[] objectArray = ArrayUtil.toObjectArray(result);
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/references/WSDLReferenceProvider$WsdlEntityReference", "getVariants"));
            }
            return objectArray;
        }

        protected void processTags(PsiElementProcessor<XmlTag> processor) {
            XmlTag[] subTags;
            XmlTag rootTag = WSDLReferenceProvider.getRootTag(this.getElement());
            if (rootTag == null) {
                return;
            }
            for (XmlTag t : subTags = WSDLReferenceProvider.getWsdlTags(rootTag, this.entityName)) {
                if (processor.execute((PsiElement)t)) continue;
                return;
            }
        }

        public boolean isSoft() {
            return false;
        }
    }

    public static class WsdlMethodReference
    extends BaseRangedReference {
        public WsdlMethodReference(PsiElement psiElement, int start, int end) {
            super(psiElement, start, end);
        }

        public WsdlMethodReference(PsiElement psiElement) {
            super(psiElement, 1, psiElement.getTextLength() - 1);
        }

        @Nullable
        public PsiElement resolve() {
            PsiElement psiElement = this.resolveClass();
            if (psiElement instanceof PsiClass) {
                return (PsiElement)ArrayUtil.getFirstElement((Object[])((PsiClass)psiElement).findMethodsByName(this.getCanonicalText(), false));
            }
            return null;
        }

        @Nullable
        protected PsiElement resolveClass() {
            XmlAttributeValue xmlAttributeValue;
            XmlTag grandParentTag = (XmlTag)this.getElement().getParent().getParent().getParent();
            String attrNameContainingClassReference = "binding".equals(grandParentTag.getLocalName()) ? WSDLReferenceProvider.TYPE_ATTR_NAME : WSDLReferenceProvider.NAME_ATTR_NAME;
            XmlAttribute attribute = grandParentTag.getAttribute(attrNameContainingClassReference, null);
            XmlAttributeValue xmlAttributeValue2 = xmlAttributeValue = attribute != null ? attribute.getValueElement() : null;
            if (xmlAttributeValue != null) {
                PsiReference[] references = xmlAttributeValue.getReferences();
                PsiReference psiReference = references.length > 0 ? references[references.length - 1] : null;
                return psiReference != null ? psiReference.resolve() : null;
            }
            return null;
        }

        @NotNull
        public Object[] getVariants() {
            PsiElement psiElement = this.resolveClass();
            if (psiElement instanceof PsiClass) {
                PsiClass clazz = (PsiClass)psiElement;
                ArrayList<String> acceptableMethods = new ArrayList<String>(4);
                for (PsiMethod m : clazz.getMethods()) {
                    if (!DeployUtils.isAcceptableMethod(m)) continue;
                    acceptableMethods.add(m.getName());
                }
                Object[] objectArray = ArrayUtil.toObjectArray(acceptableMethods);
                if (objectArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/references/WSDLReferenceProvider$WsdlMethodReference", "getVariants"));
                }
                return objectArray;
            }
            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/references/WSDLReferenceProvider$WsdlMethodReference", "getVariants"));
            }
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }

        public boolean isSoft() {
            return true;
        }
    }
}

