/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.xml.xmlbeans;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.javaee.UriUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.ws.WebServicesPluginSettings;
import com.intellij.ws.WsJavaExternalProcessHandler;
import com.intellij.ws.engines.ExternalEngine;
import com.intellij.ws.engines.LibraryDescriptor;
import com.intellij.ws.engines.LibraryInfo;
import com.intellij.ws.utils.CommonWsUtils;
import com.intellij.ws.utils.ExternalProcessHandler;
import com.intellij.ws.utils.InvokeExternalCodeUtil;
import com.intellij.ws.utils.LibUtils;
import java.io.File;
import java.util.LinkedList;
import org.jetbrains.annotations.Nullable;

public class XmlBeansMappingEngine
implements ExternalEngine {
    private static final String XML_BEANS_LIBRARY_NAME = "XmlBeans";
    private static final String XML_BEANS_RT_LIBRARY_NAME = "XmlBeans Runtime";
    public static final String XML_BEANS_2_ENGINE = "XmlBeans 2";
    static final Logger LOG = Logger.getInstance((String)"webservicesplugin.xmlbeans.java");

    @Override
    public String getName() {
        return XML_BEANS_2_ENGINE;
    }

    @Override
    public LibraryDescriptor[] getLibraryDescriptors(String bindingType, boolean isForGeneratedCode) {
        String commonXmlBeansPrefix = LibUtils.accessingLibraryJarsFromPluginBundledLibs(this.getBasePath()) ? "" : "lib" + File.separator;
        Object[] commonJars = new String[]{commonXmlBeansPrefix + "xbean.jar", commonXmlBeansPrefix + "jsr173_1.0_api.jar", commonXmlBeansPrefix + "resolver.jar"};
        if (isForGeneratedCode) {
            return new LibraryDescriptor[]{new LibraryInfo(XML_BEANS_RT_LIBRARY_NAME, (String[])ArrayUtil.append((Object[])commonJars, (Object)(commonXmlBeansPrefix + "xmlpublic.jar")))};
        }
        return new LibraryDescriptor[]{new LibraryInfo(XML_BEANS_LIBRARY_NAME, (String[])commonJars)};
    }

    @Override
    public String getBasePath() {
        return WebServicesPluginSettings.getInstance().getXmlBeansPath();
    }

    public static void doXmlBeanGen(String url, String completeFileName, String[] classPath, final Module module, final boolean addToLibs, final @Nullable Runnable onSuccess, @Nullable Runnable toRestart) {
        String outputPath;
        LinkedList<String> parameters = new LinkedList<String>();
        int beginIndex = completeFileName.lastIndexOf(File.separatorChar);
        if (beginIndex == -1) {
            beginIndex = completeFileName.lastIndexOf(47);
        }
        final String outputFileName = completeFileName.substring(beginIndex + 1);
        if (beginIndex != -1) {
            outputPath = completeFileName.substring(0, beginIndex);
            if (outputPath.startsWith("file:")) {
                outputPath = outputPath.substring("file:".length());
            }
        } else {
            outputPath = url.substring(0, url.lastIndexOf(47));
        }
        final Project project = module.getProject();
        completeFileName = outputPath + File.separator + outputFileName;
        VirtualFile outputFile = UriUtil.findRelativeFile((String)completeFileName, null);
        if (outputFile != null) {
            FileModificationService.getInstance().prepareFileForWrite(PsiManager.getInstance((Project)project).findFile(outputFile));
        }
        parameters.add("-out");
        parameters.add(completeFileName);
        parameters.add("-quiet");
        parameters.add(url);
        WebServicesPluginSettings.getInstance().addLastXmlBeansUrl(url);
        parameters.add("-dl");
        WsJavaExternalProcessHandler externalProcessHandler = new WsJavaExternalProcessHandler("Schema Compiler", "org.apache.xmlbeans.impl.tool.SchemaCompiler", classPath, ArrayUtil.toStringArray(parameters), module, true);
        Consumer<Exception> actionAtFailure = new Consumer<Exception>(){

            public void consume(Exception e) {
                Messages.showErrorDialog((Project)project, (String)e.getMessage(), (String)"Xml Beans compiler error");
                LOG.debug((Throwable)e);
            }
        };
        if (toRestart != null) {
            final String outputPath1 = outputPath;
            InvokeExternalCodeUtil.invokeExternalProcess2((ExternalProcessHandler)externalProcessHandler, (Project)project, (Runnable)new Runnable(){

                @Override
                public void run() {
                    XmlBeansMappingEngine.addToLibs(module, addToLibs, outputPath1, outputFileName);
                    if (onSuccess != null) {
                        onSuccess.run();
                    }
                }
            }, (Consumer)actionAtFailure, (Computable)new Computable<Boolean>(){

                public Boolean compute() {
                    return true;
                }
            }, (Runnable)toRestart);
        } else {
            try {
                InvokeExternalCodeUtil.invokeExternalProcess((ExternalProcessHandler)externalProcessHandler, (Project)project);
            }
            catch (Exception e) {
                actionAtFailure.consume((Object)e);
                return;
            }
            XmlBeansMappingEngine.addToLibs(module, addToLibs, outputPath, outputFileName);
        }
    }

    private static void addToLibs(Module module, boolean addToLibs, String outputPath, String outputFileName) {
        if (addToLibs) {
            LibraryDescriptor[] generatedLibInfos = new LibraryDescriptor[]{new LibraryInfo(null, outputFileName)};
            LibUtils.setupLibraries(module, generatedLibInfos, outputPath.length() > 0 ? outputPath + File.separatorChar : "", true);
            CommonWsUtils.setupLibsForDeployment((Module)module, (LibraryDescriptor[])generatedLibInfos);
        }
    }
}

