/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.breakpoints;

import com.intellij.icons.AllIcons;
import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.javascript.debugger.breakpoints.JavaScriptBreakpointType;
import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpointAdapter;
import com.intellij.xdebugger.breakpoints.XBreakpointListener;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xml.util.HtmlUtil;
import com.jetbrains.javascript.debugger.JsFileUtil;
import org.jetbrains.annotations.NotNull;

final class JavaScriptBreakpointListener
implements StartupActivity,
DumbAware {
    JavaScriptBreakpointListener() {
    }

    public void runActivity(final @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/debugger/breakpoints/JavaScriptBreakpointListener", "runActivity"));
        }
        JavaScriptBreakpointType breakpointType = (JavaScriptBreakpointType)((Object)XBreakpointType.EXTENSION_POINT_NAME.findExtension(JavaScriptBreakpointType.class));
        if (breakpointType == null) {
            return;
        }
        XDebuggerManager.getInstance((Project)project).getBreakpointManager().addBreakpointListener((XBreakpointType)breakpointType, (XBreakpointListener)new XBreakpointAdapter<XLineBreakpoint<XBreakpointProperties>>(){

            public void breakpointAdded(@NotNull XLineBreakpoint breakpoint) {
                if (breakpoint == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "com/intellij/javascript/debugger/breakpoints/JavaScriptBreakpointListener$1", "breakpointAdded"));
                }
                JavaScriptBreakpointListener.checkBreakpoint(breakpoint, project);
            }

            public void breakpointChanged(@NotNull XLineBreakpoint breakpoint) {
                if (breakpoint == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "com/intellij/javascript/debugger/breakpoints/JavaScriptBreakpointListener$1", "breakpointChanged"));
                }
                JavaScriptBreakpointListener.checkBreakpoint(breakpoint, project);
            }
        }, (Disposable)project);
    }

    private static void checkBreakpoint(@NotNull XLineBreakpoint breakpoint, @NotNull Project project) {
        String errorMessage;
        if (breakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "com/intellij/javascript/debugger/breakpoints/JavaScriptBreakpointListener", "checkBreakpoint"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/debugger/breakpoints/JavaScriptBreakpointListener", "checkBreakpoint"));
        }
        XSourcePosition sourcePosition2 = breakpoint.getSourcePosition();
        if (sourcePosition2 == null) {
            return;
        }
        VirtualFile file = sourcePosition2.getFile();
        XBreakpointManager breakpointManager = XDebuggerManager.getInstance((Project)project).getBreakpointManager();
        FileType fileType = file.getFileType();
        if ((fileType == JavaScriptFileType.INSTANCE || HtmlUtil.isHtmlFile((VirtualFile)file)) && JsFileUtil.containsDebuggableElement(breakpoint.getLine(), project, FileDocumentManager.getInstance().getDocument(file), true, true)) {
            errorMessage = JSDebuggerBundle.message("error.message.breakpoints.in.event.handlers.are.not.supported", new Object[0]);
        } else if (JsFileUtil.isTemplateFileType(fileType)) {
            errorMessage = JSDebuggerBundle.message("error.message.breakpoint.in.0.files.are.not.supported", fileType.getName(), ApplicationNamesInfo.getInstance().getFullProductName());
        } else {
            breakpointManager.updateBreakpointPresentation(breakpoint, null, null);
            return;
        }
        breakpointManager.updateBreakpointPresentation(breakpoint, AllIcons.Debugger.Db_invalid_breakpoint, errorMessage);
    }
}

