/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.breakpoints;

import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.javascript.debugger.execution.RemoteDebuggingFileFinder;
import com.intellij.javascript.debugger.impl.DebuggableFileFinder;
import com.intellij.javascript.debugger.impl.EvalScriptVirtualFile;
import com.intellij.javascript.debugger.impl.JSDebuggerEditorsProvider;
import com.intellij.javascript.debugger.impl.RemoteUrlMappingHelper;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointTypeBase;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointGroupingRule;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.jetbrains.javascript.debugger.JavaScriptDebugAware;
import com.jetbrains.javascript.debugger.JavaScriptDebugProcess;
import com.jetbrains.javascript.debugger.JsFileUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaScriptBreakpointType
extends XLineBreakpointTypeBase {
    public JavaScriptBreakpointType() {
        super("javascript", JSDebuggerBundle.message("javascript.breakpoint.title", new Object[0]), (XDebuggerEditorsProvider)new JSDebuggerEditorsProvider());
    }

    public boolean canPutAt(@NotNull VirtualFile file, int line, @NotNull Project project) {
        Document document;
        boolean canContainsJavaScript;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javascript/debugger/breakpoints/JavaScriptBreakpointType", "canPutAt"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/debugger/breakpoints/JavaScriptBreakpointType", "canPutAt"));
        }
        if (file instanceof EvalScriptVirtualFile) {
            return false;
        }
        FileType fileType = file.getFileType();
        boolean bl = canContainsJavaScript = DialectDetector.JAVASCRIPT_FILE_TYPES.contains(fileType) || JsFileUtil.isHtmlOrTemplateFile(file);
        if ((canContainsJavaScript || JavaScriptDebugAware.isBreakpointAware((FileType)fileType)) && (document = FileDocumentManager.getInstance().getDocument(file)) != null) {
            return JsFileUtil.containsDebuggableElement(line, project, document, false, canContainsJavaScript);
        }
        return false;
    }

    public List<? extends AnAction> getAdditionalPopupMenuActions(@NotNull XLineBreakpoint<XBreakpointProperties> breakpoint, @Nullable XDebugSession currentSession) {
        XDebugProcess debugProcess;
        if (breakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "com/intellij/javascript/debugger/breakpoints/JavaScriptBreakpointType", "getAdditionalPopupMenuActions"));
        }
        XSourcePosition position = breakpoint.getSourcePosition();
        if (currentSession != null && position != null && (debugProcess = currentSession.getDebugProcess()) instanceof JavaScriptDebugProcess) {
            JavaScriptDebugProcess jsDebugProcess = (JavaScriptDebugProcess)debugProcess;
            DebuggableFileFinder fileFinder = jsDebugProcess.getFinder();
            VirtualFile file = position.getFile();
            if (fileFinder instanceof RemoteDebuggingFileFinder && !((RemoteDebuggingFileFinder)fileFinder).isDebuggable(file, currentSession.getProject()) && fileFinder.canSetRemoteUrl(file, currentSession.getProject())) {
                return Collections.singletonList(new SpecifyRemoteUrlAction(jsDebugProcess, file));
            }
        }
        return super.getAdditionalPopupMenuActions(breakpoint, currentSession);
    }

    public List<XBreakpointGroupingRule<XLineBreakpoint<XBreakpointProperties>, ?>> getGroupingRules() {
        return XDebuggerUtil.getInstance().getGroupingByFileRuleAsList();
    }

    public String getBreakpointsDialogHelpTopic() {
        return "reference.dialogs.breakpoints";
    }

    private static class SpecifyRemoteUrlAction
    extends AnAction {
        private final JavaScriptDebugProcess<?> myDebugProcess;
        private final VirtualFile myFile;

        private SpecifyRemoteUrlAction(@NotNull JavaScriptDebugProcess debugProcess, @NotNull VirtualFile file) {
            if (debugProcess == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugProcess", "com/intellij/javascript/debugger/breakpoints/JavaScriptBreakpointType$SpecifyRemoteUrlAction", "<init>"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javascript/debugger/breakpoints/JavaScriptBreakpointType$SpecifyRemoteUrlAction", "<init>"));
            }
            super(JSDebuggerBundle.message("action.name.specify.remote.url.for.0", file.getName()));
            this.myDebugProcess = debugProcess;
            this.myFile = file;
        }

        public void actionPerformed(AnActionEvent e) {
            RemoteUrlMappingHelper.showSetRemoteUrlDialog(this.myDebugProcess, this.myFile);
        }
    }
}

