/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.execution;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunProfileStarter;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.util.Function;
import com.jetbrains.javascript.debugger.JavaScriptDebugEngine;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

public final class JsRunners {
    public static Promise<RunProfileStarter> start(@NotNull Project project, @Nullable Pair<JavaScriptDebugEngine, WebBrowser> engineAndBrowser, final @Nullable Starter starter) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/debugger/execution/JsRunners", "start"));
        }
        if (starter == null || engineAndBrowser == null) {
            return Promise.reject((String)"No starter or engineAndBrowser");
        }
        return ((JavaScriptDebugEngine)engineAndBrowser.first).prepareDebugger(project, (WebBrowser)engineAndBrowser.second).then((Function)new Function<Void, RunProfileStarter>(){

            public RunProfileStarter fun(Void aVoid) {
                return new RunProfileStarter(){

                    public RunContentDescriptor execute(@NotNull RunProfileState state, @NotNull ExecutionEnvironment environment) throws ExecutionException {
                        if (state == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/javascript/debugger/execution/JsRunners$1$1", "execute"));
                        }
                        if (environment == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/intellij/javascript/debugger/execution/JsRunners$1$1", "execute"));
                        }
                        FileDocumentManager.getInstance().saveAllDocuments();
                        return starter.start();
                    }
                };
            }
        });
    }

    public static abstract class Starter {
        @Nullable
        public abstract RunContentDescriptor start() throws ExecutionException;
    }
}

