/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.settings;

import com.google.common.base.Splitter;
import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.javascript.debugger.settings.CustomObjectPresentationState;
import com.intellij.javascript.debugger.settings.JavaScriptDataViewsConfigurableUi;
import com.intellij.javascript.debugger.settings.JavaScriptSteppingConfigurableUi;
import com.intellij.javascript.debugger.settings.SteppingFilter;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SimpleConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Getter;
import com.intellij.util.PlatformUtils;
import com.intellij.util.SmartList;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.settings.DebuggerSettingsCategory;
import com.intellij.xdebugger.settings.XDebuggerSettings;
import com.jetbrains.javascript.debugger.JavaScriptDebugProcess;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.builtInWebServer.BuiltInServerOptions;
import org.jetbrains.jps.model.fileTypes.FileNameMatcherFactory;

public class JavaScriptDebuggerSettings
extends XDebuggerSettings<JavaScriptDebuggerSettings>
implements Getter<JavaScriptDebuggerSettings> {
    private static final Splitter STEPPING_FILTER_SPLITTER = Splitter.on((char)';').omitEmptyStrings();
    @Attribute
    public int builtInServerPort = 63342;
    @Attribute
    public boolean builtInServerAvailableExternally = false;
    private boolean steppingFiltersEnabled = true;
    private List<SteppingFilter> steppingFilters = new SmartList();
    private boolean doNotStepIntoLibraryCode = true;
    private CustomObjectPresentationState myObjectPresentation = new CustomObjectPresentationState();
    private List<FileNameMatcher> computedSteppingFilters;

    @Attribute(value="doNotStepIntoLibraryCode")
    public boolean isDoNotStepIntoLibraryCode() {
        return this.doNotStepIntoLibraryCode;
    }

    public void setDoNotStepIntoLibraryCode(boolean value) {
        this.doNotStepIntoLibraryCode = value;
    }

    @Tag(value="stepping-filters-enabled")
    public boolean isSteppingFiltersEnabled() {
        return this.steppingFiltersEnabled;
    }

    public void setSteppingFiltersEnabled(boolean value) {
        this.steppingFiltersEnabled = value;
    }

    @AbstractCollection(surroundWithTag=false)
    @Tag(value="stepping-filters")
    @NotNull
    public List<SteppingFilter> getSteppingFilters() {
        List<SteppingFilter> list = this.steppingFilters;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/debugger/settings/JavaScriptDebuggerSettings", "getSteppingFilters"));
        }
        return list;
    }

    public void setSteppingFilters(@NotNull List<SteppingFilter> value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/javascript/debugger/settings/JavaScriptDebuggerSettings", "setSteppingFilters"));
        }
        this.steppingFilters = value;
    }

    @Property(surroundWithTag=false)
    public CustomObjectPresentationState getObjectPresentation() {
        return this.myObjectPresentation;
    }

    public void setObjectPresentation(CustomObjectPresentationState objectPresentation) {
        this.myObjectPresentation = objectPresentation;
    }

    public JavaScriptDebuggerSettings() {
        super("javascript");
    }

    public static JavaScriptDebuggerSettings getInstance() {
        return (JavaScriptDebuggerSettings)JavaScriptDebuggerSettings.getInstance(JavaScriptDebuggerSettings.class);
    }

    @NotNull
    public Collection<? extends Configurable> createConfigurables(@NotNull DebuggerSettingsCategory category) {
        if (category == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "category", "com/intellij/javascript/debugger/settings/JavaScriptDebuggerSettings", "createConfigurables"));
        }
        switch (category) {
            case DATA_VIEWS: {
                List<SimpleConfigurable> list = Collections.singletonList(SimpleConfigurable.create((String)"debugger.dataViews.javascript", (String)JSDebuggerBundle.message("javascript.debugger.settings.display.name", new Object[0]), JavaScriptDataViewsConfigurableUi.class, (Getter)this));
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/debugger/settings/JavaScriptDebuggerSettings", "createConfigurables"));
                }
                return list;
            }
            case STEPPING: {
                List<SimpleConfigurable> list = Collections.singletonList(SimpleConfigurable.create((String)"debugger.stepping.javascript", (String)JSDebuggerBundle.message("javascript.debugger.settings.display.name", new Object[0]), JavaScriptSteppingConfigurableUi.class, (Getter)this));
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/debugger/settings/JavaScriptDebuggerSettings", "createConfigurables"));
                }
                return list;
            }
        }
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/debugger/settings/JavaScriptDebuggerSettings", "createConfigurables"));
        }
        return list;
    }

    public boolean isTargetedToProduct(@NotNull Configurable configurable) {
        if (configurable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurable", "com/intellij/javascript/debugger/settings/JavaScriptDebuggerSettings", "isTargetedToProduct"));
        }
        return PlatformUtils.isWebStorm() && JSDebuggerBundle.message("javascript.debugger.settings.display.name", new Object[0]).equals(configurable.getDisplayName());
    }

    @NotNull
    public JavaScriptDebuggerSettings getState() {
        JavaScriptDebuggerSettings javaScriptDebuggerSettings = this;
        if (javaScriptDebuggerSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/debugger/settings/JavaScriptDebuggerSettings", "getState"));
        }
        return javaScriptDebuggerSettings;
    }

    public void loadState(JavaScriptDebuggerSettings state) {
        XmlSerializerUtil.copyBean((Object)((Object)state), (Object)((Object)this));
        if (this.builtInServerAvailableExternally) {
            BuiltInServerOptions.getInstance().builtInServerAvailableExternally = true;
            this.builtInServerAvailableExternally = false;
        }
        if (this.builtInServerPort != 63342) {
            BuiltInServerOptions.getInstance().builtInServerPort = this.builtInServerPort;
            this.builtInServerPort = 63342;
        }
    }

    public Collection<String> getEnabledSteppingFilters() {
        if (!this.isSteppingFiltersEnabled()) {
            return Collections.emptyList();
        }
        SmartList patterns = new SmartList();
        for (SteppingFilter filterState : this.getSteppingFilters()) {
            if (!filterState.isEnabled()) continue;
            patterns.add(filterState.getUrlPattern());
        }
        return patterns;
    }

    @NotNull
    public List<FileNameMatcher> getComputedSteppingFilters() {
        if (this.computedSteppingFilters == null) {
            if (!this.isSteppingFiltersEnabled()) {
                List<FileNameMatcher> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/debugger/settings/JavaScriptDebuggerSettings", "getComputedSteppingFilters"));
                }
                return list;
            }
            SmartList result = new SmartList();
            FileNameMatcherFactory fileNameMatcherFactory = FileNameMatcherFactory.getInstance();
            for (SteppingFilter filterState : this.getSteppingFilters()) {
                if (!filterState.isEnabled() || filterState.getUrlPattern() == null) continue;
                for (String wildcard : STEPPING_FILTER_SPLITTER.split((CharSequence)filterState.getUrlPattern())) {
                    result.add(fileNameMatcherFactory.createMatcher(wildcard));
                }
            }
            this.computedSteppingFilters = Collections.unmodifiableList(result);
        }
        List<FileNameMatcher> list = this.computedSteppingFilters;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/debugger/settings/JavaScriptDebuggerSettings", "getComputedSteppingFilters"));
        }
        return list;
    }

    public JavaScriptDebuggerSettings get() {
        return this;
    }

    public static void onSettingsChanged(boolean viewSettingsChanged, boolean filtersChanged) {
        if (filtersChanged) {
            JavaScriptDebuggerSettings.getInstance().computedSteppingFilters = null;
        }
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            for (JavaScriptDebugProcess process2 : XDebuggerManager.getInstance((Project)project).getDebugProcesses(JavaScriptDebugProcess.class)) {
                if (process2.getSession().isStopped()) continue;
                if (viewSettingsChanged) {
                    process2.onViewSettingsChanged();
                    process2.getSession().rebuildViews();
                }
                if (!filtersChanged) continue;
                process2.onSteppingFiltersChanged();
            }
        }
    }
}

