/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.browserConnection;

import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonWriter;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.util.PlatformUtils;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.ide.HttpRequestHandler;
import org.jetbrains.io.Responses;

class IdeInfoServerHandler
extends HttpRequestHandler {
    private static final String PREFIX = "/browserConnection/buildInfo";

    IdeInfoServerHandler() {
    }

    public boolean isSupported(@NotNull FullHttpRequest request) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/jetbrains/browserConnection/IdeInfoServerHandler", "isSupported"));
        }
        return super.isSupported(request) && request.uri().startsWith(PREFIX);
    }

    public boolean process(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context) throws IOException {
        String productName;
        if (urlDecoder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urlDecoder", "com/jetbrains/browserConnection/IdeInfoServerHandler", "process"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/jetbrains/browserConnection/IdeInfoServerHandler", "process"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/browserConnection/IdeInfoServerHandler", "process"));
        }
        if (!urlDecoder.path().equals(PREFIX)) {
            return false;
        }
        BuildNumber build = ApplicationInfo.getInstance().getBuild();
        StringBuilder sb = new StringBuilder();
        JsonWriter writer = new JsonWriter(Streams.writerForAppendable((Appendable)sb));
        writer.beginObject();
        String appName = ApplicationInfoEx.getInstanceEx().getFullApplicationName();
        if (!PlatformUtils.isIdeaUltimate() && (appName = appName.replace((productName = ApplicationNamesInfo.getInstance().getProductName()) + " (" + productName + ")", productName)).startsWith("JetBrains ")) {
            appName = appName.substring("JetBrains ".length());
        }
        writer.name("name").value(appName);
        writer.name("productName").value(ApplicationNamesInfo.getInstance().getProductName());
        writer.name("baselineVersion").value((long)build.getBaselineVersion());
        if (build.getBuildNumber() != Integer.MAX_VALUE) {
            writer.name("buildNumber").value((long)build.getBuildNumber());
        }
        writer.endObject();
        writer.close();
        Responses.send((CharSequence)sb, (Channel)context.channel(), (HttpRequest)request);
        return true;
    }
}

