/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.javascript.debugger;

import com.intellij.javascript.debugger.impl.DebuggableFileFinder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.WebModuleTypeBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001b\u0010\t\u001a\r\u0012\t\u0012\u00070\u0006\u00a2\u0006\u0002\b\u000b0\n2\u0006\u0010\f\u001a\u00020\u0004H\u0016\u00a8\u0006\r"}, d2={"Lcom/jetbrains/javascript/debugger/BaseNodeJsFileFinder;", "Lcom/intellij/javascript/debugger/impl/DebuggableFileFinder;", "()V", "findFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "url", "Lcom/intellij/util/Url;", "project", "Lcom/intellij/openapi/project/Project;", "getRemoteUrls", "", "Lorg/jetbrains/annotations/NotNull;", "file", "JavaScriptDebugger"})
public class BaseNodeJsFileFinder
extends DebuggableFileFinder {
    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public VirtualFile findFile(@NotNull Url url, @NotNull Project project) {
        String projectBasePath;
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        String path = FileUtilRt.toSystemIndependentName((String)url.getPath());
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(path);
        if (file == null && (projectBasePath = project.getBasePath()) != null && FileUtil.isAncestor((String)projectBasePath, (String)path, (boolean)true)) {
            file = LocalFileSystem.getInstance().refreshAndFindFileByPath(path);
        }
        if (file != null) {
            return file;
        }
        int i = StringsKt.indexOf$default((CharSequence)path, (char)'/', (int)0, (boolean)false, (int)6, null);
        SmartList contentRoots = new SmartList();
        SmartList webContentRoots = new SmartList();
        Module[] moduleArray = ModuleManager.getInstance((Project)project).getModules();
        for (int j = 0; j < moduleArray.length; ++j) {
            Module module = moduleArray[j];
            Collection collection = (Collection)(WebModuleTypeBase.isWebModule((Module)module) ? webContentRoots : contentRoots);
            Object[] objectArray = ModuleRootManager.getInstance((Module)module).getContentRoots();
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"ModuleRootManager.getInstance(module).contentRoots");
            CollectionsKt.addAll((Collection)collection, (Object[])objectArray);
        }
        while (i != -1) {
            VirtualFile virtualFile;
            VirtualFile virtualFile2;
            VirtualFile result$iv;
            String subPath;
            VirtualFile it;
            List $receiver$iv;
            block9: {
                void endIndex$iv;
                void startIndex$iv;
                String string = path;
                int n = i + 1;
                int n2 = path.length();
                void v2 = $receiver$iv;
                if (v2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)((String)v2).substring((int)startIndex$iv, (int)endIndex$iv), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                $receiver$iv = (List)webContentRoots;
                for (Object file$iv : $receiver$iv) {
                    it = (VirtualFile)file$iv;
                    result$iv = it.findFileByRelativePath(subPath);
                    if (result$iv == null) continue;
                    virtualFile2 = result$iv;
                    break block9;
                }
                virtualFile2 = null;
            }
            if ((virtualFile = (VirtualFile)virtualFile2) == null) {
                VirtualFile virtualFile3;
                block10: {
                    $receiver$iv = (List)contentRoots;
                    for (Object file$iv : $receiver$iv) {
                        it = (VirtualFile)file$iv;
                        result$iv = it.findFileByRelativePath(subPath);
                        if (result$iv == null) continue;
                        virtualFile3 = result$iv;
                        break block10;
                    }
                    virtualFile3 = null;
                }
                virtualFile = file = (VirtualFile)virtualFile3;
            }
            if (file != null) {
                return file;
            }
            i = StringsKt.indexOf$default((CharSequence)path, (char)'/', (int)(i + 2), (boolean)false, (int)4, null);
        }
        return null;
    }

    @Override
    @NotNull
    public List<Url> getRemoteUrls(@NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return CollectionsKt.listOf((Object)Urls.newLocalFileUrl((String)file.getPath()));
    }
}

