/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.javascript.debugger;

import com.intellij.javascript.debugger.impl.DebuggableFileFinder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.util.SmartList;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.jetbrains.javascript.debugger.FileUrlMapper;
import com.jetbrains.javascript.debugger.JsFileUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.WebServerPathToFileManager;
import org.jetbrains.io.LocalFileFinder;

public class DebuggableFileFinderImpl
extends DebuggableFileFinder {
    private final Project project;
    private final Url requestor;
    private final String scheme;
    final String authority;
    private final FileUrlMapper[] fileUrlMappers;

    public DebuggableFileFinderImpl(@NotNull Project project, @Nullable Url requestor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/javascript/debugger/DebuggableFileFinderImpl", "<init>"));
        }
        this.project = project;
        this.requestor = requestor;
        if (requestor != null && requestor.isInLocalFileSystem()) {
            this.authority = null;
            this.scheme = null;
            this.fileUrlMappers = null;
        } else {
            if (requestor == null) {
                this.authority = null;
                this.scheme = null;
            } else {
                this.authority = requestor.getAuthority();
                this.scheme = requestor.getScheme();
            }
            FileUrlMapper[] extensions = (FileUrlMapper[])FileUrlMapper.EP_NAME.getExtensions();
            this.fileUrlMappers = extensions.length == 0 ? null : extensions;
        }
    }

    public boolean isDebuggable(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/javascript/debugger/DebuggableFileFinderImpl", "isDebuggable"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/javascript/debugger/DebuggableFileFinderImpl", "isDebuggable"));
        }
        return this.authority == null || WebServerPathToFileManager.getInstance((Project)project).getPath(file) != null || !this.findRemoteUrlByExtensionMappers(file).isEmpty();
    }

    @NotNull
    private List<Url> findRemoteUrlByExtensionMappers(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/javascript/debugger/DebuggableFileFinderImpl", "findRemoteUrlByExtensionMappers"));
        }
        List result = null;
        if (this.fileUrlMappers != null) {
            for (FileUrlMapper mapper : this.fileUrlMappers) {
                List urls = mapper.getUrls(file, this.project, this.authority);
                if (urls.isEmpty()) continue;
                if (result == null) {
                    result = new SmartList();
                }
                result.addAll(urls);
            }
        }
        List<Object> list = result == null ? Collections.emptyList() : result;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/javascript/debugger/DebuggableFileFinderImpl", "findRemoteUrlByExtensionMappers"));
        }
        return list;
    }

    @Override
    @Nullable
    public Navigatable findNavigatable(@NotNull Url url, @NotNull Project project) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/jetbrains/javascript/debugger/DebuggableFileFinderImpl", "findNavigatable"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/javascript/debugger/DebuggableFileFinderImpl", "findNavigatable"));
        }
        if (url.isInLocalFileSystem()) {
            return JsFileUtil.createNavigatable(project, LocalFileFinder.findFile((String)url.getPath()));
        }
        if (this.fileUrlMappers != null) {
            for (FileUrlMapper mapper : this.fileUrlMappers) {
                Navigatable navigatable = mapper.getNavigatable(url, project, this.requestor);
                if (navigatable == null) continue;
                return navigatable;
            }
        }
        return JsFileUtil.createNavigatable(project, this.findFileByAuthority(url, project));
    }

    @Override
    @Nullable
    public VirtualFile findFile(@NotNull Url url, @NotNull Project project) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/jetbrains/javascript/debugger/DebuggableFileFinderImpl", "findFile"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/javascript/debugger/DebuggableFileFinderImpl", "findFile"));
        }
        if (url.isInLocalFileSystem()) {
            String path = url.getPath();
            if (LocalFileFinder.windowsDriveExists((String)path)) {
                LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
                VirtualFile file = localFileSystem.findFileByPath(path);
                return file == null ? localFileSystem.refreshAndFindFileByPath(path) : file;
            }
            return null;
        }
        if (this.fileUrlMappers != null) {
            for (FileUrlMapper mapper : this.fileUrlMappers) {
                VirtualFile file = mapper.getFile(url, project, this.requestor);
                if (file == null) continue;
                return file;
            }
        }
        return this.findFileByAuthority(url, project);
    }

    @Nullable
    private VirtualFile findFileByAuthority(@NotNull Url url, @NotNull Project project) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/jetbrains/javascript/debugger/DebuggableFileFinderImpl", "findFileByAuthority"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/javascript/debugger/DebuggableFileFinderImpl", "findFileByAuthority"));
        }
        if (this.authority != null && this.authority.equalsIgnoreCase(url.getAuthority())) {
            return WebServerPathToFileManager.getInstance((Project)project).findVirtualFile(url.getPath());
        }
        return null;
    }

    @Override
    @NotNull
    public List<Url> getRemoteUrls(@NotNull VirtualFile file) {
        String path;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/javascript/debugger/DebuggableFileFinderImpl", "getRemoteUrls"));
        }
        List<Url> urls = this.findRemoteUrlByExtensionMappers(file);
        if (!urls.isEmpty()) {
            List<Url> list = urls;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/javascript/debugger/DebuggableFileFinderImpl", "getRemoteUrls"));
            }
            return list;
        }
        if (this.authority != null && (path = WebServerPathToFileManager.getInstance((Project)this.project).getPath(file)) != null) {
            List<Url> list = Collections.singletonList(Urls.newUrl((String)this.scheme, (String)this.authority, (String)('/' + path)));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/javascript/debugger/DebuggableFileFinderImpl", "getRemoteUrls"));
            }
            return list;
        }
        List<Url> list = Collections.singletonList(Urls.newFromVirtualFile((VirtualFile)file));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/javascript/debugger/DebuggableFileFinderImpl", "getRemoteUrls"));
        }
        return list;
    }

    public String toString() {
        return "DefaultFileFinder";
    }
}

