/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.javascript.debugger;

import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.ide.browsers.BrowserFamily;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.browsers.WebBrowserManager;
import com.intellij.javascript.debugger.impl.DebuggableFileFinder;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiFile;
import com.intellij.util.Function;
import com.intellij.util.Url;
import com.intellij.xdebugger.XDebugSession;
import com.jetbrains.browserConnection.BrowserConnectionManager;
import com.jetbrains.javascript.debugger.JavaScriptDebugProcess;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.connection.VmConnection;

public abstract class JavaScriptDebugEngine {
    private static final ExtensionPointName<JavaScriptDebugEngine> EXTENSION_POINT = ExtensionPointName.create((String)"JavaScriptDebugger.engine");

    @NotNull
    public static JavaScriptDebugEngine[] getEngines() {
        JavaScriptDebugEngine[] javaScriptDebugEngineArray = (JavaScriptDebugEngine[])Extensions.getExtensions(EXTENSION_POINT);
        if (javaScriptDebugEngineArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/javascript/debugger/JavaScriptDebugEngine", "getEngines"));
        }
        return javaScriptDebugEngineArray;
    }

    @Nullable
    public static JavaScriptDebugEngine findByBrowserIdOrNameOrEngineId(@NotNull String browserIdOrNameOrEngineId) {
        if (browserIdOrNameOrEngineId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "browserIdOrNameOrEngineId", "com/jetbrains/javascript/debugger/JavaScriptDebugEngine", "findByBrowserIdOrNameOrEngineId"));
        }
        for (JavaScriptDebugEngine engine : JavaScriptDebugEngine.getEngines()) {
            if (!JavaScriptDebugEngine.checkByBrowserIdOrName(engine, browserIdOrNameOrEngineId)) continue;
            return engine;
        }
        return null;
    }

    private static boolean checkByBrowserIdOrName(@NotNull JavaScriptDebugEngine engine, @NotNull String browserIdOrName) {
        if (engine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "engine", "com/jetbrains/javascript/debugger/JavaScriptDebugEngine", "checkByBrowserIdOrName"));
        }
        if (browserIdOrName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "browserIdOrName", "com/jetbrains/javascript/debugger/JavaScriptDebugEngine", "checkByBrowserIdOrName"));
        }
        WebBrowser browser = engine.getBrowser();
        return browser != null && (browser.getName().equalsIgnoreCase(browserIdOrName) || browser.getId().toString().equalsIgnoreCase(browserIdOrName));
    }

    @Nullable
    public static Pair<JavaScriptDebugEngine, WebBrowser> findByBrowserIdOrName(@NotNull String browserIdOrName) {
        if (browserIdOrName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "browserIdOrName", "com/jetbrains/javascript/debugger/JavaScriptDebugEngine", "findByBrowserIdOrName"));
        }
        WebBrowser browser = WebBrowserManager.getInstance().findBrowserById(browserIdOrName);
        if (browser == null) {
            for (JavaScriptDebugEngine engine : JavaScriptDebugEngine.getEngines()) {
                WebBrowser engineBrowser;
                if (!JavaScriptDebugEngine.checkByBrowserIdOrName(engine, browserIdOrName) || (engineBrowser = engine.getBrowser()) == null) continue;
                return Pair.create((Object)engine, (Object)engineBrowser);
            }
            return null;
        }
        JavaScriptDebugEngine engine = JavaScriptDebugEngine.findByBrowser(browser);
        return engine == null ? null : Pair.create((Object)engine, (Object)browser);
    }

    @Nullable
    public static JavaScriptDebugEngine findByBrowser(@NotNull WebBrowser browser) {
        if (browser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "browser", "com/jetbrains/javascript/debugger/JavaScriptDebugEngine", "findByBrowser"));
        }
        for (JavaScriptDebugEngine engine : JavaScriptDebugEngine.getEngines()) {
            if (!browser.equals(engine.getBrowser())) continue;
            return engine;
        }
        for (JavaScriptDebugEngine engine : JavaScriptDebugEngine.getEngines()) {
            if (!engine.isBrowserSupported(browser)) continue;
            return engine;
        }
        return null;
    }

    public abstract JavaScriptDebugProcess<? extends VmConnection> createDebugProcess(@NotNull XDebugSession var1, @NotNull WebBrowser var2, @NotNull DebuggableFileFinder var3, @Nullable Url var4, @Nullable ExecutionResult var5, boolean var6);

    @NotNull
    public Promise<Void> prepareDebugger(final @NotNull Project project, final @NotNull WebBrowser browser) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/javascript/debugger/JavaScriptDebugEngine", "prepareDebugger"));
        }
        if (browser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "browser", "com/jetbrains/javascript/debugger/JavaScriptDebugEngine", "prepareDebugger"));
        }
        Promise promise2 = BrowserConnectionManager.getInstance().ensureExtensionInstalled(browser, project).then((Function)new Function<Void, Void>(){

            public Void fun(Void aVoid) {
                BrowserConnectionManager.getInstance().launchBrowser(browser, project);
                return null;
            }
        });
        if (promise2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/javascript/debugger/JavaScriptDebugEngine", "prepareDebugger"));
        }
        return promise2;
    }

    @Nullable
    public WebBrowser getBrowser() {
        return WebBrowserManager.getInstance().getFirstBrowser(this.getBrowserFamily());
    }

    @NotNull
    public abstract BrowserFamily getBrowserFamily();

    public void checkAvailability(@NotNull Project project) throws RuntimeConfigurationError {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/javascript/debugger/JavaScriptDebugEngine", "checkAvailability"));
        }
    }

    public boolean isBrowserSupported(@NotNull WebBrowser browser) {
        if (browser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "browser", "com/jetbrains/javascript/debugger/JavaScriptDebugEngine", "isBrowserSupported"));
        }
        return browser.getFamily().equals((Object)this.getBrowserFamily());
    }

    protected boolean isPreferredEngineForFile(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/javascript/debugger/JavaScriptDebugEngine", "isPreferredEngineForFile"));
        }
        return false;
    }

    @Nullable
    public static WebBrowser getPreferredBrowser(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/javascript/debugger/JavaScriptDebugEngine", "getPreferredBrowser"));
        }
        for (JavaScriptDebugEngine engine : JavaScriptDebugEngine.getEngines()) {
            if (!engine.isPreferredEngineForFile(file)) continue;
            return engine.getBrowser();
        }
        return null;
    }
}

