/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.javascript.debugger;

import com.intellij.lang.javascript.JSMinifiedFileUtil;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.SimilarityIndex;
import com.intellij.openapi.util.text.SimilarityIndexKt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.util.PathUtilRt;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.jetbrains.javascript.debugger.JavaScriptDebugProcess;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\u001a$\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002\u001a,\u0010\f\u001a\u0004\u0018\u00010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000f2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\"\u0016\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0010"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "resolveFileBySourceUrl", "Lcom/intellij/util/Url;", "project", "Lcom/intellij/openapi/project/Project;", "url", "sourceContent", "", "selectMostSimilarFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "files", "", "JavaScriptDebugger"})
public final class JavaScriptDebugProcessKt {
    @NotNull
    private static final Logger LOG = Logger.getInstance(JavaScriptDebugProcess.class);

    @NotNull
    public static final Logger getLOG() {
        return LOG;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final Url resolveFileBySourceUrl(Project project, Url url, String sourceContent) {
        void $receiver$iv;
        if (Intrinsics.areEqual((Object)url.getScheme(), (Object)"meteor") ^ true) {
            return null;
        }
        String fileName = PathUtilRt.getFileName((String)url.getPath());
        CharSequence charSequence = fileName;
        if ($receiver$iv.length() > 0) {
            CharSequence $receiver$iv2;
            Collection collection;
            GlobalSearchScope scope = ProjectScope.getContentScope((Project)project);
            Object token$iv = ReadAction.start();
            try {
                collection = FilenameIndex.getVirtualFilesByName((Project)project, (String)fileName, (GlobalSearchScope)scope);
            }
            finally {
                token$iv.finish();
            }
            Collection files = collection;
            token$iv = files;
            if (!$receiver$iv2.isEmpty()) {
                $receiver$iv2 = sourceContent;
                if (!($receiver$iv2 == null || $receiver$iv2.length() == 0)) {
                    Collection collection2 = files;
                    Intrinsics.checkExpressionValueIsNotNull((Object)collection2, (String)"files");
                    VirtualFile virtualFile = JavaScriptDebugProcessKt.selectMostSimilarFile(collection2, sourceContent, project);
                    if (virtualFile != null) {
                        $receiver$iv2 = virtualFile;
                        VirtualFile it = (VirtualFile)$receiver$iv2;
                        return Urls.newLocalFileUrl((VirtualFile)it);
                    }
                } else if (files.size() == 1) {
                    return Urls.newLocalFileUrl((VirtualFile)((VirtualFile)CollectionsKt.first((Iterable)files)));
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Nullable
    public static final VirtualFile selectMostSimilarFile(@NotNull Collection<? extends VirtualFile> files, @Nullable String sourceContent, @Nullable Project project) {
        int renameScore;
        Intrinsics.checkParameterIsNotNull(files, (String)"files");
        String string = sourceContent;
        if (string == null) {
            Intrinsics.throwNpe();
        }
        String string2 = string;
        Charset charset = null;
        boolean bl = true;
        Object var7_6 = null;
        if (var7_6 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: toByteArray");
        }
        if (bl & true) {
            charset = Charsets.UTF_8;
        }
        String string3 = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string3.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] sourceBytes = byArray;
        string2 = new Ref.ObjectRef();
        ((Ref.ObjectRef)string2).element = null;
        VirtualFile matchedFile = null;
        int lastMatchedScore = renameScore = 60;
        for (VirtualFile virtualFile : files) {
            int contentScore;
            int score;
            int n;
            byte[] $i$a$1;
            int length = (int)virtualFile.getLength();
            int max = Math.max(sourceBytes.length, length);
            int min = Math.min(sourceBytes.length, length);
            if (min * 100 / max < renameScore) continue;
            if (project != null) {
                Boolean bl2;
                AccessToken token$iv = ReadAction.start();
                try {
                    bl2 = JSMinifiedFileUtil.isFileMinified((VirtualFile)virtualFile, (Project)project);
                }
                finally {
                    token$iv.finish();
                }
                if (bl2.booleanValue()) continue;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile.contentsToByteArray(), (String)"file.contentsToByteArray()");
            int n2 = 0;
            int $i$f$runReadAction = 4;
            Object var17_22 = null;
            if (var17_22 != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: similarityScore");
            }
            if (($i$f$runReadAction & 4) != 0) {
                n2 = SimilarityIndexKt.MAX_SCORE;
            }
            if (Arrays.equals(sourceBytes, $i$a$1)) {
                n = n2;
            } else {
                void sourceIndex;
                if ((SimilarityIndex)sourceIndex.element == null) {
                    sourceIndex.element = SimilarityIndexKt.SimilarityIndex(sourceBytes);
                }
                SimilarityIndex similarityIndex = (SimilarityIndex)sourceIndex.element;
                if (similarityIndex == null) {
                    Intrinsics.throwNpe();
                }
                n = SimilarityIndex.score$default(similarityIndex, SimilarityIndexKt.SimilarityIndex($i$a$1), 0, 2, null);
            }
            if ((score = ((contentScore = n) * 99 + 100) / 10000) <= lastMatchedScore) continue;
            matchedFile = virtualFile;
            lastMatchedScore = score;
        }
        return matchedFile;
    }

    @Nullable
    public static /* bridge */ /* synthetic */ VirtualFile selectMostSimilarFile$default(Collection collection, String string, Project project, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: selectMostSimilarFile");
        }
        if ((n & 4) != 0) {
            project = null;
        }
        return JavaScriptDebugProcessKt.selectMostSimilarFile(collection, string, project);
    }

    @Nullable
    public static final /* synthetic */ Url access$resolveFileBySourceUrl(@NotNull Project project, @NotNull Url url, @Nullable String sourceContent) {
        return JavaScriptDebugProcessKt.resolveFileBySourceUrl(project, url, sourceContent);
    }
}

