/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.javascript.debugger;

import com.intellij.javascript.debugger.settings.CustomObjectPresentationState;
import com.intellij.javascript.debugger.settings.JavaScriptDebuggerSettings;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.css.impl.util.CssHighlighter;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ThreeState;
import com.intellij.util.Url;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XInlineDebuggerDataCallback;
import com.intellij.xdebugger.frame.XNavigatable;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.jetbrains.javascript.debugger.ChromeEvaluator;
import com.jetbrains.javascript.debugger.JavaScriptDebugProcess;
import com.jetbrains.javascript.debugger.JavaScriptDebuggerViewSupportKt;
import com.jetbrains.javascript.debugger.MemberFilterVisitor;
import com.jetbrains.javascript.debugger.NavigatableVariable;
import com.jetbrains.javascript.debugger.NavigatableVariableBackedPsiElement;
import com.jetbrains.javascript.debugger.scripts.Scripts;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Obsolescent;
import org.jetbrains.concurrency.ObsolescentConsumer;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.PromiseKt;
import org.jetbrains.debugger.BasicDebuggerViewSupport;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.DebugEventAdapter;
import org.jetbrains.debugger.DebugEventListener;
import org.jetbrains.debugger.DebuggerSupportUtils;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.MemberFilter;
import org.jetbrains.debugger.RejectErrorReporter;
import org.jetbrains.debugger.Scope;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.SourceInfo;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.VariableContext;
import org.jetbrains.debugger.VariableView;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.frame.CallFrameView;
import org.jetbrains.debugger.values.FunctionValue;
import org.jetbrains.debugger.values.ObjectValue;
import org.jetbrains.debugger.values.PrimitiveValue;
import org.jetbrains.debugger.values.Value;
import org.jetbrains.debugger.values.ValueType;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u00ba\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0016\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J0\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J(\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010$\u001a\u00020%H\u0016J0\u0010&\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020'2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J>\u0010(\u001a\u00020\u00132\u0006\u0010)\u001a\u00020'2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020#0+H\u0014J2\u0010,\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020#2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010-\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202H\u0016J\u001c\u00103\u001a\b\u0012\u0004\u0012\u0002040\u000b2\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u00020\u0013J\u0016\u00108\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J,\u00109\u001a\u0004\u0018\u00010:2\b\u0010;\u001a\u0004\u0018\u00010#2\u0006\u0010<\u001a\u00020#2\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020>H\u0016J,\u00109\u001a\u0004\u0018\u00010:2\b\u0010;\u001a\u0004\u0018\u00010#2\u0006\u00105\u001a\u0002062\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020>H\u0016J\u001c\u00109\u001a\u0004\u0018\u00010:2\b\u00105\u001a\u0004\u0018\u0001062\u0006\u00101\u001a\u00020@H\u0016J\u001a\u0010A\u001a\u0004\u0018\u00010B2\u0006\u0010C\u001a\u00020#2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001a\u0010D\u001a\u00020\u00132\u0006\u0010E\u001a\u00020:2\b\u00105\u001a\u0004\u0018\u000106H\u0016J\u0010\u0010F\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010G\u001a\u00020#2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001e\u0010H\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010I\u001a\u0004\u0018\u00010#H\u0016R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R;\u0010\u0007\u001a/\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\f \n*\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b0\u000b0\b\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006J"}, d2={"Lcom/jetbrains/javascript/debugger/JavaScriptDebuggerViewSupport;", "Lorg/jetbrains/debugger/BasicDebuggerViewSupport;", "debugProcess", "Lcom/jetbrains/javascript/debugger/JavaScriptDebugProcess;", "(Lcom/jetbrains/javascript/debugger/JavaScriptDebugProcess;)V", "getDebugProcess", "()Lcom/jetbrains/javascript/debugger/JavaScriptDebugProcess;", "scopeToMemberFilter", "Ljava/util/concurrent/ConcurrentMap;", "Lorg/jetbrains/debugger/Scope;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/concurrency/Promise;", "Lorg/jetbrains/debugger/MemberFilter;", "Lorg/jetbrains/annotations/NotNull;", "vm", "Lorg/jetbrains/debugger/Vm;", "getVm", "()Lorg/jetbrains/debugger/Vm;", "canNavigateToSource", "", "variable", "Lorg/jetbrains/debugger/Variable;", "context", "Lorg/jetbrains/debugger/VariableContext;", "computeArrayPresentation", "", "value", "Lorg/jetbrains/debugger/values/Value;", "node", "Lcom/intellij/xdebugger/frame/XValueNode;", "icon", "Ljavax/swing/Icon;", "computeInlineDebuggerData", "Lcom/intellij/util/ThreeState;", "name", "", "callback", "Lcom/intellij/xdebugger/frame/XInlineDebuggerDataCallback;", "computeObjectPresentation", "Lorg/jetbrains/debugger/values/ObjectValue;", "computeObjectSpecificPresentation", "objectValue", "propertiesToShow", "", "computeSourcePosition", "navigatable", "Lcom/intellij/xdebugger/frame/XNavigatable;", "createFrameEvaluator", "Lcom/jetbrains/javascript/debugger/ChromeEvaluator;", "frame", "Lorg/jetbrains/debugger/frame/CallFrameView;", "getFileByUrlOrVmSource", "Lcom/intellij/openapi/vfs/VirtualFile;", "script", "Lorg/jetbrains/debugger/Script;", "tryToResolveByUrl", "getMemberFilter", "getSourceInfo", "Lorg/jetbrains/debugger/SourceInfo;", "functionName", "scriptUrl", "line", "", "column", "Lorg/jetbrains/debugger/CallFrame;", "getVariable", "Lcom/intellij/lang/javascript/psi/JSVariable;", "variableSourceName", "isInLibraryContent", "sourceInfo", "isMemberVisible", "rawNameToSource", "transformErrorOnGetUsedReferenceValue", "error", "JavaScriptDebugger"})
public class JavaScriptDebuggerViewSupport
extends BasicDebuggerViewSupport {
    private final ConcurrentMap<Scope, Promise<MemberFilter>> scopeToMemberFilter;
    @NotNull
    private final JavaScriptDebugProcess<?> debugProcess;

    @Nullable
    public Vm getVm() {
        return this.debugProcess.getVm();
    }

    public boolean isInLibraryContent(@NotNull SourceInfo sourceInfo, @Nullable Script script) {
        Intrinsics.checkParameterIsNotNull((Object)sourceInfo, (String)"sourceInfo");
        return this.debugProcess.isLibraryFile$JavaScriptDebugger(script, sourceInfo.getFile());
    }

    @NotNull
    public Promise<MemberFilter> getMemberFilter(@NotNull VariableContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Scope scope = context.getScope();
        if (scope == null || Intrinsics.areEqual((Object)scope.getType(), (Object)Scope.Type.LOCAL) ^ true || !(context.getParent() instanceof CallFrameView)) {
            return this.getDefaultMemberFilterPromise();
        }
        VariableContext variableContext = context.getParent();
        if (variableContext == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.debugger.frame.CallFrameView");
        }
        CallFrameView callFrameView = (CallFrameView)variableContext;
        SourceInfo sourceInfo = callFrameView.getSourcePosition();
        if (sourceInfo == null) {
            return this.getDefaultMemberFilterPromise();
        }
        SourceInfo position = sourceInfo;
        Promise<MemberFilter> result = (Promise<MemberFilter>)this.scopeToMemberFilter.get(scope);
        if (result != null) {
            return result;
        }
        result = new MemberFilterVisitor(this, callFrameView).compute((XSourcePosition)position, (Promise<MemberFilter>)this.getDefaultMemberFilterPromise());
        Promise<MemberFilter> promise2 = this.scopeToMemberFilter.putIfAbsent(scope, result);
        if (promise2 == null) {
            promise2 = result;
        }
        return promise2;
    }

    @NotNull
    public ThreeState computeInlineDebuggerData(@NotNull String name, @NotNull Variable variable, @NotNull VariableContext context, @NotNull XInlineDebuggerDataCallback callback) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)variable, (String)"variable");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
        if (!(variable instanceof NavigatableVariable)) {
            if (variable.getValue() instanceof FunctionValue) {
                return ThreeState.NO;
            }
            JSVariable sourceVar = this.getVariable(name, context);
            if (sourceVar != null) {
                Document document;
                PsiElement navigationElement = sourceVar.getNavigationElement();
                VirtualFile file = navigationElement.getContainingFile().getVirtualFile();
                Document document2 = document = file == null ? (Document)null : FileDocumentManager.getInstance().getDocument(file);
                if (document != null) {
                    callback.computed(XDebuggerUtil.getInstance().createPositionByOffset(file, navigationElement.getTextOffset()));
                    return ThreeState.YES;
                }
            }
            return ThreeState.NO;
        }
        Variable variable2 = variable;
        if (variable2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.jetbrains.javascript.debugger.NavigatableVariableBackedPsiElement");
        }
        NavigatableVariableBackedPsiElement navigatableVariable = (NavigatableVariableBackedPsiElement)variable2;
        Segment segment = navigatableVariable.getElementPointer().getRange();
        if (segment == null) {
            return ThreeState.NO;
        }
        Segment range = segment;
        XSourcePosition xSourcePosition = XDebuggerUtil.getInstance().createPositionByOffset(navigatableVariable.getElementPointer().getVirtualFile(), range.getStartOffset());
        if (xSourcePosition == null) {
            return ThreeState.NO;
        }
        XSourcePosition xSourcePosition2 = xSourcePosition;
        callback.computed(xSourcePosition2);
        return ThreeState.YES;
    }

    @Nullable
    public SourceInfo getSourceInfo(@Nullable Script script, @NotNull CallFrame frame) {
        SourceInfo sourceInfo;
        Intrinsics.checkParameterIsNotNull((Object)frame, (String)"frame");
        Script script2 = script;
        if (script2 != null) {
            Script $receiver$iv = script2;
            Script it = $receiver$iv;
            sourceInfo = this.getSourceInfo(frame.getFunctionName(), it, frame.getLine(), frame.getColumn());
        } else {
            sourceInfo = null;
        }
        return sourceInfo;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public SourceInfo getSourceInfo(@Nullable String functionName, @NotNull String scriptUrl, int line, int column) {
        SourceInfo sourceInfo;
        Intrinsics.checkParameterIsNotNull((Object)scriptUrl, (String)"scriptUrl");
        Vm vm = this.getVm();
        if (vm != null && (vm = vm.getScriptManager()) != null && (vm = vm.findScriptByUrl(scriptUrl)) != null) {
            void $receiver$iv;
            Vm vm2 = vm;
            Script it = (Script)$receiver$iv;
            sourceInfo = this.getSourceInfo(functionName, it, line, column);
        } else {
            sourceInfo = null;
        }
        return sourceInfo;
    }

    @Nullable
    public SourceInfo getSourceInfo(@Nullable String functionName, @NotNull Script script, int line, int column) {
        Intrinsics.checkParameterIsNotNull((Object)script, (String)"script");
        return this.debugProcess.getSourceInfo(functionName, script, line, column);
    }

    public boolean isMemberVisible(@NotNull Variable variable) {
        Intrinsics.checkParameterIsNotNull((Object)variable, (String)"variable");
        return super.isMemberVisible(variable) && JavaScriptDebuggerViewSupportKt.isVariableVisible(variable);
    }

    /*
     * WARNING - void declaration
     */
    public void computeObjectPresentation(@NotNull ObjectValue value, @NotNull Variable variable, @NotNull VariableContext context, @NotNull XValueNode node, @NotNull Icon icon) {
        void $receiver$iv;
        List<String> propertiesToShow;
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)variable, (String)"variable");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)icon, (String)"icon");
        if (Intrinsics.areEqual((Object)value.getType(), (Object)ValueType.NODE)) {
            String string = value.getValueString();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            String string2 = string;
            node.setPresentation(icon, new XValuePresentation(string2){
                final /* synthetic */ String $string;

                /*
                 * WARNING - void declaration
                 */
                public void renderValue(@NotNull XValuePresentation.XValueTextRenderer renderer) {
                    Intrinsics.checkParameterIsNotNull((Object)renderer, (String)"renderer");
                    int index = StringsKt.indexOf$default((CharSequence)this.$string, (char)'#', (int)0, (boolean)false, (int)6, null);
                    if (index > 0) {
                        void startIndex$iv;
                        String $receiver$iv;
                        String string = this.$string;
                        boolean bl = false;
                        XValuePresentation.XValueTextRenderer xValueTextRenderer = renderer;
                        void v0 = $receiver$iv;
                        if (v0 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string2 = ((String)v0).substring((int)startIndex$iv, index);
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        String string3 = string2;
                        xValueTextRenderer.renderComment(string3);
                        $receiver$iv = this.$string;
                        xValueTextRenderer = renderer;
                        String string4 = $receiver$iv;
                        if (string4 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string5 = string4.substring(index);
                        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
                        string3 = string5;
                        xValueTextRenderer.renderValue(string3, CssHighlighter.CSS_IDENT);
                    } else {
                        renderer.renderComment(this.$string);
                    }
                }
                {
                    this.$string = $captured_local_variable$0;
                }
            }, true);
            return;
        }
        if (!Comparing.strEqual((String)value.getClassName(), (String)value.getValueString())) {
            VariableView.Companion.setObjectPresentation(value, icon, node);
            return;
        }
        CustomObjectPresentationState presentationState = JavaScriptDebuggerSettings.getInstance().getObjectPresentation();
        List<String> list = propertiesToShow = presentationState.isEnabled() ? presentationState.getPropertiesToShow() : CollectionsKt.emptyList();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"propertiesToShow");
        if (this.computeObjectSpecificPresentation(value, variable, context, node, icon, list)) {
            return;
        }
        if (Intrinsics.areEqual((Object)value.hasProperties(), (Object)ThreeState.NO) || propertiesToShow.isEmpty()) {
            VariableView.Companion.setObjectPresentation(value, icon, node);
            return;
        }
        List<String> list2 = propertiesToShow;
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"propertiesToShow");
        EvaluateContext evaluateContext = context.getEvaluateContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)evaluateContext, (String)"context.evaluateContext");
        Promise promise2 = value.getProperties(list2, evaluateContext, (Obsolescent)node);
        $receiver$iv.done((Consumer)new ObsolescentConsumer<List<? extends Variable>>((Obsolescent)node, node, value, icon){
            final /* synthetic */ XValueNode $node$inlined;
            final /* synthetic */ ObjectValue $value$inlined;
            final /* synthetic */ Icon $icon$inlined;

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public void consume(Object param) {
                List it = (List)param;
                JavaScriptDebuggerViewSupportKt.doSetObjectPresentation(this.$node$inlined, it, this.$value$inlined, this.$icon$inlined);
            }
            {
                void $super_call_param$1;
                this.$node$inlined = xValueNode;
                this.$value$inlined = objectValue;
                this.$icon$inlined = icon;
                super((Obsolescent)$super_call_param$1);
            }
        }).rejected((Consumer)new RejectErrorReporter(this.debugProcess.getSession()));
    }

    protected boolean computeObjectSpecificPresentation(@NotNull ObjectValue objectValue, @NotNull Variable variable, @NotNull VariableContext context, @NotNull XValueNode node, @NotNull Icon icon, @NotNull List<String> propertiesToShow) {
        Intrinsics.checkParameterIsNotNull((Object)objectValue, (String)"objectValue");
        Intrinsics.checkParameterIsNotNull((Object)variable, (String)"variable");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)icon, (String)"icon");
        Intrinsics.checkParameterIsNotNull(propertiesToShow, (String)"propertiesToShow");
        return false;
    }

    public void computeArrayPresentation(@NotNull Value value, @NotNull Variable variable, @NotNull VariableContext context, @NotNull XValueNode node, @NotNull Icon icon) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)variable, (String)"variable");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)icon, (String)"icon");
        VariableView.Companion.setArrayPresentation(value, context, icon, node);
    }

    @NotNull
    public ChromeEvaluator createFrameEvaluator(@NotNull CallFrameView frame) {
        Intrinsics.checkParameterIsNotNull((Object)frame, (String)"frame");
        return new ChromeEvaluator((VariableContext)frame);
    }

    @Nullable
    public Value transformErrorOnGetUsedReferenceValue(@Nullable Value value, @Nullable String error) {
        return value instanceof ObjectValue && (Intrinsics.areEqual((Object)"TypeError", (Object)((ObjectValue)value).getClassName()) || Intrinsics.areEqual((Object)"ReferenceError", (Object)((ObjectValue)value).getClassName())) ? (Value)PrimitiveValue.UNDEFINED : super.transformErrorOnGetUsedReferenceValue(value, error);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canNavigateToSource(@NotNull Variable variable, @NotNull VariableContext context) {
        Intrinsics.checkParameterIsNotNull((Object)variable, (String)"variable");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (variable instanceof NavigatableVariable) {
            return ((NavigatableVariable)variable).hasSourcePosition();
        }
        Scope scope = context.getScope();
        if (scope == null) return false;
        if (!Intrinsics.areEqual((Object)scope.getType(), (Object)Scope.Type.LOCAL) && !Intrinsics.areEqual((Object)scope.getType(), (Object)Scope.Type.CLOSURE)) {
            if (!Intrinsics.areEqual((Object)scope.getType(), (Object)Scope.Type.CATCH)) return false;
        }
        if (!(context.getParent() instanceof CallFrameView)) return false;
        VariableContext variableContext = context.getParent();
        if (variableContext == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.debugger.frame.CallFrameView");
        }
        if (((CallFrameView)variableContext).getSourcePosition() == null) return false;
        return true;
    }

    public void computeSourcePosition(@NotNull String name, @Nullable Value value, @NotNull Variable variable, @NotNull VariableContext context, @NotNull XNavigatable navigatable) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)variable, (String)"variable");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)navigatable, (String)"navigatable");
        if (variable instanceof NavigatableVariable) {
            navigatable.setSourcePosition(((NavigatableVariable)variable).getSourcePosition());
            return;
        }
        JSVariable sourceVar = this.getVariable(name, context);
        if (sourceVar != null) {
            navigatable.setSourcePosition(DebuggerSupportUtils.calcSourcePosition((PsiElement)((PsiElement)sourceVar)));
        }
    }

    private final JSVariable getVariable(String variableSourceName, VariableContext context) {
        if (!(context.getParent() instanceof CallFrameView)) {
            return null;
        }
        VariableContext variableContext = context.getParent();
        if (variableContext == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.debugger.frame.CallFrameView");
        }
        SourceInfo sourceInfo = ((CallFrameView)variableContext).getSourcePosition();
        if (sourceInfo == null) {
            return null;
        }
        SourceInfo sourcePosition2 = sourceInfo;
        VirtualFile virtualFile = sourcePosition2.getFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"sourcePosition.file");
        int n = sourcePosition2.getOffset();
        Project project = this.debugProcess.getSession().getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"debugProcess.session.project");
        PsiElement psiElement = JavaScriptDebuggerViewSupportKt.getContextElement(virtualFile, n, project);
        if (psiElement == null) {
            return null;
        }
        PsiElement contextElement = psiElement;
        PsiElement host = PsiTreeUtil.getParentOfType((PsiElement)contextElement, JSFunction.class);
        if (host == null) {
            host = (PsiElement)contextElement.getContainingFile();
        }
        if (host != null) {
            Ref varRef = Ref.create();
            host.accept((PsiElementVisitor)new JSElementVisitor(varRef, variableSourceName){
                final /* synthetic */ Ref $varRef;
                final /* synthetic */ String $variableSourceName;

                public void visitJSElement(@NotNull JSElement node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    if (this.$varRef.isNull()) {
                        node.acceptChildren((PsiElementVisitor)this);
                    }
                }

                public void visitJSParameter(@NotNull JSParameter node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    if (Intrinsics.areEqual((Object)this.$variableSourceName, (Object)node.getName())) {
                        this.$varRef.set((Object)node);
                    } else {
                        super.visitJSParameter(node);
                    }
                }

                public void visitJSVariable(@NotNull JSVariable node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    if (Intrinsics.areEqual((Object)this.$variableSourceName, (Object)node.getName())) {
                        this.$varRef.set((Object)node);
                    } else {
                        super.visitJSVariable(node);
                    }
                }
                {
                    this.$varRef = $captured_local_variable$0;
                    this.$variableSourceName = $captured_local_variable$1;
                }
            });
            return (JSVariable)varRef.get();
        }
        return null;
    }

    @NotNull
    public String rawNameToSource(@NotNull Variable variable) {
        Intrinsics.checkParameterIsNotNull((Object)variable, (String)"variable");
        String string = variable.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"variable.name");
        return this.debugProcess.normalizeMemberName(string);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Promise<VirtualFile> getFileByUrlOrVmSource(@NotNull Script script, boolean tryToResolveByUrl) {
        Intrinsics.checkParameterIsNotNull((Object)script, (String)"script");
        if (tryToResolveByUrl) {
            VirtualFile virtualFile = JavaScriptDebugProcess.findFile$default(this.debugProcess, script.getUrl(), false, 2, null);
            if (virtualFile != null) {
                VirtualFile $receiver$iv = virtualFile;
                VirtualFile it = $receiver$iv;
                return PromiseKt.resolvedPromise((Object)it);
            }
            Url url = script.getUrl();
            if (url.isInLocalFileSystem()) {
                VirtualFile virtualFile2 = LocalFileSystem.getInstance().findFileByPath(url.getPath());
                if (virtualFile2 != null) {
                    void $receiver$iv;
                    VirtualFile it = virtualFile2;
                    VirtualFile it2 = (VirtualFile)$receiver$iv;
                    return PromiseKt.resolvedPromise((Object)it2);
                }
            }
        }
        Promise promise2 = Scripts.getResolvedFile(script, this.getVm()).done(new Consumer<? super T>(this, script){
            final /* synthetic */ JavaScriptDebuggerViewSupport this$0;
            final /* synthetic */ Script $script;

            public final void consume(VirtualFile it) {
                JavaScriptDebugProcess<?> javaScriptDebugProcess = this.this$0.getDebugProcess();
                Url url = this.$script.getUrl();
                VirtualFile virtualFile = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"it");
                javaScriptDebugProcess.saveResolvedFile(url, virtualFile);
            }
            {
                this.this$0 = javaScriptDebuggerViewSupport;
                this.$script = script;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)promise2, (String)"Scripts.getResolvedFile(\u2026vedFile(script.url, it) }");
        return promise2;
    }

    @NotNull
    public final JavaScriptDebugProcess<?> getDebugProcess() {
        return this.debugProcess;
    }

    public JavaScriptDebuggerViewSupport(@NotNull JavaScriptDebugProcess<?> debugProcess) {
        Intrinsics.checkParameterIsNotNull(debugProcess, (String)"debugProcess");
        this.debugProcess = debugProcess;
        this.scopeToMemberFilter = ContainerUtil.newConcurrentMap();
        this.debugProcess.getConnection().addDebugListener((DebugEventListener)new DebugEventAdapter(){

            public void resumed() {
                this.clear();
            }

            public void disconnected() {
                this.clear();
            }

            public void navigated(@NotNull String newUrl) {
                Intrinsics.checkParameterIsNotNull((Object)newUrl, (String)"newUrl");
                this.clear();
            }

            private final void clear() {
                scopeToMemberFilter.clear();
            }
        });
    }
}

