/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.javascript.debugger;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ReadAction;
import com.intellij.util.Function;
import com.jetbrains.javascript.debugger.JavaScriptDebuggerConsoleExecuteActionHandler;
import com.jetbrains.javascript.debugger.VariablesHolder;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.AsyncValueLoader;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.DebuggerViewSupport;
import org.jetbrains.debugger.Scope;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.VariableView;
import org.jetbrains.debugger.values.Value;

class LocalVariablesHolder
extends VariablesHolder {
    volatile CallFrame callFrame;
    private final AsyncValueLoader<Boolean> variablesLoader;

    public LocalVariablesHolder(@NotNull DebuggerViewSupport debugProcess) {
        if (debugProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugProcess", "com/jetbrains/javascript/debugger/LocalVariablesHolder", "<init>"));
        }
        super(debugProcess);
        this.variablesLoader = new AsyncValueLoader<Boolean>(){

            @NotNull
            protected Promise<Boolean> load(@NotNull AsyncPromise<Boolean> promise2) {
                if (promise2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "promise", "com/jetbrains/javascript/debugger/LocalVariablesHolder$1", "load"));
                }
                CallFrame currentCallFrame = LocalVariablesHolder.this.callFrame;
                if (currentCallFrame == null) {
                    promise2.setError((Throwable)AsyncPromise.OBSOLETE_ERROR);
                    AsyncPromise<Boolean> asyncPromise = promise2;
                    if (asyncPromise == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/javascript/debugger/LocalVariablesHolder$1", "load"));
                    }
                    return asyncPromise;
                }
                Scope scope = JavaScriptDebuggerConsoleExecuteActionHandler.Companion.getLocalScope(currentCallFrame);
                if (scope == null) {
                    promise2.setError((Throwable)AsyncPromise.OBSOLETE_ERROR);
                    AsyncPromise<Boolean> asyncPromise = promise2;
                    if (asyncPromise == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/javascript/debugger/LocalVariablesHolder$1", "load"));
                    }
                    return asyncPromise;
                }
                Promise promise3 = scope.getVariablesHost().get().then((Function)new Function<List<Variable>, Boolean>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Boolean fun(List<Variable> variables) {
                        if (LocalVariablesHolder.this.viewSupport.getVm() == null || variables.isEmpty()) {
                            return true;
                        }
                        AccessToken token = ReadAction.start();
                        try {
                            LocalVariablesHolder.this.nameToPsiTypeName.clear();
                            LocalVariablesHolder.this.lookupElements.clear();
                            LocalVariablesHolder.this.nameToPsiTypeName.ensureCapacity(variables.size());
                            LocalVariablesHolder.this.lookupElements.ensureCapacity(variables.size());
                            for (Variable variable : variables) {
                                String name = variable.getName();
                                LocalVariablesHolder.this.nameToPsiTypeName.put((Object)name, (Object)VariablesHolder.backendTypeNameToPsiTypeName(variable.getValue()));
                                LookupElementBuilder lookupItem = LookupElementBuilder.create((String)name);
                                Value value = variable.getValue();
                                if (value != null) {
                                    lookupItem.withIcon(VariableView.Companion.getIcon(value));
                                }
                                LocalVariablesHolder.this.lookupElements.add(lookupItem);
                            }
                        }
                        finally {
                            token.finish();
                        }
                        return true;
                    }
                });
                if (promise3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/javascript/debugger/LocalVariablesHolder$1", "load"));
                }
                return promise3;
            }
        };
    }

    @Override
    protected AsyncValueLoader<?> getVariablesLoader() {
        return this.variablesLoader;
    }
}

