/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.javascript.debugger;

import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.Function;
import com.intellij.xdebugger.XSourcePosition;
import com.jetbrains.javascript.debugger.JavaScriptDebugAware;
import com.jetbrains.javascript.debugger.JavaScriptDebuggerViewSupport;
import com.jetbrains.javascript.debugger.JavaScriptNameMapper;
import com.jetbrains.javascript.debugger.MemberFilterVisitorKt;
import com.jetbrains.javascript.debugger.MyMemberFilter;
import com.jetbrains.javascript.debugger.NameMapper;
import com.jetbrains.javascript.debugger.VariablesAndExpressionsCollector;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.PromiseKt;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.MemberFilter;
import org.jetbrains.debugger.PsiVisitors;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.frame.CallFrameView;
import org.jetbrains.debugger.sourcemap.MappingEntry;
import org.jetbrains.debugger.sourcemap.SourceMap;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\"\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bJ\u0018\u0010\u000f\u001a\n \u0010*\u0004\u0018\u00010\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0002J \u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/javascript/debugger/MemberFilterVisitor;", "Lorg/jetbrains/debugger/PsiVisitors$Visitor;", "Lorg/jetbrains/debugger/MemberFilter;", "viewSupport", "Lcom/jetbrains/javascript/debugger/JavaScriptDebuggerViewSupport;", "callFrameView", "Lorg/jetbrains/debugger/frame/CallFrameView;", "(Lcom/jetbrains/javascript/debugger/JavaScriptDebuggerViewSupport;Lorg/jetbrains/debugger/frame/CallFrameView;)V", "generatedFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "compute", "Lorg/jetbrains/concurrency/Promise;", "position", "Lcom/intellij/xdebugger/XSourcePosition;", "defaultMemberFilterPromise", "doCompute", "kotlin.jvm.PlatformType", "visit", "element", "Lcom/intellij/psi/PsiElement;", "positionOffset", "", "document", "Lcom/intellij/openapi/editor/Document;", "JavaScriptDebugger"})
public final class MemberFilterVisitor
extends PsiVisitors.Visitor<MemberFilter> {
    private VirtualFile generatedFile;
    private final JavaScriptDebuggerViewSupport viewSupport;
    private final CallFrameView callFrameView;

    @NotNull
    public final Promise<MemberFilter> compute(@NotNull XSourcePosition position, @NotNull Promise<MemberFilter> defaultMemberFilterPromise) {
        Script script;
        Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
        Intrinsics.checkParameterIsNotNull(defaultMemberFilterPromise, (String)"defaultMemberFilterPromise");
        Script script2 = script = this.callFrameView.getScript();
        if ((script2 != null ? script2.getSourceMap() : null) == null) {
            MemberFilter result = this.doCompute(position);
            return result == this.viewSupport ? defaultMemberFilterPromise : PromiseKt.resolvedPromise((Object)result);
        }
        Script script3 = script;
        if (script3 == null) {
            Intrinsics.throwNpe();
        }
        Promise promise2 = this.viewSupport.getFileByUrlOrVmSource(script3, true).then(new Function<? super T, ? extends SUB_RESULT>(this, position){
            final /* synthetic */ MemberFilterVisitor this$0;
            final /* synthetic */ XSourcePosition $position;

            public final MemberFilter fun(VirtualFile it) {
                MemberFilterVisitor.access$setGeneratedFile$p(this.this$0, it);
                return MemberFilterVisitor.access$doCompute(this.this$0, this.$position);
            }
            {
                this.this$0 = memberFilterVisitor;
                this.$position = xSourcePosition;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)promise2, (String)"viewSupport.getFileByUrl\u2026mpute(position)\n        }");
        return promise2;
    }

    private final MemberFilter doCompute(XSourcePosition position) {
        return (MemberFilter)PsiVisitors.visit((XSourcePosition)position, (Project)this.viewSupport.getDebugProcess().getSession().getProject(), (PsiVisitors.Visitor)this, (Object)((Object)this.viewSupport));
    }

    @NotNull
    public MemberFilter visit(@NotNull PsiElement element, int positionOffset, @NotNull Document document) {
        MappingEntry sourceMapping2;
        SourceMap sourceMap;
        Script script;
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        NameMapper nameMapper = null;
        Script script2 = script = this.callFrameView.getScript();
        Object object = sourceMap = script2 != null ? script2.getSourceMap() : null;
        if (sourceMap != null && sourceMap.getHasNameMappings() && this.generatedFile != null) {
            Document generatedDocument;
            FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
            VirtualFile virtualFile = this.generatedFile;
            if (virtualFile == null) {
                Intrinsics.throwNpe();
            }
            if ((generatedDocument = fileDocumentManager.getDocument(virtualFile)) != null && generatedDocument.getTextLength() > 0) {
                CallFrame callFrame = this.callFrameView.getCallFrame();
                sourceMapping2 = sourceMap.getMappings().get(callFrame.getLine(), callFrame.getColumn());
                if (sourceMapping2 != null) {
                    nameMapper = new JavaScriptNameMapper(document, generatedDocument, sourceMap.getMappingsOrderedBySource(sourceMapping2.getSource()), sourceMap);
                }
            }
        }
        sourceMapping2 = (MappingEntry)JavaScriptDebugAware.EP_NAME.getExtensions();
        for (int callFrame = 0; callFrame < ((JavaScriptDebugAware[])sourceMapping2).length; ++callFrame) {
            JavaScriptDebugAware debugAware = sourceMapping2[callFrame];
            MemberFilter filter = debugAware.createMemberFilter(nameMapper, element, positionOffset);
            if (filter == null) continue;
            return filter;
        }
        JSFunction jSFunction = MemberFilterVisitorKt.access$getParentFunction(element);
        if (jSFunction == null) {
            return (MemberFilter)this.viewSupport;
        }
        JSFunction jsFun = jSFunction;
        if (nameMapper != null) {
            JSParameter[] jSParameterArray = jsFun.getParameters();
            for (int sourceMapping2 = 0; sourceMapping2 < jSParameterArray.length; ++sourceMapping2) {
                JSParameter parameter = jSParameterArray[sourceMapping2];
                PsiElement psiElement = (PsiElement)parameter;
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"parameter");
                nameMapper.map(psiElement);
            }
        }
        VariablesAndExpressionsCollector visitor = new VariablesAndExpressionsCollector(positionOffset, (PsiElement)jsFun, nameMapper);
        JSSourceElement[] jSSourceElementArray = jsFun.getBody();
        for (int i = 0; i < jSSourceElementArray.length; ++i) {
            JSSourceElement sourceElement = jSSourceElementArray[i];
            sourceElement.accept((PsiElementVisitor)visitor);
        }
        NameMapper nameMapper2 = nameMapper;
        return (MemberFilter)new MyMemberFilter(visitor.getVariableDeclaredAfter(), (Collection<? extends Variable>)visitor.getExpressions(), nameMapper2 != null ? nameMapper2.getRawNameToSource() : null, this.viewSupport.getDebugProcess());
    }

    public MemberFilterVisitor(@NotNull JavaScriptDebuggerViewSupport viewSupport, @NotNull CallFrameView callFrameView) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)viewSupport), (String)"viewSupport");
        Intrinsics.checkParameterIsNotNull((Object)callFrameView, (String)"callFrameView");
        this.viewSupport = viewSupport;
        this.callFrameView = callFrameView;
    }

    @Nullable
    public static final /* synthetic */ VirtualFile access$getGeneratedFile$p(MemberFilterVisitor $this) {
        return $this.generatedFile;
    }

    public static final /* synthetic */ void access$setGeneratedFile$p(MemberFilterVisitor $this, @Nullable VirtualFile virtualFile) {
        $this.generatedFile = virtualFile;
    }

    public static final /* synthetic */ MemberFilter access$doCompute(MemberFilterVisitor $this, @NotNull XSourcePosition position) {
        return $this.doCompute(position);
    }
}

