/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.javascript.debugger;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import com.intellij.util.Url;
import com.intellij.util.containers.ObjectIntHashMap;
import com.intellij.xdebugger.XSourcePosition;
import com.jetbrains.javascript.debugger.FileUrlMapper;
import com.jetbrains.javascript.debugger.JavaScriptDebugProcess;
import com.jetbrains.javascript.debugger.MySourceEntriesProcessor;
import com.jetbrains.javascript.debugger.SourceEntriesProcessor;
import com.jetbrains.javascript.debugger.SourceMapHelperKt;
import com.jetbrains.javascript.debugger.sourcemap.PreloadedSourceMapList;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TObjectObjectProcedure;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.Location;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.sourcemap.MappingEntry;
import org.jetbrains.debugger.sourcemap.MappingList;
import org.jetbrains.debugger.sourcemap.SourceMap;
import org.jetbrains.debugger.sourcemap.SourceResolver;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u0000V\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001c\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001aZ\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00112\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00132\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\r\u001aR\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\b2\u0006\u0010\u0015\u001a\u00020\u00162\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00112\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00132\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\r\u001a:\u0010\u0017\u001a\u00020\u00182\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0000\u001aZ\u0010\u0017\u001a\u00020\u0018*\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\b2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u000e\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00012\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\rH\u0002\u00a8\u0006\u001c"}, d2={"createResolver", "Lcom/intellij/openapi/util/NullableLazyValue;", "Lorg/jetbrains/debugger/sourcemap/SourceResolver$Resolver;", "project", "Lcom/intellij/openapi/project/Project;", "sourceFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getRawLocations", "", "Lorg/jetbrains/debugger/Location;", "debugProcess", "Lcom/jetbrains/javascript/debugger/JavaScriptDebugProcess;", "sourceUrls", "Lcom/intellij/util/Url;", "sourceLine", "", "map", "Lorg/jetbrains/debugger/sourcemap/SourceMap;", "script", "Lorg/jetbrains/debugger/Script;", "scriptUrl", "sourcePosition", "Lcom/intellij/xdebugger/XSourcePosition;", "processMappingsInLine", "", "entryProcessor", "Lcom/jetbrains/javascript/debugger/SourceEntriesProcessor;", "resolver", "JavaScriptDebugger"})
public final class SourceMapHelperKt {
    @NotNull
    public static final List<Location> getRawLocations(@NotNull JavaScriptDebugProcess<?> debugProcess, @NotNull List<? extends Url> sourceUrls, @NotNull XSourcePosition sourcePosition2, @Nullable SourceMap map, @Nullable Script script, @Nullable Url scriptUrl) {
        Intrinsics.checkParameterIsNotNull(debugProcess, (String)"debugProcess");
        Intrinsics.checkParameterIsNotNull(sourceUrls, (String)"sourceUrls");
        Intrinsics.checkParameterIsNotNull((Object)sourcePosition2, (String)"sourcePosition");
        VirtualFile virtualFile = sourcePosition2.getFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"sourcePosition.file");
        return SourceMapHelperKt.getRawLocations(debugProcess, sourceUrls, virtualFile, sourcePosition2.getLine(), map, script, scriptUrl);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ List getRawLocations$default(JavaScriptDebugProcess javaScriptDebugProcess, List list, XSourcePosition xSourcePosition, SourceMap sourceMap, Script script, Url url, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getRawLocations");
        }
        if ((n & 8) != 0) {
            sourceMap = null;
        }
        if ((n & 0x10) != 0) {
            script = null;
        }
        if ((n & 0x20) != 0) {
            url = null;
        }
        return SourceMapHelperKt.getRawLocations(javaScriptDebugProcess, list, xSourcePosition, sourceMap, script, url);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Location> getRawLocations(@NotNull JavaScriptDebugProcess<?> debugProcess, @NotNull List<? extends Url> sourceUrls, @NotNull VirtualFile sourceFile, int sourceLine, @Nullable SourceMap map, @Nullable Script script, @Nullable Url scriptUrl) {
        Intrinsics.checkParameterIsNotNull(debugProcess, (String)"debugProcess");
        Intrinsics.checkParameterIsNotNull(sourceUrls, (String)"sourceUrls");
        Intrinsics.checkParameterIsNotNull((Object)sourceFile, (String)"sourceFile");
        MySourceEntriesProcessor processor2 = new MySourceEntriesProcessor();
        if (map != null && (script != null || scriptUrl != null)) {
            SourceEntriesProcessor sourceEntriesProcessor = processor2;
            Project project = debugProcess.getSession().getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"debugProcess.session.project");
            SourceMapHelperKt.processMappingsInLine(sourceEntriesProcessor, map, script, sourceUrls, sourceLine, sourceFile, SourceMapHelperKt.createResolver(project, sourceFile), scriptUrl);
        } else {
            SourceMapHelperKt.processMappingsInLine(debugProcess, sourceUrls, sourceFile, sourceLine, processor2);
        }
        if (processor2.getLineToFirstMapping() == null) {
            return CollectionsKt.emptyList();
        }
        SmartList locations = new SmartList();
        LinkedHashMap<Object, TIntObjectHashMap<MappingEntry>> linkedHashMap = processor2.getLineToFirstMapping();
        if (linkedHashMap == null) {
            Intrinsics.throwNpe();
        }
        Iterator<Map.Entry<Object, TIntObjectHashMap<MappingEntry>>> iterator = linkedHashMap.entrySet().iterator();
        while (iterator.hasNext()) {
            void $receiver$iv;
            void $receiver$iv2;
            Map.Entry<Object, TIntObjectHashMap<MappingEntry>> entry;
            Map.Entry<Object, TIntObjectHashMap<MappingEntry>> entry2 = entry = iterator.next();
            Object key = $receiver$iv2.getKey();
            Map.Entry<Object, TIntObjectHashMap<MappingEntry>> $i$f$component1 = entry;
            TIntObjectHashMap value = (TIntObjectHashMap)$receiver$iv.getValue();
            int[] lines = value.keys();
            Arrays.sort(lines);
            for (int i = 0; i < lines.length; ++i) {
                int line = lines[i];
                MappingEntry mapping = (MappingEntry)value.get(line);
                if (key instanceof Script) {
                    locations.add((Object)new Location((Script)key, mapping.getGeneratedLine(), mapping.getGeneratedColumn()));
                    continue;
                }
                Object k = key;
                if (k == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.util.Url");
                }
                locations.add((Object)new Location((Url)k, mapping.getGeneratedLine(), mapping.getGeneratedColumn()));
            }
        }
        return (List)locations;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ List getRawLocations$default(JavaScriptDebugProcess javaScriptDebugProcess, List list, VirtualFile virtualFile, int n, SourceMap sourceMap, Script script, Url url, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getRawLocations");
        }
        if ((n2 & 0x10) != 0) {
            sourceMap = null;
        }
        if ((n2 & 0x20) != 0) {
            script = null;
        }
        if ((n2 & 0x40) != 0) {
            url = null;
        }
        return SourceMapHelperKt.getRawLocations(javaScriptDebugProcess, list, virtualFile, n, sourceMap, script, url);
    }

    public static final void processMappingsInLine(@NotNull JavaScriptDebugProcess<?> debugProcess, @NotNull List<? extends Url> sourceUrls, @NotNull VirtualFile sourceFile, int sourceLine, @NotNull SourceEntriesProcessor entryProcessor) {
        Intrinsics.checkParameterIsNotNull(debugProcess, (String)"debugProcess");
        Intrinsics.checkParameterIsNotNull(sourceUrls, (String)"sourceUrls");
        Intrinsics.checkParameterIsNotNull((Object)sourceFile, (String)"sourceFile");
        Intrinsics.checkParameterIsNotNull((Object)entryProcessor, (String)"entryProcessor");
        Project project = debugProcess.getSession().getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"debugProcess.session.project");
        NullableLazyValue<SourceResolver.Resolver> resolverLazyValue = SourceMapHelperKt.createResolver(project, sourceFile);
        PreloadedSourceMapList preloadedSourceMaps = debugProcess.getPreloadedSourceMaps$JavaScriptDebugger();
        preloadedSourceMaps.process((TObjectObjectProcedure<Url, SourceMap>)((TObjectObjectProcedure)new TObjectObjectProcedure<Url, SourceMap>(entryProcessor, sourceUrls, sourceLine, sourceFile, resolverLazyValue){
            final /* synthetic */ SourceEntriesProcessor $entryProcessor;
            final /* synthetic */ List $sourceUrls;
            final /* synthetic */ int $sourceLine;
            final /* synthetic */ VirtualFile $sourceFile;
            final /* synthetic */ NullableLazyValue $resolverLazyValue;

            public final boolean execute(Url url, SourceMap map) {
                this.$entryProcessor.setScriptUrl(url);
                map.processMappingsInLine(this.$sourceUrls, this.$sourceLine, (MappingList.MappingsProcessorInLine)this.$entryProcessor, this.$sourceFile, this.$resolverLazyValue);
                this.$entryProcessor.setScriptUrl(null);
                return true;
            }
            {
                this.$entryProcessor = sourceEntriesProcessor;
                this.$sourceUrls = list;
                this.$sourceLine = n;
                this.$sourceFile = virtualFile;
                this.$resolverLazyValue = nullableLazyValue;
            }
        }));
        debugProcess.forEachScript((Function1<Script, Boolean>)((Function1)new Function1<Script, Boolean>(preloadedSourceMaps, entryProcessor, sourceUrls, sourceLine, sourceFile, resolverLazyValue){
            final /* synthetic */ PreloadedSourceMapList $preloadedSourceMaps;
            final /* synthetic */ SourceEntriesProcessor $entryProcessor;
            final /* synthetic */ List $sourceUrls;
            final /* synthetic */ int $sourceLine;
            final /* synthetic */ VirtualFile $sourceFile;
            final /* synthetic */ NullableLazyValue $resolverLazyValue;

            public final boolean invoke(@NotNull Script script) {
                Intrinsics.checkParameterIsNotNull((Object)script, (String)"script");
                SourceMap map = script.getSourceMap();
                if (map != null && !this.$preloadedSourceMaps.containsMap(map)) {
                    SourceMapHelperKt.processMappingsInLine$default(this.$entryProcessor, map, script, this.$sourceUrls, this.$sourceLine, this.$sourceFile, this.$resolverLazyValue, null, 64, null);
                }
                return true;
            }
            {
                this.$preloadedSourceMaps = preloadedSourceMapList;
                this.$entryProcessor = sourceEntriesProcessor;
                this.$sourceUrls = list;
                this.$sourceLine = n;
                this.$sourceFile = virtualFile;
                this.$resolverLazyValue = nullableLazyValue;
                super(1);
            }
        }));
    }

    private static final void processMappingsInLine(SourceEntriesProcessor $receiver, SourceMap map, Script script, List<? extends Url> sourceUrls, int sourceLine, VirtualFile sourceFile, NullableLazyValue<SourceResolver.Resolver> resolver, Url scriptUrl) {
        Url url = scriptUrl;
        if (url == null) {
            Script script2 = script;
            if (script2 == null) {
                Intrinsics.throwNpe();
            }
            url = script2.getUrl();
        }
        $receiver.setScriptUrl(url);
        $receiver.setScript(script);
        map.processMappingsInLine(sourceUrls, sourceLine, (MappingList.MappingsProcessorInLine)$receiver, sourceFile, resolver);
        $receiver.setScriptUrl(null);
        $receiver.setScript(null);
    }

    static /* bridge */ /* synthetic */ void processMappingsInLine$default(SourceEntriesProcessor sourceEntriesProcessor, SourceMap sourceMap, Script script, List list, int n, VirtualFile virtualFile, NullableLazyValue nullableLazyValue, Url url, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: processMappingsInLine");
        }
        if ((n2 & 0x40) != 0) {
            url = null;
        }
        SourceMapHelperKt.processMappingsInLine(sourceEntriesProcessor, sourceMap, script, list, n, virtualFile, (NullableLazyValue<SourceResolver.Resolver>)nullableLazyValue, url);
    }

    @NotNull
    public static final NullableLazyValue<SourceResolver.Resolver> createResolver(@NotNull Project project, @NotNull VirtualFile sourceFile) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)sourceFile, (String)"sourceFile");
        return (NullableLazyValue)new NullableLazyValue<SourceResolver.Resolver>(sourceFile, project){
            final /* synthetic */ VirtualFile $sourceFile;
            final /* synthetic */ Project $project;

            @Nullable
            protected SourceResolver.Resolver compute() {
                FileUrlMapper[] fileUrlMapperArray = (FileUrlMapper[])FileUrlMapper.EP_NAME.getExtensions();
                for (int i = 0; i < fileUrlMapperArray.length; ++i) {
                    FileUrlMapper mapper = fileUrlMapperArray[i];
                    FileUrlMapper.SourceResolver resolver = mapper.createSourceResolver(this.$sourceFile, this.$project);
                    if (resolver == null) continue;
                    return new SourceResolver.Resolver(this, resolver){
                        final /* synthetic */ createResolver.1 this$0;
                        final /* synthetic */ FileUrlMapper.SourceResolver $resolver;

                        public int resolve(@Nullable VirtualFile sourceFile, @NotNull ObjectIntHashMap<Url> map) {
                            Intrinsics.checkParameterIsNotNull(map, (String)"map");
                            return this.$resolver.resolve(map, this.this$0.$project);
                        }
                        {
                            this.this$0 = $outer;
                            this.$resolver = $captured_local_variable$1;
                        }
                    };
                }
                return null;
            }
            {
                this.$sourceFile = $captured_local_variable$0;
                this.$project = $captured_local_variable$1;
            }
        };
    }
}

