/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.javascript.debugger;

import com.intellij.javascript.JSDebuggerSupportUtils;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.util.SideEffectsVisitor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.util.SmartList;
import com.intellij.util.containers.SmartHashSet;
import com.intellij.xdebugger.settings.XDebuggerSettingsManager;
import com.jetbrains.javascript.debugger.BaseCollector;
import com.jetbrains.javascript.debugger.MyValueModifier;
import com.jetbrains.javascript.debugger.NameMapper;
import com.jetbrains.javascript.debugger.NavigatableVariableBackedPsiElement;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.ValueModifier;
import org.jetbrains.debugger.Variable;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00100\u001eJ\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\r0 J\u0010\u0010!\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\u0019H\u0002J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020$2\u0006\u0010(\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020$2\u0006\u0010\"\u001a\u00020\u0019H\u0016J\u0010\u0010+\u001a\u00020$2\u0006\u0010,\u001a\u00020-H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\n \u0013*\u0004\u0018\u00010\u00150\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/jetbrains/javascript/debugger/VariablesAndExpressionsCollector;", "Lcom/jetbrains/javascript/debugger/BaseCollector;", "positionOffset", "", "host", "Lcom/intellij/psi/PsiElement;", "nameMapper", "Lcom/jetbrains/javascript/debugger/NameMapper;", "(ILcom/intellij/psi/PsiElement;Lcom/jetbrains/javascript/debugger/NameMapper;)V", "collectExpression", "", "expressionUniqueGuard", "", "", "expressions", "", "Lorg/jetbrains/debugger/Variable;", "hostFile", "Lcom/intellij/psi/PsiFile;", "kotlin.jvm.PlatformType", "hostTextRange", "Lcom/intellij/openapi/util/TextRange;", "processedReferenceTargets", "Lgnu/trove/THashSet;", "tempQualifiers", "Lcom/intellij/lang/javascript/psi/JSReferenceExpression;", "valueModifier", "Lorg/jetbrains/debugger/ValueModifier;", "variableDeclaredAfter", "getExpressions", "", "getVariableDeclaredAfter", "", "isSuitableTarget", "referenceExpression", "visitJSCallExpression", "", "callExpression", "Lcom/intellij/lang/javascript/psi/JSCallExpression;", "visitJSFunctionDeclaration", "node", "Lcom/intellij/lang/javascript/psi/JSFunction;", "visitJSReferenceExpression", "visitJSVariable", "variable", "Lcom/intellij/lang/javascript/psi/JSVariable;", "JavaScriptDebugger"})
public final class VariablesAndExpressionsCollector
extends BaseCollector {
    private final boolean collectExpression;
    private final TextRange hostTextRange;
    private final PsiFile hostFile;
    private Set<String> variableDeclaredAfter;
    private Set<String> expressionUniqueGuard;
    private List<Variable> expressions;
    private ValueModifier valueModifier;
    private final THashSet<PsiElement> processedReferenceTargets;
    private List<JSReferenceExpression> tempQualifiers;
    private final int positionOffset;
    private final NameMapper nameMapper;

    public void visitJSCallExpression(@NotNull JSCallExpression callExpression) {
        Intrinsics.checkParameterIsNotNull((Object)callExpression, (String)"callExpression");
        PsiElement firstChild = callExpression.getFirstChild();
        if (firstChild instanceof JSReferenceExpression) {
            Unit unit;
            Unit unit2;
            JSExpression jSExpression = ((JSReferenceExpression)firstChild).getQualifier();
            if (jSExpression != null) {
                jSExpression.accept((PsiElementVisitor)this);
                unit2 = Unit.INSTANCE;
            } else {
                unit2 = null;
            }
            JSArgumentList jSArgumentList = callExpression.getArgumentList();
            if (jSArgumentList != null) {
                jSArgumentList.accept((PsiElementVisitor)this);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
        } else {
            super.visitJSCallExpression(callExpression);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void visitJSReferenceExpression(@NotNull JSReferenceExpression referenceExpression) {
        JSExpression qualifier22;
        Intrinsics.checkParameterIsNotNull((Object)referenceExpression, (String)"referenceExpression");
        if (!this.collectExpression || new SideEffectsVisitor().check((JSExpression)referenceExpression)) {
            return;
        }
        if (this.tempQualifiers == null) {
            this.tempQualifiers = (List)new SmartList();
        } else {
            List<JSReferenceExpression> list = this.tempQualifiers;
            if (list == null) {
                Intrinsics.throwNpe();
            }
            list.clear();
        }
        List<JSReferenceExpression> list = this.tempQualifiers;
        if (list == null) {
            Intrinsics.throwNpe();
        }
        List<JSReferenceExpression> qualifiers = list;
        qualifiers.add(referenceExpression);
        JSReferenceExpression expression = referenceExpression;
        while ((qualifier22 = expression.getQualifier()) instanceof JSReferenceExpression) {
            expression = (JSReferenceExpression)qualifier22;
            qualifiers.add(expression);
        }
        IntProgression intProgression = RangesKt.reversed((IntProgression)((IntProgression)CollectionsKt.getIndices((Collection)qualifiers)));
        int qualifier22 = intProgression.getFirst();
        int n = intProgression.getLast();
        int n2 = intProgression.getStep();
        int n3 = qualifier22;
        int n4 = n;
        if (n2 > 0 ? n3 <= n4 : n3 >= n4) {
            while (true) {
                void i;
                if (!this.isSuitableTarget(expression = qualifiers.get((int)i))) {
                    return;
                }
                if (this.expressions == null) {
                    this.expressions = (List)new SmartList();
                    this.expressionUniqueGuard = (Set)new SmartHashSet();
                    this.valueModifier = new MyValueModifier();
                }
                String name = expression.getText();
                Set<String> set = this.expressionUniqueGuard;
                if (set == null) {
                    Intrinsics.throwNpe();
                }
                String string = name;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
                if (set.add(string)) {
                    List<Variable> list2 = this.expressions;
                    if (list2 == null) {
                        Intrinsics.throwNpe();
                    }
                    String string2 = name;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"name");
                    list2.add((Variable)new NavigatableVariableBackedPsiElement(string2, (PsiElement)expression, this.valueModifier));
                }
                if (i == n) break;
                i += n2;
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isSuitableTarget(JSReferenceExpression referenceExpression) {
        PsiElement psiElement = JSDebuggerSupportUtils.resolve((JSReferenceExpression)referenceExpression);
        if (psiElement == null) return false;
        PsiElement target = psiElement;
        if (!this.processedReferenceTargets.add((Object)target)) {
            return false;
        }
        if (target instanceof JSProperty) {
            void $receiver$iv;
            if (Intrinsics.areEqual((Object)((JSProperty)target).getContainingFile(), (Object)this.hostFile.getContainingFile()) && ((JSProperty)target).getTextRange().intersects(TextRange.EMPTY_RANGE) && ((JSProperty)target).getNode().getStartOffset() >= this.positionOffset) {
                return false;
            }
            JSFunction value = ((JSProperty)target).tryGetFunctionInitializer();
            if (value == null) return true;
            CharSequence charSequence = value.getName();
            if ($receiver$iv == null) return true;
            if ($receiver$iv.length() != 0) return false;
            return true;
        }
        if (target instanceof JSDefinitionExpression) {
            TextRange textRange;
            if (Intrinsics.areEqual((Object)this.hostFile, (Object)((JSDefinitionExpression)target).getContainingFile()) && this.hostTextRange.contains(textRange = ((JSDefinitionExpression)target).getTextRange()) && textRange.getStartOffset() > this.positionOffset) {
                return false;
            }
            if (!((JSDefinitionExpression)target).isDeclaration()) return false;
            if (referenceExpression.getQualifier() == null) return false;
            return true;
        }
        if (!(target instanceof JSVariable)) return target instanceof TypeScriptPropertySignature;
        if (target instanceof LightElement) {
            return false;
        }
        if (((JSVariable)target).getName() != null && Intrinsics.areEqual((Object)this.hostFile, (Object)((JSVariable)target).getContainingFile())) {
            String string;
            NameMapper nameMapper = this.nameMapper;
            if (nameMapper != null) {
                PsiElement psiElement2 = target;
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"target");
                string = nameMapper.map(psiElement2);
            } else {
                string = null;
            }
        }
        if (!((JSVariable)target).isLocal()) return true;
        if (!Intrinsics.areEqual((Object)this.hostFile, (Object)((JSVariable)target).getContainingFile())) return true;
        TextRange textRange = ((JSVariable)target).getTextRange();
        if (!this.hostTextRange.contains(textRange)) return true;
        if (textRange.getStartOffset() >= this.positionOffset) return false;
        return true;
    }

    @Override
    public void visitJSFunctionDeclaration(@NotNull JSFunction node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
    }

    public void visitJSVariable(@NotNull JSVariable variable) {
        Unit unit;
        Intrinsics.checkParameterIsNotNull((Object)variable, (String)"variable");
        String name = variable.getName();
        if (name != null) {
            if (variable.getNode().getStartOffset() >= this.positionOffset) {
                if (this.variableDeclaredAfter == null) {
                    this.variableDeclaredAfter = (Set)new THashSet();
                }
                Set<String> set = this.variableDeclaredAfter;
                if (set == null) {
                    Intrinsics.throwNpe();
                }
                set.add(name);
            }
            NameMapper nameMapper = this.nameMapper;
            String string = nameMapper != null ? nameMapper.map((PsiElement)variable) : null;
        }
        JSExpression jSExpression = variable.getInitializerOrStub();
        if (jSExpression != null) {
            jSExpression.accept((PsiElementVisitor)this);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
    }

    @NotNull
    public final Set<String> getVariableDeclaredAfter() {
        Set set = this.variableDeclaredAfter;
        if (set == null) {
            set = SetsKt.emptySet();
        }
        return set;
    }

    @NotNull
    public final List<Variable> getExpressions() {
        List list = this.expressions;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    public VariablesAndExpressionsCollector(int positionOffset, @NotNull PsiElement host, @Nullable NameMapper nameMapper) {
        Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
        this.positionOffset = positionOffset;
        this.nameMapper = nameMapper;
        this.collectExpression = XDebuggerSettingsManager.getInstance().getDataViewSettings().isAutoExpressions();
        this.hostTextRange = host.getTextRange();
        this.hostFile = host.getContainingFile();
        this.processedReferenceTargets = new THashSet();
    }
}

