/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.javascript.debugger.execution;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.RunProfileStarter;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.runners.AsyncGenericProgramRunner;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.Function;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.jetbrains.javascript.debugger.execution.DebuggableRunProfileState;
import java.net.InetSocketAddress;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.DebuggableRunConfiguration;

public final class DebuggableProgramRunner
extends AsyncGenericProgramRunner {
    @NotNull
    protected Promise<RunProfileStarter> prepare(@NotNull ExecutionEnvironment environment, @NotNull RunProfileState state) throws ExecutionException {
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/jetbrains/javascript/debugger/execution/DebuggableProgramRunner", "prepare"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/jetbrains/javascript/debugger/execution/DebuggableProgramRunner", "prepare"));
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        final DebuggableRunConfiguration configuration = (DebuggableRunConfiguration)environment.getRunProfile();
        final InetSocketAddress socketAddress = configuration.computeDebugAddress();
        Function<ExecutionResult, RunProfileStarter> starter = new Function<ExecutionResult, RunProfileStarter>(){

            public RunProfileStarter fun(final @Nullable ExecutionResult executionResult) {
                return new RunProfileStarter(){

                    @Nullable
                    public RunContentDescriptor execute(@NotNull RunProfileState state, final @NotNull ExecutionEnvironment environment) throws ExecutionException {
                        if (state == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/jetbrains/javascript/debugger/execution/DebuggableProgramRunner$1$1", "execute"));
                        }
                        if (environment == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/jetbrains/javascript/debugger/execution/DebuggableProgramRunner$1$1", "execute"));
                        }
                        return XDebuggerManager.getInstance((Project)environment.getProject()).startSession(environment, new XDebugProcessStarter(){

                            @NotNull
                            public XDebugProcess start(@NotNull XDebugSession session) throws ExecutionException {
                                if (session == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/javascript/debugger/execution/DebuggableProgramRunner$1$1$1", "start"));
                                }
                                XDebugProcess xDebugProcess = configuration.createDebugProcess(socketAddress, session, executionResult, environment);
                                if (xDebugProcess == null) {
                                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/javascript/debugger/execution/DebuggableProgramRunner$1$1$1", "start"));
                                }
                                return xDebugProcess;
                            }
                        }).getRunContentDescriptor();
                    }
                };
            }
        };
        if (state instanceof DebuggableRunProfileState) {
            Promise promise2 = ((DebuggableRunProfileState)state).execute(socketAddress.getPort()).then((Function)starter);
            if (promise2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/javascript/debugger/execution/DebuggableProgramRunner", "prepare"));
            }
            return promise2;
        }
        Promise promise3 = Promise.resolve((Object)starter.fun(null));
        if (promise3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/javascript/debugger/execution/DebuggableProgramRunner", "prepare"));
        }
        return promise3;
    }

    @NotNull
    public String getRunnerId() {
        if ("debuggableProgram" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/javascript/debugger/execution/DebuggableProgramRunner", "getRunnerId"));
        }
        return "debuggableProgram";
    }

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        boolean canRun;
        if (executorId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executorId", "com/jetbrains/javascript/debugger/execution/DebuggableProgramRunner", "canRun"));
        }
        if (profile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profile", "com/jetbrains/javascript/debugger/execution/DebuggableProgramRunner", "canRun"));
        }
        boolean bl = canRun = DefaultDebugExecutor.EXECUTOR_ID.equals(executorId) && profile instanceof DebuggableRunConfiguration;
        if (canRun && profile instanceof DebuggableRunConfiguration.RunConfigurationWithConditionalRun) {
            return ((DebuggableRunConfiguration.RunConfigurationWithConditionalRun)profile).canRun(executorId, profile);
        }
        return canRun;
    }
}

