/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.javascript.debugger.scripts;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.Consumer;
import org.jetbrains.annotations.NotNull;

public abstract class ConsumerOnEdt<T>
implements Consumer<T> {
    private final Project project;

    protected ConsumerOnEdt(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/javascript/debugger/scripts/ConsumerOnEdt", "<init>"));
        }
        this.project = project;
    }

    protected abstract void consume(@NotNull Project var1, T var2);

    public final void consume(final T t) {
        if (this.project.isDisposed()) {
            return;
        }
        if (ApplicationManager.getApplication().isDispatchThread()) {
            this.consume(this.project, t);
        } else {
            AppUIUtil.invokeLaterIfProjectAlive((Project)this.project, (Runnable)new Runnable(){

                @Override
                public void run() {
                    ConsumerOnEdt.this.consume(ConsumerOnEdt.this.project, t);
                }
            });
        }
    }
}

