/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.javascript.debugger.scripts;

import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.util.io.socketConnection.ConnectionStatus;
import com.jetbrains.javascript.debugger.JavaScriptDebugProcess;
import com.jetbrains.javascript.debugger.scripts.FileInfo;
import com.jetbrains.javascript.debugger.scripts.FileNode;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.connection.VmConnection;

class RootScriptsNode
extends FileNode {
    RootScriptsNode(JavaScriptDebugProcess<? extends VmConnection> debugProcess, FileInfo fileInfo, @Nullable NodeDescriptor parent) {
        super("<root>", fileInfo, debugProcess, parent);
    }

    public boolean isAutoExpandNode() {
        return true;
    }

    @Override
    protected SimpleNode[] buildChildren() {
        if (this.debugProcess.getConnection().getState().getStatus() != ConnectionStatus.CONNECTED) {
            return this.formatMessage("Not connected", "to");
        }
        if (!this.fileInfo.hasChildren()) {
            return this.formatMessage("No scripts loaded", "by");
        }
        return super.buildChildren();
    }

    private SimpleNode[] formatMessage(String text, String suffix) {
        WebBrowser browser = this.debugProcess.getConnection().getBrowser();
        final String message = browser == null ? text : text + " " + suffix + " " + browser.getName();
        return new SimpleNode[]{new SimpleNode((SimpleNode)this){
            {
                super(x0);
                this.getTemplatePresentation().addText(message, SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }

            public SimpleNode[] getChildren() {
                return NO_CHILDREN;
            }
        }};
    }
}

