/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.javascript.debugger.scripts;

import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.Function;
import com.intellij.util.Url;
import com.jetbrains.javascript.debugger.FileUrlMapper;
import com.jetbrains.javascript.debugger.scripts.SourceContentFile;
import com.jetbrains.javascript.debugger.scripts.VmScriptFile;
import gnu.trove.TIntObjectHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.ScriptManagerBaseKt;
import org.jetbrains.debugger.Vm;

public final class Scripts {
    private static final Key<VmScriptFile> FILE_KEY = Key.create((String)"actual source file");
    private static final Key<TIntObjectHashMap<VirtualFile>> SOURCE_CONTENT_KEY = Key.create((String)"actual source content");

    private Scripts() {
    }

    @NotNull
    public static Promise<VirtualFile> ensureDownloaded(final @NotNull VmScriptFile file, @Nullable Vm vm) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/javascript/debugger/scripts/Scripts", "ensureDownloaded"));
        }
        if (file.isLoaded()) {
            Promise promise2 = Promise.resolve((Object)((Object)file));
            if (promise2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/javascript/debugger/scripts/Scripts", "ensureDownloaded"));
            }
            return promise2;
        }
        if (vm == null) {
            Promise promise3 = Promise.reject((String)"Vm null");
            if (promise3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/javascript/debugger/scripts/Scripts", "ensureDownloaded"));
            }
            return promise3;
        }
        Promise promise4 = vm.getScriptManager().getSource(file.getScript()).then((Function)new Function<String, VirtualFile>(){

            public VirtualFile fun(String source) {
                file.setContent(null, StringUtilRt.convertLineSeparators((String)source), true);
                return file;
            }
        });
        if (promise4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/javascript/debugger/scripts/Scripts", "ensureDownloaded"));
        }
        return promise4;
    }

    @NotNull
    public static Promise<VirtualFile> getResolvedFile(final @NotNull Script script, @Nullable Vm vm) {
        if (script == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "script", "com/jetbrains/javascript/debugger/scripts/Scripts", "getResolvedFile"));
        }
        if (vm == null) {
            Promise promise2 = Promise.reject((String)"Vm null");
            if (promise2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/javascript/debugger/scripts/Scripts", "getResolvedFile"));
            }
            return promise2;
        }
        VmScriptFile file = (VmScriptFile)((Object)FILE_KEY.get((UserDataHolder)script));
        if (file != null) {
            Promise<VirtualFile> promise3 = Scripts.ensureDownloaded(file, vm);
            if (promise3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/javascript/debugger/scripts/Scripts", "getResolvedFile"));
            }
            return promise3;
        }
        Promise promise4 = vm.getScriptManager().getSource(script).then((Function)new Function<String, VirtualFile>(){

            public VirtualFile fun(String source) {
                return Scripts.createFile(script, source);
            }
        });
        if (promise4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/javascript/debugger/scripts/Scripts", "getResolvedFile"));
        }
        return promise4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public static VirtualFile createFile(@NotNull Url url, @NotNull UserDataHolder script, @NotNull String normalizedSource, int sourceIndex) {
        void var6_8;
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/jetbrains/javascript/debugger/scripts/Scripts", "createFile"));
        }
        if (script == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "script", "com/jetbrains/javascript/debugger/scripts/Scripts", "createFile"));
        }
        if (normalizedSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "normalizedSource", "com/jetbrains/javascript/debugger/scripts/Scripts", "createFile"));
        }
        TIntObjectHashMap map = (TIntObjectHashMap)SOURCE_CONTENT_KEY.get(script);
        if (map == null) {
            map = new TIntObjectHashMap();
            SOURCE_CONTENT_KEY.set(script, (Object)map);
        }
        TIntObjectHashMap tIntObjectHashMap = map;
        // MONITORENTER : tIntObjectHashMap
        VirtualFile virtualFile = (VirtualFile)map.get(sourceIndex);
        if (virtualFile == null) {
            SourceContentFile sourceContentFile = script instanceof Script ? new VmScriptFile(url, (Script)script, normalizedSource) : new SourceContentFile(url, normalizedSource);
            map.put(sourceIndex, (Object)sourceContentFile);
        }
        void v0 = var6_8;
        // MONITOREXIT : tIntObjectHashMap
        if (v0 != null) return v0;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/javascript/debugger/scripts/Scripts", "createFile"));
    }

    @NotNull
    public static VmScriptFile createFile(@NotNull Script script, @Nullable String source) {
        String normalizedSource;
        if (script == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "script", "com/jetbrains/javascript/debugger/scripts/Scripts", "createFile"));
        }
        VmScriptFile file = (VmScriptFile)((Object)FILE_KEY.get((UserDataHolder)script));
        String string = normalizedSource = source == null ? "" : StringUtilRt.convertLineSeparators((String)source);
        if (file == null) {
            file = new VmScriptFile(script, normalizedSource);
            file = (VmScriptFile)((Object)script.putUserDataIfAbsent(FILE_KEY, (Object)file));
        } else if (source != null) {
            file.setContent(null, normalizedSource, true);
        }
        VmScriptFile vmScriptFile = file;
        if (vmScriptFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/javascript/debugger/scripts/Scripts", "createFile"));
        }
        return vmScriptFile;
    }

    @NotNull
    public static FileType getFileType(@NotNull Url url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/jetbrains/javascript/debugger/scripts/Scripts", "getFileType"));
        }
        FileType type = FileTypeRegistry.getInstance().getFileTypeByFileName(url.getPath());
        if (type != FileTypes.UNKNOWN) {
            FileType fileType = type;
            if (fileType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/javascript/debugger/scripts/Scripts", "getFileType"));
            }
            return fileType;
        }
        for (FileUrlMapper fileUrlMapper : (FileUrlMapper[])FileUrlMapper.EP_NAME.getExtensions()) {
            type = fileUrlMapper.getFileType(url);
            if (type == null || type == FileTypes.UNKNOWN) continue;
            FileType fileType = type;
            if (fileType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/javascript/debugger/scripts/Scripts", "getFileType"));
            }
            return fileType;
        }
        JavaScriptFileType javaScriptFileType = JavaScriptFileType.INSTANCE;
        if (javaScriptFileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/javascript/debugger/scripts/Scripts", "getFileType"));
        }
        return javaScriptFileType;
    }

    @Nullable
    public static VirtualFile findRemoteFile(@NotNull Script script, @NotNull Url url) {
        if (script == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "script", "com/jetbrains/javascript/debugger/scripts/Scripts", "findRemoteFile"));
        }
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/jetbrains/javascript/debugger/scripts/Scripts", "findRemoteFile"));
        }
        Object file = null;
        if (url.isInLocalFileSystem()) {
            file = LocalFileSystem.getInstance().findFileByPath(url.getPath());
        } else if (!ScriptManagerBaseKt.isSpecial((Url)url)) {
            file = VirtualFileManager.getInstance().findFileByUrl(url.toExternalForm());
        }
        if (file == null && url == script.getUrl()) {
            file = Scripts.createFile(script, null);
        }
        return file;
    }
}

